<div class="tab-pane tab_holder {!! !is_null($reportType) && $reportType =='Route' ? 'active' : '' !!}" id="route"
     style="padding: 10px 0;">
    <div class="col-lg-12" style="margin-bottom: 10px;">
        {!!Form::open(['method' => 'GET',  'url' => url("crew/report?reportType=Route"),'class'=>"form-inline", 'id' => 'formRoute' ]) !!}
        <div class="form-group margin_right">
            <label class="control-label">@lang("content.crew")</label>
            {!! Form::select('crew', ['fcm'=>'Flight Crew','ccm'=>'Cabin Crew'], $crewType, ['class'=>'form-control input_roster crew']) !!}
        </div>
        <div class="form-group margin_right">
            <label class="control-label">@lang("content.designation")</label>
            {!! Form::select('designation', $designationList , \request("destination"), ['class'=>'form-control input_roster crew_designation']) !!}
        </div>

        <div class="form-group margin_right">
            <label class="control-label">@lang("content.report_date")</label>
            {!! Form::input('text', 'routesReportDate', $date, ['class'=>'dateFrom form-control', 'id' => 'routesReportDate']) !!}
        </div>

        <div class="form-group">
            {{--{!! Form::hidden('reportType', 'Route') !!}--}}
            {!! Form::input('submit', 'submit','Submit',[ 'class' => "btn btn-primary"]) !!}
        </div>
        {!!Form::close()!!}
    </div>

    <div class="col-lg-12" style="margin-bottom: 50px; padding: 0">

        @php $sectors_dyu = ['DYU-FRA', 'DYU-IST', 'DYU-DXB', 'DYU-URC', 'DYU-ALA', 'DYU-DME', 'DYU-LED','DYU-IKT','DYU-KRR', 'DYU-KJA','DYU-LBD', 'DYU-SVX', 'DYU-KZN', 'DYU-REN'] @endphp
        @php $sectors_dyu_stations = ['FRA', 'IST', 'DXB', 'URC', 'ALA', 'DME', 'LED','IKT', 'KRR', 'KJA','LBD','SVX', 'KZN', 'REN'] @endphp
        @php $sectors_lbd = ['LBD-DME', 'LBD-LED', 'LBD-KRR', 'LBD-KJA', 'LBD-REN', 'LBD-KZN','LBD-AER', 'LBD-HMA','LBD-NJC', 'LBD-TJM'] @endphp
        @php $sectors_lbd_stations = ['DME', 'LED', 'KRR', 'KJA', 'REN', 'KZN','AER', 'HMA', 'NJC', 'TJM'] @endphp
        @php $reportName = ['Crew Hours Report'] @endphp
        @php $columnNames[0] = ['No', 'Last Name', 'First Name', 'Designation', ['Counter' => 2], ['DYU Routes' => 14], ['LBD Routes' => 10] ] @endphp
        @php $columnNames[1] = ['', '', '', '', 'Stand-by', 'DHC'] @endphp
        @php $exportArray = [] @endphp

        @if (count($crew))
            <div class="clearfix"></div>
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                    <h2>@lang("content.year_to_date")</h2>

                </header>

                <!-- widget div-->
                <div style="width: 100%;overflow: auto;">

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding">
                        <table class="table table-bordered table-striped table-hover" id="routesTable" style="">
                            <thead>
                            <tr>
                                <th>No</th>
                                <th></th>
                                <th>@lang("content.first_name")</th>
                                <th>@lang("content.last_name")</th>
                                <th>@lang("content.base")</th>
                                <th>@lang("content.designation")</th>
                                <th>SB</th>
                                <th>DHC</th>
                                @php $aRoutes = [] @endphp
                                @foreach($routes as $route)
                                    @foreach($crew as $id => $each)
                                        @if (isset($crewHours[$id]['flight_history'][$route->route_from]) || isset($crewHours[$id]['flight_history'][$route->route_to]))
                                            <th data-center>{{  $route->route_from  }}</th>
                                            @php $aRoutes[] = $route @endphp
                                            @break
                                        @endif
                                    @endforeach
                                @endforeach
                            </tr>
                            </thead>
                            <tbody>
                            @php $i = 0; @endphp
                            @foreach($crew as $id => $each)
                                @php $picture = $each->thumb ? '/storage/users/'.$each->thumb : '/assets/img/default-user-picture.png'; @endphp
                                <tr class="{{ $each->is_contractor ? 'contractorCrew' : ''  }} ">
                                    <td>{{ $i + 1 }} </td>
                                    <td><a href="{{ route("homepage")."#". url("crew/profile?id={$each->id}") }}" target="_blank">
                                            <img src="{{ $picture }}" class="img-thumbnail thumb_report_prev"/>
                                        </a>
                                    </td>
                                    <td><a href="{{ route("homepage")."#". url("crew/profile?id={$each->id}") }}" target="_blank">{{ $each->first_name }}</a></td>
                                    <td><a href="{{ route("homepage")."#". url("crew/profile?id={$each->id}") }}" target="_blank">{{ $each->last_name }}</a></td>
                                    @php $crewDesignation = Crew_Designation($crewType, $each) @endphp
                                    @php $standbyCounter = isset($crewHours[$id]['is_standby']) ? $crewHours[$id]['is_standby'] : 0 @endphp
                                    @php $dhcCounter = isset($crewHours[$id]['is_dhc']) ? $crewHours[$id]['is_dhc'] : 0 @endphp
                                    <td>{{ $each->location ? $each->location->airport->iata : '' }}</td>
                                    <td>{{ $crewDesignation }}</td>
                                    <td data-center>{{ $standbyCounter  }} </td>
                                    <td data-center>{{ $dhcCounter  }} </td>

                                    @foreach($aRoutes as $route)
                                        <td data-center>{{
                                        isset($crewHours[$id]['flight_history'][$route->route_from]) ? $crewHours[$id]['flight_history'][$route->route_from] :
                                         (isset($crewHours[$id]['flight_history'][$route->route_to]) ? $crewHours[$id]['flight_history'][$route->route_to] : 0)
                                         }} </td>
                                    @endforeach
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
