<div class="tab-pane tab_holder {{ ($reportType && $reportType === 'Monthly_Hours') ? 'active' : '' }}" id="monthlyHours">
        @php $dateFrom = \request("monthlyHoursPeriodFrom") ? \request("monthlyHoursPeriodFrom") : date('Y-m-d', strtotime('first day of this month')) @endphp
        @php $dateTo = \request("monthlyHoursPeriodTo") ? \request("monthlyHoursPeriodTo") : date('Y-m-d') @endphp

        <div class="col-md-12" style="margin-bottom: 10px;">
            {!!Form::open(['method' => 'GET',  'url' => url("crew/report?reportType=Monthly_Hours"),'class'=>"form-inline", 'id' => 'formMonthlyHours' ]) !!}
            <div class="form-group marginBottomRight">
                <label class="control-label">@lang("content.crew")</label>
                {!! Form::select('crew', ['fcm'=>'Flight Crew','ccm'=>'Cabin Crew'], $crewType, ['class'=>'form-control input_roster crew']) !!}
            </div>
            <div class="form-group marginBottomRight">
                <label class="control-label">@lang("content.designation")</label>
                {!! Form::select('designation', $designationList , \request("destination"), ['class'=>'form-control input_roster crew_designation']) !!}
            </div>
            <div class="form-group marginBottomRight">
                <label>{!! Form::radio('dateSearch','fromTo', !\request("dateSearch") || \request("dateSearch") == 'fromTo') !!} @lang("content.period") @lang("content.from")</label>
                {!! Form::input('text', 'monthlyHoursPeriodFrom', $dateFrom, ['class'=>'dateFrom form-control']) !!}
                <label class="control-label">@lang("content.to")</label>
                {!! Form::input('text', 'monthlyHoursPeriodTo', $dateTo, ['class'=>'dateTo form-control']) !!}
            </div>

            <div class="form-group marginBottomRight">
                <label>{!! Form::radio('dateSearch','monthYear', \request("dateSearch") == 'monthYear') !!} @lang("content.month")</label>
                <div class="btn-group">
                    {!! Form::select('month[]', $monthNames, \request("month"), ['multiple'=>'multiple', 'class'=>'multiselect']) !!}
                </div>
            </div>

            <div class="form-group marginBottomRight">
                <label for="year" class="control-label">@lang("content.year")</label>
                <div class="btn-group">
                    {!! Form::select('year', $years, getSelectedYear(), ['class'=>'singleselect']) !!}
                </div>
            </div>

            <div class="form-group marginBottomRight">
                {{--{!! Form::hidden('reportType', 'Monthly_Hours') !!}--}}
                {!! Form::input('submit', 'submit','Submit',[ 'class' => "btn btn-primary"]) !!}
            </div>
            {!! Form::close() !!}
        </div>

        @if (count($crew) && count($crewPeriodHours))
            <div class="clearfix"></div>
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
            <!-- widget options:
            usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

            data-widget-colorbutton="false"
            data-widget-editbutton="false"
            data-widget-togglebutton="false"
            data-widget-deletebutton="false"
            data-widget-fullscreenbutton="false"
            data-widget-custombutton="false"
            data-widget-collapsed="true"
            data-widget-sortable="false"

            -->
            <header>
                <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                <h2>@lang("content.list") </h2>

            </header>

            <!-- widget div-->
            <div style="width: 100%;overflow: auto;">

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->

                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body no-padding">
                    <table class="table table-bordered table-striped table-hover" data-excel='1'>
                        <thead>
                        <tr>
                            <th rowspan="2">No</th>
                            <th rowspan="2"></th>
                            <th rowspan="2">@lang("content.first_name")</th>
                            <th rowspan="2">@lang("content.last_name")</th>
                            <th rowspan="2">@lang("content.base")</th>
                            <th rowspan="2">@lang("content.designation")</th>
                            <th rowspan="2">@lang("content.flight_hours")</th>
                            @if (\request("dateSearch") && \request("dateSearch") == 'monthYear')
                                <th colspan="{{ count($monthArray) }}">@lang("content.monthly_hours")</th>
                            @endif
                            <th colspan="3">@lang("content.not_available")</th>
                        </tr>
                        <tr>
                            @if (\request("dateSearch") && \request("dateSearch") == 'monthYear')
                                @foreach($monthArray as $month)
                                    <th>{{ $month }}</th>
                                @endforeach
                            @endif
                            <th>@lang("content.from")</th>
                            <th>@lang("content.to")</th>
                            <th>@lang("content.reason")</th>
                        </tr>
                        </thead>
                        <tbody>
                        @php $i = 0 @endphp
                        @foreach($crew as $id=>$each)
                            @php $i++ @endphp
                            @php $designation = Crew_Designation($crewType, $each) @endphp
                            @php $picture = !is_null($each->thumb) ? '/storage/users/'.$each->thumb : '/assets/img/default-user-picture.png' @endphp
                            @php $hoursTotal = isset($crewPeriodHours[$id]) ? round($crewPeriodHours[$id], 2) : 0 @endphp
                            <tr class="{{ $each->is_contractor ? 'contractorCrew' : '' }}">
                                <td>{{ $i }}</td>
                                <td>
                                    <a href="{{ route("homepage")."#".url("crew/profile?id={$each->id}") }}" target="_blank">
                                        <img src="{{ $picture }}" class="img-thumbnail thumb_report_prev"/>
                                    </a>
                                </td>
                                <td><a href="{{ route("homepage")."#". url("crew/profile?id={$each->id}") }}" target="_blank">{{$each->first_name}}</a></td>
                                <td><a href="{{ route("homepage")."#". url("crew/profile?id={$each->id}") }}" target="_blank">{{$each->last_name}}</a></td>
                                <td>{{ $each->location ? $each->location->airport->iata : '' }}</td>
                                <td>{{ $designation }}</td>
                                <td> {{ $hoursTotal }}</td>
                                @if (\request("dateSearch") && \request("dateSearch") == 'monthYear')
                                    @foreach($monthArray as $m => $month)
                                        @php $last['last28days'] = isset($crewPeriodMonthlyHours[$id][$month]) ? round($crewPeriodMonthlyHours[$id][$month], 2) : 0; @endphp
                                        @php $class = Get_Limitation_Class($last); @endphp
                                        @if (isset($crewPeriodMonthlyHours[$id][$month]))
                                            <td class="{{$class['last28days']}}">{{ round($crewPeriodMonthlyHours[$id][$month], 2) }}</td>
                                        @else
                                            <td>0</td>
                                        @endif
                                    @endforeach
                                @endif

                                @php $from = '' @endphp
                                @php $to = '' @endphp
                                @php $reason = '' @endphp

                                @forelse($each->userHistory as $history)
                                    @if (!(strtotime($history->condition_to) < strtotime($dateFrom) || strtotime($history->condition_from) > strtotime($dateTo)))
                                        @php $from .= $history->condition_from.'<br/>' @endphp
                                        @php $to .= $history->condition_to.'<br/>' @endphp
                                        @php $reason .= ($history->condition_id ? $conditions[$history->condition_id] : '-').'<br/>' @endphp
                                    @endif
                                @empty
                                @endforelse

                                <td>{!! $from !!}</td>
                                <td>{!! $to !!}</td>
                                <td>{!! $reason !!}</td>

                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    @endif
</div>
