<div class="tab-pane tab_holder {!! !$reportType && $reportType =='Late_No_Show' ? 'active' : '' !!}" id="lateNoShow" style="padding: 10px 0;">

    <div class="col-lg-12" style="margin-bottom: 10px">
        {!! Form::open(['method' => 'GET',  'url' => url("crew/report?reportType=Late_No_Show"), 'class' => 'form-inline', 'id' => 'formLateNoShow']) !!}

            {!! Form::label('crew', trans("content.crew")) !!}
            {!! Form::select('crew', ['fcm'=>'Flight Crew','ccm'=>'Cabin Crew'], $crewType, ['class'=>'form-control input_roster crew']) !!}
            {{--{!! Form::hidden('reportType', 'Late_No_Show') !!}--}}
            {!! Form::label('dateFrom', trans("content.from")) !!}
            {!! Form::text('dateFrom', \request("dateFrom") ? \request("dateFrom") : date('Y-m-d'), ['class' => 'form-control dateFrom inputDateSmall', 'required' => true]) !!}
            {!! Form::label('dateFrom', trans("content.to")) !!}
            {!! Form::text('dateTo', \request("dateTo") ? \request("dateTo") : date('Y-m-d'), ['class' => 'form-control dateTo inputDateSmall', 'required' => true]) !!}
            {!! Form::label('perPage', trans("content.per_page")) !!}
            {!! Form::select('perPage', [10 => 10, 20 => 20, 50 => 50, '' => 'All'], \request("perPage"), ['class' => 'form-control']) !!}
            {!! Form::submit('Submit', ['class' => 'btn btn-primary']) !!}

        {{--{!! Form::label('filter', 'Filter', ['style' => 'margin-left: 50px']) !!}
        {!! Form::select('filter', ['' => 'All',  'withinLimit' =>'Within Limit', 'crossedLimit'=>'Crossed Limit' ], '', ['class' => 'form-control']) !!}
        {!! Form::button('Apply', ['class' => 'btn btn-warning', 'id' => 'applyFilter']) !!}--}}
        {!! Form::close() !!}
    </div>

    <div class="col-lg-12" id="message-block"></div>
    @if ($reportType =='Late_No_Show')
        <div class="col-lg-12 alert alert-dismissible alert-info">
            <button type="button" class="close" data-dismiss="alert">×</button>
            @lang("content.found") {!! count($lateNoShow) !!} @lang("content.crew")
        </div>
    @endif
    @if (count($lateNoShow))
        <div class="clearfix"></div>
        <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
            <!-- widget options:
            usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

            data-widget-colorbutton="false"
            data-widget-editbutton="false"
            data-widget-togglebutton="false"
            data-widget-deletebutton="false"
            data-widget-fullscreenbutton="false"
            data-widget-custombutton="false"
            data-widget-collapsed="true"
            data-widget-sortable="false"

            -->
            <header>
                <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                <h2>@lang("content.list") </h2>

            </header>

            <!-- widget div-->
            <div style="width: 100%;overflow: auto;">

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->

                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body no-padding">
                    
                    @php $eachId = 0 @endphp
                    <table class="table table-bordered table-striped table-hover" style="margin: 0 0 10px 0 ">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th data-sorter="false">@lang("content.crew_information")Crew Information</th>
                            <th>#</th>
                            <th>@lang("content.departure")</th>
                            <th>@lang("content.flight_number")</th>
                            <th>@lang("content.sector")</th>
                            <th>STD</th>
                            <th>@lang("content.report_time")</th>
                            <th>@lang("content.actual_report_time")</th>
                            <th>@lang("content.difference")</th>
                            <th>@lang("content.status")</th>
                            <th>@lang("content.reason")</th>
                        </tr>
                        </thead>
                        <tbody>
                        @php $currentPage = \request("page") ? \request("page") - 1 : 0 @endphp
                        @php $perPage = \request("perPage") ? \request("perPage") : count($lateNoShow) @endphp
                        @php $k = 0 @endphp
                        @foreach($lateNoShow as $i => $crew)
                            @if ($i >= $currentPage * $perPage && $i < $currentPage * $perPage + $perPage)
            
                                @if (!isset($exportArray[$i]))
                                    @php $exportArray[$k] = [] @endphp
                                @endif
            
                                @foreach($crew as $j => $each)
                                    @if ($each->report_time)
                                        @php $reportTime = Add_Minutes_To_DateTime($each->std, 75, null, TRUE) @endphp
                                        @php $timeDiff = DateTimeDifference($each->report_time, $reportTime) @endphp
                                        @php $timeDiffStr = $timeDiff['H'].':'.$timeDiff['i'] @endphp
                                        @php $actualReportTime = date('H:i', strtotime($each->report_time)) @endphp
                                        @php $totalMins = $timeDiff['total'] @endphp
                                    @else
                                        @php $timeDiffStr = "&mdash;" @endphp
                                        @php $actualReportTime = "&mdash;" @endphp
                                        @php $totalMins = 0 @endphp
                                    @endif
            
                                    @if ($j == 0)
                                        @php $picture = $each->thumb ? 'users/'.$each->thumb : 'default-user-picture.png' @endphp
            
                                        <tr class="{!! $each->is_contractor ? 'contractorCrew' : '' !!}">
                                            <td class="vertical-center text-center" rowspan="{!! count($crew) !!}">{!! $i + 1 !!}</td>
            
                                            <td rowspan="{!! count($crew) !!}">
                                                <div class="col-sm-12">
                                                    <div class="col-xs-3 vertical-center" style="margin: 10px 0">
                                                        <a href="{!!route("homepage")."#". url('/')!!}/crew/profile?id={!! $each->user_id !!}" target="_blank">
                                                            <img src="{!!route("homepage")."#". url('/').'/assets/img/'.$picture!!}" width="60px" />
                                                        </a>
                                                    </div>
                                                    <div class="col-xs-9">
                                                        <h5><a href="{!! route("homepage")."#". url("/") !!}/crew/profile?id={!! $each->user_id !!}" target="_blank">{!! $each->first_name." ".$each->last_name !!}</a></h5>
            
                                                        @if ($crewType == 'fcm')
                                                            <h5>{!! (isCaptain($each) ? 'Captain' : 'First Officer') !!}</h5>
                                                        @else
                                                            <h5>{!! (isPurser($each) ? 'Purser' : 'Flight Attendant') !!}</h5>
                                                        @endif
                                                        <h5>{!! $each->location !!}</h5>
                                                    </div>
                                                </div>
                                            </td>
                                        @else
                                            @php $exportArray[$k] = [ '', '', '', ''] @endphp
                                            <tr class="{!! $each->is_contractor ? 'contractorCrew' : '' !!}">
                                        @endif
                                        <td>{!! $j +1 !!}</td>
                                        <td>{!! date('d M Y', strtotime($each->std)) !!}</td>
                                        <td><a target="_blank" href="{!! route("homepage")."#". url("/") !!}/flight/details?id={!! $each->flight_id !!}">{!! $CURRENT_IATA_CODE.' '.$each->flight_number !!}</a></td>
                                        <td>{!! $each->departure_airport."-".$each->arrival_airport !!}</td>
                                        <td>{!! date('H:i', strtotime($each->std)) !!}</td>
                                        @if ($each->reason && in_array($each->reason, ['no_show', 'sick', 'roster_not_received']))
                                            <td>{!! "&mdash;" !!}</td>
                                            <td>{!! "&mdash;" !!}</td>
                                            <td>{!! "&mdash;" !!}</td>
                                            <td>{!!  'No Show'!!}</td>
                                            <td>{!! ($each->reason == 'no_show' ? "" : $reasons[$each->reason]) !!}</td>
                                        @else
                                            <td>{!! date('H:i', strtotime($reportTime)) !!}</td>
                                            <td>{!! $actualReportTime !!}</td>
                                            <td class="{!! $totalMins < 75 ? 'red' : 'green'!!}">{!! $timeDiffStr !!}</td>
                                            <td>{!! $reasons[$each->reason] !!}</td>
                                            <td></td>
                                        @endif
                                    </tr>
                                @endforeach
                            @endif
                        @endforeach
    
                    </tbody>
                </table>

{{--            {!! $pagination->appends(request()->all())->render(); !!}--}}
            </div>
        </div>
    </div>
    @endif

</div>