<div class="tab-pane tab_holder {{ !$reportType || $reportType === 'Hours' ? 'active' : '' }}" id="hours">
    <div class="col-md-12" style="margin-bottom: 10px;">

        {!!Form::open(['method' => 'GET', 'url' => url("crew/report?reportType=Hours"), 'class'=>"form-inline", 'id' => 'formHours' ]) !!}
        <div class="form-group margin_right">
            <label class="control-label">@lang("content.crew")</label>
            {!! Form::select('crew', ['fcm'=>'Flight Crew','ccm'=>'Cabin Crew'], $crewType, ['class'=>'form-control input_roster crew']) !!}
        </div>
        <div class="form-group margin_right">
            <label class="control-label">@lang("content.designation")</label>
            {!! Form::select('designation', $designationList , \request("destination"), ['class'=>'form-control input_roster crew_designation']) !!}
        </div>
        <div class="form-group margin_right">
            <label class="control-label">@lang("content.report_date")</label>
            {!! Form::input('text', 'hoursReportDate', $date, ['class'=>'dateFrom form-control', 'id'=>'hoursReportDate']) !!}
        </div>

        <div class="form-group">
{{--            {!! Form::hidden('reportType', 'Hours') !!}--}}
            {!! Form::input('submit', 'submit','Submit',[ 'class' => "btn btn-primary"]) !!}
        </div>
        {!!Form::close() !!}
    </div>

    @if (count($crew) && count($crewHours))
        <div class="clearfix"></div>
        <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
            <!-- widget options:
            usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

            data-widget-colorbutton="false"
            data-widget-editbutton="false"
            data-widget-togglebutton="false"
            data-widget-deletebutton="false"
            data-widget-fullscreenbutton="false"
            data-widget-custombutton="false"
            data-widget-collapsed="true"
            data-widget-sortable="false"

            -->
            <header>
                <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                <h2>@lang("content.list") </h2>

            </header>

            <!-- widget div-->
            <div>

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->

                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body no-padding">
                    <table class="table table-bordered table-striped table-hover" id="hoursTable">
                        <thead>
                        <tr>
                            <th rowspan="2">No</th>
                            <th rowspan="2"></th>
                            <th rowspan="2">@lang("content.first_name")</th>
                            <th rowspan="2">@lang("content.last_name")</th>
                            <th rowspan="2">@lang("content.base")</th>
                            <th rowspan="2">@lang("content.designation")</th>
                            <th colspan="3">@lang("content.flight_hours")</th>
                            <th colspan="3">@lang("content.not_available")</th>
                        </tr>
                        <tr>
                            <th>7 @lang("content.days")</th>
                            <th>28 @lang("content.days")</th>
                            <th>@lang("content.year_to_date")</th>
                            <th>@lang("content.from")</th>
                            <th>@lang("content.to")</th>
                            <th>@lang("content.reason")</th>
                        </tr>
                        </thead>
                        <tbody>
                        @php $i = 0 @endphp
                        @foreach($crew as $id => $each)
                            @php $i++ @endphp
                            @php $designation = Crew_Designation($crewType, $each) @endphp
                            @php $picture = $each->thumb ? '/storage/users/' . $each->thumb : '/assets/img/default-user-picture.png' @endphp
                            @php $last['last7days'] = isset($crewHours[$id]['last7days']) ? round($crewHours[$id]['last7days'], 1) : 0 @endphp
                            @php $last['last28days'] = isset($crewHours[$id]['last28days']) ? round($crewHours[$id]['last28days'], 1) : 0 @endphp
                            @php $last['yearToDate'] = isset($crewHours[$id]['yearToDate']) ? round($crewHours[$id]['yearToDate'], 1) : 0 @endphp
                            @php $class = Get_Limitation_Class($last) @endphp

                            <tr class="{{ $each->is_contractor ? 'contractorCrew' : '' }}">
                                <td>{{ $i }}</td>
                                <td>
                                    <a href="{{ route("homepage")."#". url("crew/profile?id={$each->id}") }}" target="_blank">
                                        <img src="{{ $picture }}" class="img-thumbnail thumb_report_prev"/>
                                    </a>
                                </td>
                                <td><a href="{{ route("homepage")."#". url("crew/profile?id={$each->id}") }}" target="_blank">{{$each->first_name}}</a></td>
                                <td><a href="{{ route("homepage")."#". url("crew/profile?id={$each->id}") }}" target="_blank">{{$each->last_name}}</a></td>
                                <td>{{ $each->location ? $each->location->airport->iata : '' }}</td>
                                <td>{{ $designation }}</td>
                                <td class="{{$class['last7days']}}"> {{ round($last['last7days'], 1) }}</td>
                                <td class="{{$class['last28days']}}">{{ round($last['last28days'],1) }}</td>
                                <td class="{{$class['yearToDate']}}">{{ round($last['yearToDate'],1) }}</td>
                                @php $from = '' @endphp
                                @php $to = '' @endphp
                                @php $reason = '' @endphp
                                @forelse($each->userHistory as $history)
                                    @if (strtotime($date) <= strtotime($history->to))
                                        @php $from .= $history->from.'<br/>' @endphp
                                        @php $to .= $history->to.'<br/>' @endphp
                                        @php $reason .= (isset($conditions[$history->condition_id]) ? $conditions[$history->condition_id] : "").'<br/>' @endphp
                                    @endif
                                @empty
                                @endforelse

                                <td>{{ $from }}</td>
                                <td>{{ $to }}</td>
                                <td>{{ $reason }}</td>

                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    @endif
</div>
