<div class="tab-pane tab_holder {!! $reportType && $reportType == 'FDP' ? 'active' : '' !!}" id="fdp-calculator" style="padding: 10px 0;">

    <div class="col-lg-12" style="margin-bottom: 10px">
        <div class="col-lg-6">
            {!!Form::open(['method' => 'GET', 'url' => url("crew/report?reportType=FDP"), 'class'=>"form-inline", 'id' => 'formFDP' ]) !!}
{{--            {!! Form::hidden('reportType', 'FDP') !!}--}}
            {!! Form::label('dateFrom', trans("content.from")) !!}
            {!! Form::text('dateFrom', \request("dateFrom") ? \request("dateFrom") : date('Y-m-d'), ['class' => 'form-control dateFrom inputDateSmall', 'required' => true]) !!}
            {!! Form::label('dateFrom', trans("content.to")) !!}
            {!! Form::text('dateTo', \request("dateTo") ? \request("dateTo") : date('Y-m-d'), ['class' => 'form-control dateTo inputDateSmall', 'required' => true]) !!}
            {!! Form::label('perPage', trans("content.per_page")) !!}
            {!! Form::select('perPage', [10 => 10, 20 => 20, 50 => 50, '' => 'All'], \request("perPage") ? \request("perPage") : 20, ['class' => 'form-control']) !!}
            {!! Form::submit('Submit', ['class' => 'btn btn-primary']) !!}
            {!! Form::close() !!}
        </div>
        <div class="col-lg-6 text-right filters">
            <div style="display: inline-block">
                <div style="margin: 10px; float: left;">
                    <span class="label label-success valid filter_status" data-apply = 1>@lang("content.within_limits")</span>
                    <span class="label label-danger crossed filter_status" data-apply = 1>@lang("content.above_limits")</span>
                    {{--<a href="#" class="btn btn-sm btn-primary" id="apply_filter">Apply Filter</a>--}}
                </div>
                <div style="float: left" class="round-button">
                    <div class="round-button-circle">
                        <a href="#" class="round-button" id="applyFilter">@lang("content.apply")</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12" id="message-block"></div>
    @if (count($flights))
        <div class="col-lg-12">
        @if ( isset($pagination ) && isset($pagination['pagination']))
                <div class="clearfix"></div>
                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                    <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                    -->
                    <header>
                        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                        <h2>@lang("content.list") </h2>

                    </header>

                    <!-- widget div-->
                    <div style="width: 100%;overflow: auto;">

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->

                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body no-padding">
                            <table class="table table-bordered table-striped table-hover" id="fdpReport" style="margin-bottom: 10px">
                                <thead>
                                <tr>
                                    <th rowspan="2">No</th>
                                    <th rowspan="2" style="min-width: 60px;">@lang("content.dept")</th>
                                    <th rowspan="2" style="min-width: 50px;">@lang("content.ac")</th>
                                    <th rowspan="2">@lang("content.flight_number")</th>
                                    <th rowspan="2" style="min-width: 60px;">@lang("content.route")</th>
                                    <th colspan="2">@lang("content.departure")</th>
                                    <th rowspan="2" style="min-width: 130px;">@lang("content.departure")</th>
                                    <th rowspan="2" style="min-width: 130px;">@lang("content.arrival")</th>
                                    <th colspan="5" class="text-center">FDP</th>
                                    <th colspan="3" class="text-center">@lang("content.flight_crew")</th>
                                    <th colspan="3" class="text-center">@lang("content.cabin_crew")</th>
                                    {{--<th rowspan="2">Delay</th>--}}
                                    {{--<th rowspan="2">Actions</th>--}}
                                </tr>
                                <tr>
                                    <th>@lang("content.user_defined")</th>
                                    <th style="min-width: 100px;">STD</th>

                                    <th style="min-width: 100px;">@lang("content.start")</th>
                                    <th>@lang("content.plan")</th>
                                    <th>@lang("content.est")</th>
                                    <th>@lang("content.act")</th>
                                    <th>@lang("content.calc")</th>

                                    <th>@lang("content.min")</th>
                                    <th>@lang("content.act")</th>
                                    <th>FDP</th>

                                    <th>@lang("content.min")</th>
                                    <th>@lang("content.act")</th>
                                    <th>FDP</th>
                                </tr>
                                </thead>
                                <tbody>
                                @php $currentPage = \request("page") ? \request("page") - 1 : 0 @endphp
                                @php $perPage = \request("perPage") ? \request("perPage") : count($flights) @endphp
                                @php $j = 0 @endphp
                                    @foreach($pagination['pagination'] as $i => $flight)
                                        @if ($i >= $currentPage * $perPage && $i < $currentPage * $perPage + $perPage)

                                            @php $dep = getFlightDepartureInitialDate($flight) @endphp
                                            <tr>
                                                <td>{{ $j + 1 }}</td>
                                                <td>{{ date('d M y', strtotime($dep)) }}</td>
                                                <td>{{ $flight->aircraft ? $flight->aircraft->name : "" }}</td>
                                                <td><a target="_blank" href="{{ url("flight-tracker/{$flight->id}") }}">{{ $fltNo = $CURRENT_IATA_CODE.' '.$flight->flightNumber->flight_number }}</a>
                                                    @if ($flight->flightChild)
                                                        @php $childFltNo = $flight->flightChild->flightNumber->flight_number @endphp
                                                        <a target="_blank" href="{{ url("flight-tracker/{$flight->flightChild->id}") }}">{{ '/ '.$childFltNo }}</a>
                                                        @php $fltNo .= '/ '.$childFltNo @endphp
                                                    @endif
                                                    @php $fltNo @endphp
                                                </td>

                                                <td>{{ $sector = getSector($flight->flightNumber) }}
                                                    @if ($flight->flightChild)
                                                        @php $sectorChild = getSector($flight->flightChild->flightNumber) @endphp
                                                        {{ '-'.$routeChild }}
                                                        @php $route .= "-".$routeChild @endphp
                                                    @endif
                                                </td>
                                                {{--ETD Manipulate--}}
                                                @if ($flight->arrivalType == ATA)
                                                    <td align="center"><span class="label label-warning departureArrivalType">{{ 'LANDED' }}</span></td>
                                                @else
                                                    <td><p class="editable_values" data-date_format='d M y, H:i'>{{ "" }}</p></td>
                                                @endif


                                                <td><p class="std">{{ date('d M y, H:i', strtotime($dep)) }}</p></td>

                                                <td><p class="departure" style="float: left; ">{{ date('d M y, H:i', strtotime($flight->departure)) }}</p>{!! departureArrivalTypeSpan($flight->departureType) !!}</td>
                                                <td><p class="arrival" style="float: left; ">{{ date('d M y, H:i', strtotime($flight->arrival)) }}</p>{!! departureArrivalTypeSpan($flight->arrivalType) !!}</td>

                                                @php $estimateCrossed = $flight->fdpEstimate && $flight->fdpEstimate > $flight->fdpMaxFlightCrew ? "color-red" : "" @endphp
                                                @php $actualCrossed = $flight->fdpActual && $flight->fdpActual > $flight->fdpMaxFlightCrew ? "color-red" : "" @endphp

                                                <td><p class="fdpStart">{{ date('d M y, H:i', strtotime($flight->fdpStart)) }}</p></td>
                                                <td class="fdp"><p class="fdpPlanned">{{ $flight->fdpPlanned ? hoursToTime($flight->fdpPlanned, true) : "" }}</p></td>
                                                <td class="fdp"><p class="fdpEstimate {{ $estimateCrossed }}">{{ $flight->fdpEstimate ? hoursToTime($flight->fdpEstimate, true) : "" }}</p></td>
                                                <td class="fdp"><p class="fdpActual {{ $actualCrossed }}">{{ $flight->fdpActual ? hoursToTime($flight->fdpActual, true) : "" }}</p></td>
                                                <td class="fdp"><p class="fdpCalculated"></p></td>


                                                <td><p class="minFcm">{{ getMinFCM($flight) }}</p></td>
                                                <td><p class="currentFcm">{{ $flight->flightCrewCounter }}</p></td>
                                                <td class="{{ $flight->fdpFlightCrewViolate ? 'red' : 'green'}}"><p class="fdpMaxFcm">{{ hoursToTime($flight->fdpMaxFlightCrew, true) }}</p></td>

                                                <td><p class="minCcm">{{ getMinCCM($flight) }}</p></td>
                                                <td><p class="currentCcm">{{ $flight->cabinCrewCounter }}</p></td>
                                                <td class="{{ $flight->fdpCabinCrewViolate ? 'red' : 'green'}}"><p class="fdpMaxCcm">{{ hoursToTime($flight->fdpMaxCabinCrew, true) }}</p></td>
                                            </tr>

                                            @php $j++ @endphp
                                            @if (isset($flight->flightWithRest) && $flight->flightWithRest)
                                                @php $flightWithRest = $flight->flightWithRest @endphp
                                                @php $restDep = getFlightDepartureInitialDate($flightWithRest) @endphp
                                                <tr>
                                                    <td>{{ $j +1 }}</td>
                                                    <td>{{ date('d M y', strtotime($restDep)) }}</td>
                                                    <td>{{ $flightWithRest->aircraft ? $flightWithRest->aircraft->name : "" }}</td>
                                                    <td><a target="_blank" href="{{ url("flight-tracker/{$flightWithRest->id}") }}">{{ $fltNo = $CURRENT_IATA_CODE.' '.$flightWithRest->flightNumber->flight_number }}</a>
                                                        @if ($flightWithRest->flightChild)
                                                            @php $childFltNo = $flightWithRest->flightChild->flightNumber ? $flightWithRest->flightChild->flightNumber->flight_number : "" @endphp
                                                            <a target="_blank" href="{{ url("flight-tracker/{$flightWithRest->flightChild->id}") }}">{{ '/ '.$childFltNo }}</a>
                                                            @php $fltNo .= '/ '.$childFltNo @endphp
                                                        @endif
                                                        @php $fltNo @endphp
                                                    </td>
                                                    <td>{{ $route = getSector($flightWithRest->flightNumber) }}
                                                        @if ($flightWithRest->flightChild)
                                                            @php $routeChild = $flightWithRest->flightChild->flightNumber->arrival_airport @endphp
                                                            {{ '-'.$routeChild }}
                                                            @php $route .= '-'.$routeChild @endphp
                                                        @endif
                                                        @php $route @endphp
                                                    </td>
                                                    {{--ETD Manipulate--}}
                                                    @if ($flightWithRest->arrivalType == ATA)
                                                        <td align="center"><span class="label label-warning departureArrivalType">{{ 'LANDED' }}</span></td>
                                                    @else
                                                        <td><p class="editable_values" data-date_format='d M y, H:i'>{{ "" }}</p></td>
                                                    @endif

                                                    <td><p class="std">{{ date('d M y, H:i', strtotime($restDep)) }}</p></td>

                                                    <td><p class="departure" style="float: left; ">{{ date('d M y, H:i', strtotime($flightWithRest->departure)) }}</p>{!! departureArrivalTypeSpan($flightWithRest->departureType) !!}</td>
                                                    <td><p class="arrival" style="float: left; ">{{ date('d M y, H:i', strtotime($flightWithRest->arrival)) }}</p>{!! departureArrivalTypeSpan($flightWithRest->arrivalType) !!}</td>

                                                    @php $estimateCrossed = $flightWithRest->fdpEstimate && $flightWithRest->fdpEstimate > $flightWithRest->fdpMaxFlightCrew ? "color-red" : "" @endphp
                                                    @php $actualCrossed = $flightWithRest->fdpActual && $flightWithRest->fdpActual > $flightWithRest->fdpMaxFlightCrew ? "color-red" : "" @endphp

                                                    <td><p class="fdpStart">{{ date('d M y, H:i', strtotime($flightWithRest->fdpStart)) }}</p></td>
                                                    <td class="fdp"><p class="fdpPlanned">{{ $flightWithRest->fdpPlanned ? hoursToTime($flightWithRest->fdpPlanned, true) : "" }}</p></td>
                                                    <td class="fdp"><p class="fdpEstimate {{ $estimateCrossed }}">{{ $flightWithRest->fdpEstimate ? hoursToTime($flightWithRest->fdpEstimate, true) : "" }}</p></td>
                                                    <td class="fdp"><p class="fdpActual {{ $actualCrossed }}">{{ $flightWithRest->fdpActual ? hoursToTime($flightWithRest->fdpActual, true) : "" }}</p></td>
                                                    <td class="fdp"><p class="fdpCalculated"></p></td>

                                                    <td><p class="minFcm">{{ getMinFCM($flightWithRest) }}</p></td>
                                                    <td><p class="currentFcm">{{ $flightWithRest->flightCrewCounter }}</p></td>
                                                    <td class="{{ $flightWithRest->fdpFlightCrewViolate ? 'red' : 'green'}}"><p class="fdpMaxFcm">{{ hoursToTime($flightWithRest->fdpMaxFlightCrew, true) }}</p></td>

                                                    <td><p class="minCcm">{{ getMinCCM($flightWithRest) }}</p></td>
                                                    <td><p class="currentCcm">{{ $flightWithRest->cabinCrewCounter }}</p></td>
                                                    <td class="{{ $flightWithRest->fdpCabinCrewViolate ? 'red' : 'green'}}"><p class="fdpMaxCcm">{{ hoursToTime($flightWithRest->fdpMaxCabinCrew, true) }}</p></td>
                                                </tr>
                                                @php $j++ @endphp
                                            @endif
                                        @endif
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            {!! $pagination['pagination']->appends(request()->all())->render() !!}
        @endif
    </div>
    @endif
</div>