<div class="tab-pane tab_holder {!! $reportType && $reportType =='Expiry Summary' ? 'active' : '' !!}" id="expiry" style="padding: 10px 0;">

    <div class="col-md-6">
        {!!Form::open(['method' => 'GET',  'url' => url("crew/report?reportType=Expiry Summary"),'class'=>"form-inline", 'id' => 'formExpiry' ]) !!}
            <label class="control-label">@lang("content.crew")</label>
            {!! Form::select('crew', ['fcm'=>'Flight Crew','ccm'=>'Cabin Crew'], $crewType, ['class'=>'form-control input_roster margin_right', 'id'=>'crew']) !!}
            {{--{!! Form::hidden('reportType', 'Expiry Summary') !!}--}}
            <div class="form-group margin_right">
                {!! Form::input('submit', 'submit','Submit',[ 'class' => "btn btn-primary"]) !!}
            </div>
        {!!Form::close()!!}
    </div>

    @if ($staffData)
        <div class="col-sm-12 margin-top-10">
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-staff-expiry-report" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                    <h2>@lang("content.list")</h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding" style="min-height: 50px !important;">

                        <div class="table-responsive editable_div" style="overflow: auto; height: 600px;">

                            {!! Form::open(['method' => 'POST', 'class' => 'form-inline'])  !!}

                            @php $width = count($licenses) * 200 + 400 @endphp
                            <table class="table table-bordered table-hover" id="licensesTable" style="width: {{ $width }}px; min-width: 100%;">
                                <thead>
                                <tr>
                                    <th rowspan="2" style="width: 60px;">No</th>
                                    <th rowspan="2" style="width: 60px;">@lang("content.picture")</th>
                                    <th rowspan="2" style="width: 130px;">@lang("content.first_name")</th>
                                    <th rowspan="2" style="width: 150px;">@lang("content.last_name")</th>
                                    @foreach($licenses as $license)
                                        <th data-center colspan="2" style="width:200px;">{{ $license->abbr }}</th>
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach($licenses as $license)
                                        <th data-center style="width: 120px;">@lang("content.dex")</th>
                                        <th data-center>@lang("content.status")</th>
                                    @endforeach
                                </tr>
                                </thead>

                                <tbody>
                                @php $j = 0 @endphp

                                @foreach($staffData as $k => $staffLicense)
                                    @php $user = $staffLicense["user"] @endphp
                                    @php $picture = $user->thumb ? '/storage/users/'.$user->thumb : '/assets/img/default-user-picture.png' @endphp

                                    @if ($j > 0 && $j % 8 == 0)
                                        <tr>
                                            <th rowspan="2" style="width: 60px;">No</th>
                                            <th rowspan="2" style="width: 60px;">@lang("content.picture")</th>
                                            <th rowspan="2" style="width: 130px;">@lang("content.first_name")</th>
                                            <th rowspan="2" style="width: 150px;">@lang("content.last_name")</th>
                                            @foreach($licenses as $license)
                                                <th data-center colspan="2" style="width:200px;">{{ $license->abbr }}</th>
                                            @endforeach
                                        </tr>
                                        <tr>
                                            @foreach($licenses as $license)
                                                <th data-center style="width: 120px;">@lang("content.dex")</th>
                                                <th data-center>@lang("content.status")</th>
                                            @endforeach
                                        </tr>
                                    @endif
                                    <tr>
                                        <td data-center>{{ ++$j }}</td>
                                        <td><a href="{{ route("homepage")."#".url("/staff/$user->id/edit?s=".rand(100, 999)) }}"><img src="{{ $picture }}" width="100" class="img-thumbnail thumb_report_prev"/></a></td>
                                        <td><a target="_blank" href="{{ route("homepage")."#". url("staff/{$user->id}/edit?s=".rand(100, 999)) }}">{{ $user->first_name }}</a></td>
                                        <td><a target="_blank" href="{{ route("homepage")."#". url("staff/{$user->id}/edit?s=".rand(100, 999)) }}">{{ $user->last_name }}</a></td>

                                        @foreach($licenses as $license)
                                            @php $expiryDate = isset($staffLicense[$license->id]) ? $staffLicense[$license->id] : null @endphp
                                            <td>
                                                <a href="#" data-field='license_id'
                                                   data-field_value="{{ $license->id }}" data-model="StaffLicense"
                                                   data-foreign_key='user_id' data-type="date"
                                                   data-id='{{ $user->id }}' data-placeholder="Required"
                                                   data-format='d-M-Y'
                                                   data-js_format='DD-MMM-YYYY' data-value_key="expiry_date"
                                                   data-value='{{ $expiryDate }}'
                                                   class="editable {{ $expiryDate ? 'editable-click' : 'editable-empty'  }}">{{ $expiryDate ? date('d-M-Y', strtotime($expiryDate))  : 'Empty' }}</a>
                                            </td>
                                            <td>{!! Expiration_Date($expiryDate)['status'] !!}</td>
                                        @endforeach
                                    </tr>

                                @endforeach
                                </tbody>

                            </table>

                            {!!  Form::close()  !!}

                        </div>

                    </div>

                </div>

            </div>
        </div>
    @endif
</div>
