<?php require_once(public_path("smart/inc/init.php")); ?>

<link href='{{ asset("/packages/calendar/fullcalendar.css") }}' rel='stylesheet' />
<link href='{{ asset("/packages/calendar/fullcalendar.print.css") }}' rel='stylesheet' media='print' />

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @php $crewName = $user->first_name .' '.$user->last_name @endphp
            @php $location = $user->location ? $user->location->airport->iata : "" @endphp
            @php $position = $user->position_title ? $user->position_title . ($user->is_business_crew ? " | Business Class Crew" : "") : "" @endphp

            @include('general.tab-header', ['departmentName' => 'Crew', 'moduleName' => $crewName.($position ? " | ". $position : "") . ($location ? " | ".$location : "")])

            <div>

                @if ($user)

                    @php $authUser = \Auth::user() @endphp

                    <div class="tabbable" style="float: none; clear: both; height: 400px"> <!-- Only required for left/right tabs -->
                        <ul class="nav nav-tabs {!! $tabClass !!}">
                            <li class="{{ !\request("tabSelected") || \request("tabSelected") == "main" ? 'active' : "" }}"><a href="#mainTab" data-toggle="tab">@lang("content.general")</a></li>
                            <li class="{{ \request("tabSelected") == "roster" ? 'active' : "" }}"><a href="#roster" data-toggle="tab">Roster</a></li>
                            <li class="{{ \request("tabSelected") == "hours" ? 'active' : '' }}"><a href="#hours" data-toggle="tab">Hours</a></li>
                            <li class="{{ \request("tabSelected") == "standby" ? 'active' : '' }}"><a href="#standby" data-toggle="tab">Standby</a></li>
                            <li class="{{ \request("tabSelected") == "dhc" ? 'active' : '' }}"><a href="#dhc" data-toggle="tab">DHC</a></li>
                            <li><a href="#licenses" data-toggle="tab">@lang("content.licenses_approvals")</a></li>
                            <li><a href="#leaves" data-toggle="tab">Leaves</a></li>
                            <li><a href="#trainings" data-toggle="tab">Trainings</a></li>
                            <li><a href="#officeDuties" data-toggle="tab">Office Duties</a></li>
                            <li><a href="#fatigueManagement" data-toggle="tab" id="fatigueTab">Fatigue Management</a></li>

                            {{--Leave Requests--}}
                            <li><a href="#requests" data-toggle="tab" title="welcome">My Requests</a></li>
                            <li><a href="#leave_request" data-toggle="tab" title="welcome">Leave Request</a></li>
                            {{--<li><a href="#duty_travel_request" data-toggle="tab" title="welcome" class="not-active">Duty Travel Request</a></li>--}}
                            @if ($hasEmployees)
                                <li><a href="#employees_requests" data-toggle="tab" title="welcome">Employees Requests</a></li>
                            @endif

                        </ul>
                        <div class="tab-content padding-10 background-white">
                            @include("crew.profile-general-tab")
                            @include("crew.profile-roster-tab")
                            @include('crew.profile-hours-tab')
                            @include("crew.profile-standby-tab")
                            @include("crew.profile-dhc-tab")

                            <div class="tab-pane bg-color-white {{ \request("tab") == "licenses" ? "active" : "" }}" id="licenses" style="padding: 15px !important; width: 100%; ">
                                @include("staff.layouts.licenses-tab")
                            </div>

                            @include('crew.profile-leaves-tab')
                            @include('crew.profile-trainings-tab')
                            @include('crew.profile-office-duties-tab')
                            @include('crew.profile-fatigue-management-tab')

                            <div class="tab-pane" id="requests" style="height: 560px;">
                                @include('user.show-my-requests-tab')
                            </div>

                            <div class="tab-pane" id="leave_request" style="height: 560px;">
                                @include('user.request-leave-tab')
                            </div>

                            {{--<div class="tab-pane" id="duty_travel_request" style="height: 560px;">--}}
                                {{--@include('user.show-duty-travel-request-tab')--}}
                            {{--</div>--}}

                            @if ($hasEmployees)
                                <div class="tab-pane" id="employees_requests" style="height: 560px;">
                                    @include('user.show-employees-requests-tab')
                                </div>
                            @endif

                        </div>
                    </div>
                @endif
            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

        loadScript("{{ asset("/packages/calendar/fullcalendar.min.js") }}");

        $(document).on("click", "#fatigueTab", function () {
            $('#calendar').fullCalendar({
                header: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'month,agendaWeek,agendaDay'
                },
                editable: false,
                timeFormat: "HH:mm",
                height: 530,
                eventLimit: true, // allow "more" link when too many events
                events: {!! $fdpAllFlightsJs !!}

            });
        });

    };

    loadScript("{{ asset("/packages/calendar/lib/moment.min.js") }}", function () {
        loadScript("{{ asset("/assets/js/views/user/edit.js") }}", pagefunction);
    });

</script>





