<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: aviation.dev
 */
$i=0;

?>

<div class="tab-pane {{ \request("tabSelected") == "standby" ? 'active' : '' }}" id="standby" style="padding: 10px 0; height: 620px ">

<form class="form-inline" method="get" action="{{ url("crew/profile?id={$userId}&tabSelected=standby") }}">
    <label>Period </label>
    <div class="btn-group">
    {!! Form::select("period", ["" => "Select", "default" => "Roster + 28 Days", "planned" => "Current Roster", "last7days" => "Last 7 Days", "last28days" => "Last 28 Days", "last90days"=>"Last 90 Days", "last365days" => "Last 365 Days"], \request("period"), ["class"=>"form-control singleselect marginRight"]) !!}

    </div>
    {!! Form::label('rosterFrom', trans("content.from")) !!}
    {!! Form::text('rosterFrom', \request("rosterFrom"), ['class' => 'form-control dateFrom inputDateSmall']) !!}
    {!! Form::label('rosterTo', trans("content.to")) !!}
    {!! Form::text('rosterTo', \request("rosterTo"), ['class' => 'form-control dateTo inputDateSmall']) !!}
    {!! Form::submit("Submit", ["class" => "btn btn-primary btn-sm"]) !!}
    {!! Form::hidden("id", \request("id")) !!}
</form>

@if (!count($standbyFlights))
<div class="alert alert-info"  style="margin-top: 10px">
    <h4>No Results!</h4>
    <p>Not found any flight for this user</p>
</div>
@else
<div id="roster_div" style=" height: 560px; overflow: auto; margin-top: 10px">
    <table class="table table-bordered table-striped table-hover">
    <thead>
    <tr>
        <th rowspan="2">No.</th>
        <th style="width: 80px" rowspan="2">@lang("content.status")</th>
        <th rowspan="2">@lang("content.aircraft")</th>
        <th rowspan="2">@lang("content.flight")</th>
        <th rowspan="2">@lang("content.route")</th>
        <th rowspan="2">@lang("content.departure_datetime")</th>
        <th rowspan="2">@lang("content.arrival_datetime")</th>
        <th rowspan="2">@lang("content.duration")</th>
    </tr>

    </thead>
    <tbody>
        @php $j = 0; @endphp
        @if (!(isset($standbyFlights) && $standbyFlights->count()))
            <div class="alert alert-info">
                <h4>No Results!</h4>
                <p>Not found any flight for this user</p>
            </div>
        @else
            @foreach($standbyFlights as $i => $flight)
                @php $fdpClass = $i % 2 == 0 ? "fdp-alter" : "" @endphp
                    @php $class = $flight->is_standby ? '<span class="label label-danger">Standby</span>' : ($flight->is_dhc ? '<span class="label label-success">DHC</span>' : '') @endphp
                    <tr>
                        <td class="{{ $fdpClass }}">{{ ++$j}}</td>
                        <td class="{{ $fdpClass }}">{!! $class !!}</td>

                        @if (in_array($authUser->user_role_id, [ROLE_DEPARTMENT_ADMIN, ROLE_ADMIN, ROLE_SUPER_ADMIN]) || $authUser->edit_crew_profile)
                            <td class="{{ $fdpClass }}"><a href="{{ url("/flightquery/index?aircraft={$flight->aircraft_id}&period=period&period_field=last_28_days") }}">{{ $flight->aircraft_name }}</a></td>
                            <td class="{{ $fdpClass }}" nowrap><a href="{{ url("/flight/details?id={$flight->id}") }}">{{ $CURRENT_IATA_CODE.'-'.$flight->flight_number }}</a></td>
                        @else
                            <td class="{{ $fdpClass }}">{{ $flight->aircraft_name }}</td>
                            <td class="{{ $fdpClass }}" nowrap>{{ $CURRENT_IATA_CODE.'-'.$flight->flight_number }}</td>
                        @endif

                        <td class="{{ $fdpClass }}" nowrap>{{ $flight->departure_airport . "-" . $flight->arrival_airport }}</td>
                        @if ($flight->atd && $flight->atd != EMPTY_DATETIME && $flight->ata && $flight->ata != EMPTY_DATETIME)
                            @php $diff = CalculateDifference($flight->std, $flight->atd) @endphp
                            @php $actualClass = "success" @endphp
                            @if ($diff > 3)
                                @php $actualClass = "danger" @endphp
                            @endif
                            <td class="{{ $fdpClass }}"><span class="label label-{{ $actualClass }} small-info">ATD</span>{{ dmy_format($flight->atd, 'time') }}</td>

                            @php $diff = CalculateDifference($flight->std, $flight->atd) @endphp
                            @php $actualClass = "success" @endphp
                            @if ($diff > 3)
                                @php $actualClass = "danger" @endphp
                            @endif
                            <td class="{{ $fdpClass }}"><span class="label label-{{ $actualClass }} small-info">ATA</span>{{ dmy_format($flight->ata, 'time') }}</td>

                            <td class="{{ $fdpClass }}">{{ hoursToTime(Calculate_Duration($flight->atd, $flight->ata), true) }}</td>
                        @else
                            <td class="{{ $fdpClass }}"><span class="label label-warning small-info">STD</span>{{ dmy_format($flight->std, 'time') }}</td>
                            <td class="{{ $fdpClass }}"><span class="label label-warning small-info">STA</span>{{ dmy_format($flight->sta, 'time') }}</td>
                            <td class="{{ $fdpClass }}">{{ hoursToTime(Calculate_Duration($flight->std, $flight->sta), true) }}</td>
                        @endif
                    </tr>
            @endforeach
        @endif
    </tbody>
</table>
</div>
@endif

</div>
