<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: aviation.dev
 */
$i=0;

?>

<div class="tab-pane {{ \request("tabSelected") == "roster" ? 'active' : "" }}" id="roster" style="padding: 10px 0; height: 620px ">

<form class="form-inline" method="get" action="{{ url("crew/profile?id={$userId}&tabSelected=roster") }}">
    <label>Period </label>
    <div class="btn-group">
    {!! Form::select("period", ["" => "Select", "default" => "Roster + 28 Days", "planned" => "Current Roster", "last7days" => "Last 7 Days", "last28days" => "Last 28 Days", "last90days"=>"Last 90 Days", "last365days" => "Last 365 Days"], \request("period"), ["class"=>"form-control singleselect marginRight"]) !!}

    </div>
    {!! Form::label('dateFrom', trans("content.from")) !!}
    {!! Form::text('dateFrom', \request("dateFrom"), ['class' => 'form-control dateFrom inputDateSmall']) !!}

    {!! Form::label('dateTo', trans("content.to")) !!}
    {!! Form::text('dateTo', \request("dateTo"), ['class' => 'form-control dateTo inputDateSmall']) !!}

    {!! Form::submit("Submit", ["class" => "btn btn-primary btn-sm"]) !!}
    {!! Form::hidden("id", \request("id")) !!}
</form>

@if (!count($userFlights))
<div class="alert alert-info"  style="margin-top: 10px">
    <h4>No Results!</h4>
    <p>Not found any flight for this user</p>
</div>
@else
<div id="roster_div" style=" height: 560px; overflow: auto; margin-top: 10px">
    <table class="table table-bordered table-striped table-hover">
    <thead>
    <tr>
        <th rowspan="2">No.</th>
        <th style="width: 80px" rowspan="2">@lang("content.status")</th>
        <th rowspan="2">@lang("content.aircraft")</th>
        <th rowspan="2">@lang("content.flight")</th>
        <th rowspan="2">@lang("content.route")</th>
        <th rowspan="2">@lang("content.report_datetime")</th>
        <th rowspan="2">@lang("content.departure_datetime")</th>
        <th rowspan="2">@lang("content.arrival_datetime")</th>
        <th rowspan="2">@lang("content.release_datetime")</th>
        <th colspan="4" class="text-center">@lang("content.duration") @lang("content.hours")</th>
    </tr>
    <tr>
        <th>@lang("content.other")</th>
        <th>@lang("content.block_hours")</th>
        <th>@lang("content.flight_hours")</th>
        <th>FDP @lang("content.total")</th>
    </tr>
    </thead>
    <tbody>

        @if ($rosterAndLast28Days)
            @php $i = 0; @endphp
            @foreach ($fdpPlannedFlights as $i => $fdp)
                @php $fdpClass = $i % 2 == 0 ? "fdp-alter" : "" @endphp

                @if (isset($lastReleaseTime) && $fdp->getReportTime())
                    @php $restTime = Calculate_Duration($lastReleaseTime, $fdp->getReportTime()) @endphp
                    @if ($restTime)
                        <tr style="background-color: #1982C5; color: #ffffff;">
                            <td style="font-weight: bold;" colspan="12">@lang("content.rest_period")</td>
                            <td style="font-weight: bold;">{{ hoursToDayHourTime($restTime, true) }}</td>
                        </tr>
                    @endif
                @endif

                @foreach($fdp->getFlights() as $flight)

                    @php $flightNumber = getFlightNumber($flight) @endphp
                    @php $sector = getSector($flight->flightNumber) @endphp
                    @php $class = $flight->is_standby ? '<span class="label label-danger">Standby</span>' : ($flight->is_dhc ? '<span class="label label-success">DHC</span>' : '') @endphp
                    <tr>
                        <td class="{{ $fdpClass }}">{{ ++$i}}</td>
                        <td class="{{ $fdpClass }}">{!! $class !!}</td>

                        @if (in_array($authUser->user_role_id, [ROLE_DEPARTMENT_ADMIN, ROLE_ADMIN, ROLE_SUPER_ADMIN]) || $authUser->edit_crew_profile)
                            <td class="{{ $fdpClass }}"><a target="_blank" href="{{ route("homepage")."#aircraft/{$flight->aircraft_id}/edit" }}">{{ $flight->aircraft_name }}</a></td>
                            <td class="{{ $fdpClass }}" nowrap><a target="_blank" href="{{ url("flight-tracker/{$flight->id}") }}">{{ $flightNumber }}</a></td>
                        @else
                            <td class="{{ $fdpClass }}">{{ $flight->aircraft_name }}</td>
                            <td class="{{ $fdpClass }}" nowrap>{{ $flightNumber }}</td>
                        @endif

                        <td class="{{ $fdpClass }}" nowrap>{{ $sector }}</td>
                        <td class="{{ $fdpClass }}">{{ $flight->id == $fdp->getFirstFlight()->id ? dmy_format($fdp->getReportTime(), 'time') : "" }}</td>
                        @if ($flight->atd && $flight->atd != EMPTY_DATETIME && $flight->ata && $flight->ata != EMPTY_DATETIME)

                            <td class="{{ $fdpClass }}"><span class="label label-primary small-info">ATD</span>{{ dmy_format($flight->atd, 'time') }}</td>
                            <td class="{{ $fdpClass }}"><span class="label label-danger small-info">ATA</span>{{ dmy_format($flight->ata, 'time') }}</td>
                        @else
                            <td class="{{ $fdpClass }}"><span class="label label-warning small-info">STD</span>{{ dmy_format($flight->std, 'time') }}</td>
                            <td class="{{ $fdpClass }}"><span class="label label-warning small-info">STA</span>{{ dmy_format($flight->sta, 'time') }}</td>
                        @endif
                        <td class="{{ $fdpClass }}">{{ $flight->id == $fdp->getLastFlight()->id ? dmy_format($fdp->getReleaseTime(), 'time') : "" }}</td>
                        <td class="{{ $fdpClass }}">{{ $flight->other_time == 0 ? "-" : hoursToTime($flight->other_time, true) }}</td>
                        <td class="{{ $fdpClass }}">{{ $flight->flight_time == 0 ? "-" : hoursToTime($flight->flight_time, true) }}</td>
                        <td class="{{ $fdpClass }}">{{ $flight->flying_time == 0 ? "-" : hoursToTime($flight->flying_time, true) }}</td>
                        <td class="{{ $fdpClass }}"></td>
                    </tr>
                @endforeach
                @php $limitCrossed = $fdp->getCurrentFdpTime() > $fdp->getMaxFdpTime() ? "fdp-crossed" : "color-green" @endphp
                @php $limitCrossed = "color-green" @endphp
                <tr>
                    <td class="{{ $fdpClass }} font-strong color-green" colspan="9">FDP @lang("content.total")</td>
                    <td class="{{ $fdpClass }} font-strong color-green">{{ hoursToTime($fdp->getOtherTime(), true) }}</td>
                    <td class="{{ $fdpClass }} font-strong color-green">{{ hoursToTime($fdp->getFlightTime(), true) }}</td>
                    <td class="{{ $fdpClass }} font-strong color-green">{{ hoursToTime($fdp->getFlyingTime(), true) }}</td>
                    <td class="{{ $fdpClass." ".$limitCrossed }} font-strong">{{ hoursToTime($fdp->getCurrentFdpTime(), true) }}</td>
                    {{--<td class="{{ $fdpClass }} font-strong color-green">{{ hoursToTime($fdp->getMaxFdpTime(), true) }}</td>--}}
                </tr>

                @php $lastReleaseTime = $fdp->getReleaseTime() @endphp

            @endforeach
            <tr>
                <td colspan="9" class="text-center header_profile">PLANNED ROSTER @lang("content.total")</td>
                <td class="header_profile" data-center>{{ $fdpPlannedFlightsTotal->other_time == 0 ? "-" : hoursToTime($fdpPlannedFlightsTotal->other_time, true) }}</td>
                <td class="header_profile" data-center>{{ $fdpPlannedFlightsTotal->flight_time == 0 ? "-" : hoursToTime($fdpPlannedFlightsTotal->flight_time, true) }}</td>
                <td class="header_profile" data-center>{{ $fdpPlannedFlightsTotal->flying_time == 0 ? "-" : hoursToTime($fdpPlannedFlightsTotal->flying_time, true) }}</td>
                <td class="header_profile" data-center>{{ $fdpPlannedFlightsTotal->fdp_total_time == 0 ? "-" : hoursToTime($fdpPlannedFlightsTotal->fdp_total_time, true) }}</td>
                {{--<td class="header_profile" data-center>{{ $fdpPlannedFlightsTotal->fdp_max_time == 0 ? "-" : hoursToTime($fdpFlightsTotal->fdp_max_time, true) }}</td>--}}
            </tr>

            <tr>
                <td class="divider" colspan="14"></td>
            </tr>
        @endif


        <tr>
            <td colspan="9" class="text-center header_profile">{{$label}}</td>
            <td class="header_profile" data-center>{{ $fdpFlightsTotal->other_time == 0 ? "-" : hoursToTime($fdpFlightsTotal->other_time, true) }}</td>
            <td class="header_profile" data-center>{{ $fdpFlightsTotal->flight_time == 0 ? "-" : hoursToTime($fdpFlightsTotal->flight_time, true) }}</td>
            <td class="header_profile" data-center>{{ $fdpFlightsTotal->flying_time == 0 ? "-" : hoursToTime($fdpFlightsTotal->flying_time, true) }}</td>
            <td class="header_profile" data-center>{{ $fdpFlightsTotal->fdp_total_time == 0 ? "-" : hoursToTime($fdpFlightsTotal->fdp_total_time, true) }}</td>
            {{--<td class="header_profile" data-center>{{ $fdpFlightsTotal->fdp_max_time == 0 ? "-" : hoursToTime($fdpFlightsTotal->fdp_max_time, true) }}</td>--}}
        </tr>
        @php $j = 0; @endphp
        @if (!(isset($userFlights) && $userFlights->count()))
            <div class="alert alert-info">
                <h4>No Results!</h4>
                <p>Not found any flight for this user</p>
            </div>
        @else
            @foreach ($fdpFlights as $i => $fdp)
                @php $fdpClass = $i % 2 == 0 ? "fdp-alter" : "" @endphp

                @if (isset($lastReportTime) && $fdp->getReleaseTime())
                    @php $restTime = Calculate_Duration($fdp->getReleaseTime(), $lastReportTime) @endphp
                    @if ($restTime)
                        <tr style="background-color: #1982C5; color: #ffffff;">
                            <td style="font-weight: bold;" colspan="12">@lang("content.rest_period")</td>
                            <td style="font-weight: bold;">{{ hoursToDayHourTime($restTime, true) }}</td>
                        </tr>
                    @endif
                @endif

                @foreach($fdp->getFlights() as $flight)
                    @php $class = $flight->is_standby ? '<span class="label label-danger">Standby</span>' : ($flight->is_dhc ? '<span class="label label-success">DHC</span>' : '') @endphp
                    @php $flightNumber = getFlightNumber($flight) @endphp
                    @php $sector = getFlightSector($flight) @endphp

                    <tr>
                        <td class="{{ $fdpClass }}">{{ ++$j}}</td>
                        <td class="{{ $fdpClass }}">{!! $class !!}</td>

                        @if (in_array($authUser->user_role_id, [ROLE_DEPARTMENT_ADMIN, ROLE_ADMIN, ROLE_SUPER_ADMIN]) || $authUser->edit_crew_profile)
                            <td class="{{ $fdpClass }}"><a target="_blank" href="{{ route("homepage")."#aircraft/{$flight->aircraft_id}/edit" }}">{{ $flight->aircraft_name }}</a></td>
                            <td class="{{ $fdpClass }}" nowrap><a target="_blank" href="{{ url("flight-tracker/{$flight->id}") }}">{{ $flightNumber }}</a></td>
                        @else
                            <td class="{{ $fdpClass }}">{{ $flight->aircraft_name }}</td>
                            <td class="{{ $fdpClass }}" nowrap>{{ $flightNumber }}</td>
                        @endif

                        <td class="{{ $fdpClass }}" nowrap>{{ $sector }}</td>
                        <td class="{{ $fdpClass }}">{{ $flight->id == $fdp->getFirstFlight()->id ? dmy_format($fdp->getReportTime(), 'time') : "" }}</td>
                        @if ($flight->atd && $flight->atd != EMPTY_DATETIME && $flight->ata && $flight->ata != EMPTY_DATETIME)
                            @php $diff = CalculateDifference($flight->std, $flight->atd) @endphp
                            @php $actualClass = "success" @endphp
                            @if ($diff > 3)
                                @php $actualClass = "danger" @endphp
                            @endif

                            <td class="{{ $fdpClass }}"><span class="label label-{{ $actualClass }} small-info">ATD</span>{{ dmy_format($flight->atd, 'time') }}</td>

                            @php $diff = CalculateDifference($flight->std, $flight->atd) @endphp
                            @php $actualClass = "success" @endphp
                            @if ($diff > 3)
                                @php $actualClass = "danger" @endphp
                            @endif

                            <td class="{{ $fdpClass }}"><span class="label label-{{ $actualClass }} small-info">ATA</span>{{ dmy_format($flight->ata, 'time') }}</td>
                        @else
                            <td class="{{ $fdpClass }}"><span class="label label-warning small-info">STD</span>{{ dmy_format($flight->std, 'time') }}</td>
                            <td class="{{ $fdpClass }}"><span class="label label-warning small-info">STA</span>{{ dmy_format($flight->sta, 'time') }}</td>
                        @endif
                        <td class="{{ $fdpClass }}">{{ $flight->id == $fdp->getLastFlight()->id ? dmy_format($fdp->getReleaseTime(), 'time') : "" }}</td>
                        <td class="{{ $fdpClass }}">{{ $flight->other_time == 0 ? "-" : hoursToTime($flight->other_time, true) }}</td>
                        <td class="{{ $fdpClass }}">{{ $flight->flight_time == 0 ? "-" : hoursToTime($flight->flight_time, true) }}</td>
                        <td class="{{ $fdpClass }}">{{ $flight->flying_time == 0 ? "-" : hoursToTime($flight->flying_time, true) }}</td>
                        <td class="{{ $fdpClass }}"></td>
                    </tr>
                @endforeach

                @php $limitCrossed = $fdp->getCurrentFdpTime() > $fdp->getMaxFdpTime() ? "fdp-crossed" : "color-green" @endphp
                @php $limitCrossed = "color-green" @endphp
                <tr>
                    <td class="{{ $fdpClass }} font-strong color-green" colspan="9">FDP @lang("content.total")</td>
                    <td class="{{ $fdpClass }} font-strong color-green">{{ hoursToTime($fdp->getOtherTime(), true) }}</td>
                    <td class="{{ $fdpClass }} font-strong color-green">{{ hoursToTime($fdp->getFlightTime(), true) }}</td>
                    <td class="{{ $fdpClass }} font-strong color-green">{{ hoursToTime($fdp->getFlyingTime(), true) }}</td>
                    <td class="{{ $fdpClass." ".$limitCrossed }} font-strong">{{ hoursToTime($fdp->getCurrentFdpTime(), true) }}</td>
                    {{--<td class="{{ $fdpClass }} font-strong color-green">{{ hoursToTime($fdp->getMaxFdpTime(), true) }}</td>--}}
                </tr>

                @php $lastReportTime = $fdp->getReportTime() @endphp

            @endforeach
        @endif
    </tbody>
</table>
</div>
@endif

</div>
