<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: aviation.dev
 */
$i=0;
?>
<div class="tab-pane {{ \request("tabSelected") == "hours" ? 'active' : "" }}" id="hours" style="padding: 10px 0; height: 620px">

<form class="form-inline" method="get" action="{{ url("crew/profile?id={$userId}&tabSelected=hours") }}">
    <div class="form-group margin_right">
        <label>Period </label>
        <div class="btn-group">
            {!! Form::select("hoursPeriod", ["" => "Select", "last7days" => "Last 7 Days", "last28days" => "Last 28 Days", "last365days" => "Last 365 Days"], \request("hoursPeriod") ? \request("hoursPeriod") : (\request("hoursFrom") ? null : 'last28days'), ["class"=>"form-control multiselect"]) !!}
        </div>
        {!! Form::hidden("id", \request("id")) !!}
    </div>
    <div class="form-group margin_right">
        <label class="control-label">@lang("content.from")</label>
        {!! Form::input('text', 'dateFrom', \request("dateFrom"),['class'=>'form-control date_format inputDateSmall', 'id' => 'from_date ']) !!}
    </div>

    <div class="form-group margin_right">
        <label class="control-label">@lang("content.to")</label>
        {!! Form::input('text', 'dateTo', \request("dateTo"),['class'=>'form-control date_format inputDateSmall', 'id'=>'to_date']) !!}
    </div>

    <div class="form-group">
        {!! Form::submit("Submit", ["class" => "btn btn-primary btn-sm"]) !!}
    </div>
</form>

@if (!($crewHours && count($crewHours)))
<div class="alert alert-info" style="margin-top: 10px">
    <h4>No Results!</h4>
    <p>Please Try Again</p>
</div>
@else
<div id="roster_div" style=" height: 560px; overflow: auto; margin-top: 10px">
    <table class="table table-bordered table-striped table-hover table-condensed">
        <thead>
        <tr>
            <th rowspan="2">No</th>
            <th rowspan="2">@lang("content.date")</th>
            <th colspan="3">Flight Hours</th>
        </tr>
        <tr>
            <th>7 Days</th>
            <th>28 Days</th>
            <th>Year To Date</th>
            {{--<th>365 Days</th>--}}
        </tr>
        </thead>

        <tbody>

        @php $j = 1 @endphp
        @forelse($crewHours[$userId]['historicHours'] as $day => $lastArray)
            <tr>
                <td>{!!$j++!!}</td>
                <td>{!!date('d M Y', strtotime($day)) !!}</td>

                @php $class = Get_Limitation_Class($lastArray) @endphp
                @foreach($lastArray as $name=>$lastEach)
                    <td class="{!!$class[$name]!!}">{!!hoursToTime($lastEach['value'],'ready')!!}</td>
                @endforeach
            </tr>
        @empty
        @endforelse
        </tbody>
    </table>
</div>
@endif
</div>
