<div class="tab-pane editable_div" id="general_staff_travel" style="padding: 10px 0;overflow: auto; height: 340px">
    {!!  Form::open(['method' => 'POST', 'class' => 'form-inline'])  !!}
    <table class="table table-bordered table-striped table-hover details" data-type = '{!!$crewType!!}' data-user_id = "{{ $user->id }}" style="width:100%; padding: 0; margin: 0">
        <thead></thead>
        <tbody>
            <tr>
                <td class="header_profile">Marital Status</td>
                <td>
                    <a href="#" data-field = 'marital_status_id' data-model="User" data-type="select" data-id = '{{ $user->id }}' data-placeholder="Required"
                       data-value = '{{ $user->marital_status_id }}' class="editable {{  $user->location_id ? 'editable-click' : 'editable-empty'  }}">
                        {{  $user->marital_status_id ? $user->maritalStatus->status : 'Empty' }}</a>
                </td>
            </tr>
        </tbody>
    </table>
    {!!  Form::close()  !!}

    @if ($user->marital_status_id)
    {!! Form::open(['method' => 'POST', 'class' => 'form-inline']) !!}
        <table class="table table-bordered table-striped table-hover staff_travel" data-type = '{!!$crewType!!}' data-marital_status = '{!!$user->marital_status!!}' data-table = 'users__family' data-date_format = "d-M-Y" data-user_id = "{{ $user->id }}" style="padding: 0; margin: 10px 0 0 0">
        <thead>
        </thead>
        <tbody>
            <tr>
                <td class="td_header blue">Relationship</td>
                <td class="td_header blue">@lang("content.first_name")</td>
                <td class="td_header blue">@lang("content.last_name")</td>
                <td class="td_header blue">@lang("content.dob")</td>
                <td class="td_header blue">Nominee</td>
                {!! Form::input('hidden', 'relationships_single', json_encode(relationshipList('Single'))) !!}
                {!! Form::input('hidden', 'relationships_married', json_encode(relationshipList('Married'))) !!}
            </tr>
            @php $counter = 0 @endphp
            @forelse($user->userFamily as $member)
                @if (in_array($member->relationship_id, relationshipList($user->marital_status_id, 'ids')))
                    @php $counter++ @endphp
                    <tr class="data">
                        <td>{!! Form::select('relationship_id', relationshipList($user->marital_status_id), $member->relationship_id) !!}</td>
                        <td>{!! Form::input('text', 'first_name', $member->first_name, ['style' => 'width:120px']) !!}</td>
                        <td>{!! Form::input('text', 'last_name', $member->last_name, ['style' => 'width:120px']) !!}</td>
                        <td>{!! Form::input('text', 'dob', date('d-M-Y', strtotime($member->dob)), ['class' => 'date_format inputDateSmall', 'style' => 'width:120px']) !!}</td>
                        <td>{!! Form::checkbox('is_nominee', '1', $member->is_nominee) !!}</td>
                    </tr>
                @endif
            @empty
            @endforelse
            @if(!is_null($user->marital_status_id))
                @if ($counter < 3)
                    @for($i = 0, $l = 3 - $counter; $i < $l; $i++)
                         <tr class="data">
                             <td>{!! Form::select('relationship_id', relationshipList($user->marital_status_id) )!!}</td>
                             <td>{!! Form::input('text', 'first_name', null, ['style' => 'width:120px']) !!}</td>
                             <td>{!! Form::input('text', 'last_name', null, ['style' => 'width:120px']) !!}</td>
                             <td>{!! Form::input('text', 'dob', null, ['class' => 'date_format inputDateSmall', 'style' => 'width:120px']) !!}</td>
                             <td>{!! Form::checkbox('is_nominee', '1') !!}</td>

                         </tr>
                    @endfor
                @endif
            @endif
            <tr>
                <td colspan="5">
                    <div class="btn-group">
                        <a href="#" class="btn btn-sm btn-primary add">@lang("content.add")</a>
                        <a href="#" class="btn btn-sm btn-danger remove">@lang("content.remove")</a>
                        <a href="#" class="btn btn-sm btn-success check">Check Eligible</a>
                        <a href="#" class="btn btn-sm btn-warning save">Save Changes</a>
                    </div>
                </td>
            </tr>
    </tbody>
    </table>
    {!!  Form::close()  !!}

    @else
        <div class="alert alert-dismissable alert-info" style="margin: 10px 0">
          <button type="button" class="close" data-dismiss="alert">×</button>
          <strong>Marital Status Not Set!</strong> Please, Set Marital Status First.
        </div>
    @endif
</div>