<div class="tab-pane editable_div active" id="general_general" style="padding: 10px 0; overflow: auto; height: 340px">
    <div class="message_box"></div>
    {!!  Form::open(['method' => 'POST', 'class' => 'form-inline'])  !!}
        <table class="table table-bordered table-striped table-hover editable_table" data-user_id = "{{ $user->id }}" style="width:100%; padding: 0; margin: 0">
            <thead>
            </thead>
            <tbody>
            <tr>
                <th>Category</th>
                <th colspan="3">@lang("content.info")</th>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.staff_no")</td>
                <td>
                    <a href="#" data-field='staff_number' data-model="User" data-type="text" data-id='{{ $user->id }}'
                       data-placeholder="Required"
                       class="editable {{ $user->staff_number ? 'editable-click' : 'editable-empty'  }}">{{ $user->staff_number ? $user->staff_number : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.email")</td>
                <td>
                    <a href="#" data-field = 'email' data-model="User" data-type="text" data-id = '{{ $user->id }}' data-placeholder="Required"
                       class="editable {{  $user->email ? 'editable-click' : 'editable-empty'  }}">{{ $user->email ? $user->email : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">A/C Type Rating</td>
                <td>
                    <a href="#" data-field = 'aircraft_type_id' data-model="CrewRestrictionAircraftType" data-type="multiselect" data-id = '{{ $user->id }}' data-foreign_key = 'user_id'
                       data-placeholder="Required" data-value = '{!!  json_encode(array_keys($restrictionPairs)) !!}' class="editable {!! count($restrictionAircraftTypes) ? 'editable-click' : 'editable-empty' !!}">
                        {{  count($restrictionAircraftTypes) ? implode(', ', $restrictionAircraftTypes) : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.date_of_birth")</td>
                <td>
                    <a href="#" data-field = 'dob' data-model="User" data-type="date" data-id = '{{ $user->id }}' data-placeholder="Required" data-format = 'd-M-Y'
                       data-js_format = 'DD-MMM-YYYY'  data-value = '{{ $user->dob }}' class="editable {{  $user->dob ? 'editable-click' : 'editable-empty'  }}">
                        {{  $user->dob  ?  date('d-M-Y', strtotime($user->dob))  : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.place_of_birth")</td>
                <td>
                    <a href="#" data-field = 'pob_country_id' data-model="User" data-type="select" data-id = '{{ $user->id }}' data-placeholder="Required"
                       data-value = '{{ $user->pob_country_id }}' class="editable {{  $user->pob_country_id ? 'editable-click' : 'editable-empty'  }}">
                        {{  $user->pob_country_id ? $user->pob->country : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">Date of Joining</td>
                <td>
                    <a href="#" data-field = 'doj' data-model="User" data-type="date" data-id = '{{ $user->id }}' data-placeholder="Required" data-format = 'd-M-Y'
                       data-js_format = 'DD-MMM-YYYY'  data-value = '{{ $user->doj }}' class="editable {{  $user->doj ? 'editable-click' : 'editable-empty'  }}">
                        {{  $user->doj  ?  date('d-M-Y', strtotime($user->doj))  : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.location")</td>
                <td>
                    <a href="#" data-field = 'location_id' data-model="User" data-type="select" data-id = '{{ $user->id }}' data-placeholder="Required"
                       data-value = '{{ $user->location_id }}' class="editable {{  $user->location_id ? 'editable-click' : 'editable-empty'  }}">
                        {{  $user->location_id ? $user->location->airport->iata : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.department")</td>
                <td>
                    <a href="#" data-field = 'department_id' data-model="UserDepartment" data-type="select" data-id = '{{ $user->id }}' data-foreign_key = 'user_id'
                       data-placeholder="Required" data-value = '{{ $user->department_id }}' class="editable {!! $user->department_id ? 'editable-click' : 'editable-empty' !!}">
                        {!! $user->department_id ? $user->department_name : 'Empty' !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.position")</td>
                <td>
                    <a href="#" data-field = 'position_id' data-model="UserDepartment" data-type="select" data-id = '{{ $user->id }}' data-foreign_key = 'user_id'
                       data-placeholder="Required"  data-value = '{{ $user->position_id }}' class="editable {!! $user->position_id ? 'editable-click' : 'editable-empty' !!}">
                        {!! $user->position_id ? $user->position_title : 'Empty' !!}</a>
                </td>
            </tr>

            @if ($crewType == 'fcm')
                <tr>
                    <td class="header_profile">Captain</td>
                    <td>
                        <a href="#" data-field = 'is_captain' data-model="CaptainFirstOfficer" data-type="select" data-id = '{{ $user->id }}' data-foreign_key = 'user_id'
                           data-placeholder="Required" data-value = '{{ isCaptain($user) }}' class="editable {!! isCaptain($user) ? 'editable-click' : 'editable-empty' !!}">
                            {!! isCaptain($user) ? "Yes" : "No" !!}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">English Level</td>
                    <td>
                        <a href="#" data-field = 'english_level' data-model="CaptainFirstOfficer" data-type="select" data-id = '{{ $user->id }}' data-foreign_key = 'user_id'
                           data-placeholder="Required" data-value = '{{ $user->english_level }}' class="editable {!! $user->english_level ? 'editable-click' : 'editable-empty' !!}">
                            {!! $user->english_level ? $user->english_level : "Empty" !!}</a>
                    </td>
                </tr>
            @elseif($crewType == 'ccm')
                <tr>
                    <td class="header_profile">Purser</td>
                    <td>
                        <a href="#" data-field = 'is_purser' data-model="CabinCrew" data-type="select" data-id = '{{ $user->id }}' data-foreign_key = 'user_id'
                           data-placeholder="Required" data-value = '{{ isPurser($user) }}' class="editable {!! isPurser($user) ? 'editable-click' : 'editable-empty' !!}">
                            {!! isPurser($user) ? "Yes" : "No" !!}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Business Class</td>
                    <td>
                        <a href="#" data-field = 'is_business_crew' data-model="CabinCrew" data-type="select" data-id = '{{ $user->id }}' data-foreign_key = 'user_id'
                           data-placeholder="Required" data-value = '{{ $user->is_business_crew }}' class="editable {!! $user->is_business_crew ? 'editable-click' : 'editable-empty' !!}">
                            {!! $user->is_business_crew ? "Yes" : "No" !!}</a>
                    </td>
                </tr>
            @endif
            <tr>
                <td class="header_profile">@lang("content.language")</td>
                <td>
                    <a href="#" data-field = 'language_id' data-model="UserLanguage" data-type="multiselect" data-id = '{{ $user->id }}' data-foreign_key = 'user_id'
                       data-placeholder="Required" data-value = '{!! json_encode(array_keys($languages)) !!}' class="editable {!! count($languages) ? 'editable-click' : 'editable-empty' !!}">
                        {!! count($languages) ? implode(', ', $languages) : 'Empty' !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.nationality")</td>
                <td>
                    <a href="#" data-field = 'nationality_id' data-model="User" data-type="select" data-id = '{{ $user->id }}' data-placeholder="Required"
                       data-value = '{!! $user->nationality_id !!}' class="editable {!! $user->nationality_id ? 'editable-click' : 'editable-empty' !!}">
                        {!! $user->nationality_id ? $user->nationality->nationality : 'Empty' !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">ID Card No</td>
                <td>
                    <a href="#" data-field = 'idcard_number' data-model="User" data-type="text" data-id = '{{ $user->id }}' data-placeholder="Required"
                       class="editable {{  $user->idcard_number ? 'editable-click' : 'editable-empty'  }}">{{ $user->idcard_number ? $user->idcard_number : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">ID Card Expires</td>
                <td>
                    <a href="#" data-field = 'idcard_expiry' data-model="User" data-type="date" data-id = '{{ $user->id }}' data-placeholder="Required" data-format = 'd-M-Y'
                       data-js_format = 'DD-MMM-YYYY'  data-value = '{{ $user->idcard_expiry }}' class="editable {{  $user->idcard_expiry ? 'editable-click' : 'editable-empty'  }}">
                        {{  $user->idcard_expiry  ?  date('d-M-Y', strtotime($user->idcard_expiry))  : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">Phone (Home)</td>
                <td>
                    <a href="#" data-field = 'phone' data-model="User" data-type="text" data-id = '{{ $user->id }}' data-placeholder="Required"
                       class="editable {{  $user->phone ? 'editable-click' : 'editable-empty'  }}">{{ $user->phone  ? $user->phone : 'Empty'}}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">Phone (Mobile)</td>
                <td>
                    <a href="#" data-field = 'mobile' data-model="User" data-type="text" data-id = '{{ $user->id }}' data-placeholder="Required"
                       class="editable {{  $user->mobile ? 'editable-click' : 'editable-empty'  }}">{{ $user->mobile ? $user->mobile : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">Reports To</td>
                <td>
                    @php $full_name = $user->reportsTo ? $user->reportsTo->first_name . " " . $user->reportsTo->last_name  : "-" @endphp
                    <a href="#" data-field = 'reports_to_user_id' data-model="User" data-type="select" data-id = '{{ $user->id }}' data-placeholder="Required"
                       data-value = '{{ $user->reports_to_user_id }}' class="editable {{  $user->reports_to_user_id ? 'editable-click' : 'editable-empty'  }}">
                        {{  $user->reports_to_user_id ? $full_name : 'Empty' }}</a>
                </td>
            </tr>
            </tbody>
        </table>
    {!!  Form::close()  !!}

</div>