<div class="tab-pane editable_div" id="general_crew" style="padding: 10px 0; overflow: auto; height: 340px">
    <div class="message_box"></div>
    {!!  Form::open(['method' => 'POST', 'class' => 'form-inline'])  !!}
        <table class="table table-bordered table-striped table-hover editable_table" data-user_id = "{{ $user->id }}" style="width:100%; padding: 0; margin: 0">
            <thead>
            </thead>
            <tbody>
            <tr>
                <th>Category</th>
                <th colspan="3">@lang("content.info")</th>
            </tr>
            <tr>
                <td class="header_profile">Staff No</td>
                <td>{{ $user->staff_number }}</td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.email")</td>
                <td>{{ $user->email }}</td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.date_of_birth")</td>
                <td>
                    <a href="#" data-field = 'dob' data-model="User" data-type="date" data-id = '{{ $user->id }}' data-placeholder="Required" data-format = 'd-M-Y'
                       data-js_format = 'DD-MMM-YYYY'  data-value = '{{ $user->dob }}' class="editable {{  $user->dob ? 'editable-click' : 'editable-empty'  }}">
                       {{  $user->dob  ?  date('d-M-Y', strtotime($user->dob))  : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.place_of_birth")</td>
                <td>
                    <a href="#" data-field = 'pob_country_id' data-model="User" data-type="select" data-id = '{{ $user->id }}' data-placeholder="Required"
                       data-value = '{{ $user->pob_country_id }}' class="editable {{  $user->pob_country_id ? 'editable-click' : 'editable-empty'  }}">
                        {{  $user->pob_country_id ? $user->pob->country : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">Date of Joining</td>
                <td>{{ $user->doj }}</td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.location")</td>
                <td>{{ $user->location_id ? $user->location->airport->iata : '' }}</td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.department")</td>
                <td>{{ $user->department_id ? $user->department_name : '' }}</td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.position")</td>
                <td>{{ $user->position_id ? $user->position_title : '' }}</td>
            </tr>

            @if ($crewType == 'fcm')
                <tr>
                    <td class="header_profile">Captain</td>
                    <td>{{ isCaptain($user) ? "Yes" : "No" }}</td>
                </tr>
                <tr>
                    <td class="header_profile">English Level</td>
                    <td>{{ $user->english_level ? $user->english_level : "" }}</td>
                </tr>
            @elseif($crewType == 'ccm')
                <tr>
                    <td class="header_profile">Purser</td>
                    <td>{{ isPurser($user) ? "Yes" : "No" }}</td>
                </tr>
            @endif

            <tr>
                <td class="header_profile">@lang("content.language")</td>
                <td>
                    <a href="#" data-field = 'language_id' data-model="UserLanguage" data-type="multiselect" data-id = '{{ $user->id }}' data-foreign_key = 'user_id'
                       data-placeholder="Required" data-value = '{!! json_encode(array_keys($languages)) !!}' class="editable {!! count($languages) ? 'editable-click' : 'editable-empty' !!}">
                        {{ count($languages) ? implode(', ', $languages) : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.nationality")</td>
                <td>
                    <a href="#" data-field = 'nationality_id' data-model="User" data-type="select" data-id = '{{ $user->id }}' data-placeholder="Required"
                       data-value = '{!! $user->nationality_id !!}' class="editable {!! $user->nationality_id ? 'editable-click' : 'editable-empty' !!}">
                        {{ $user->nationality_id ? $user->nationality->nationality : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">ID Card No</td>
                <td>{{ $user->idcard_number ? $user->idcard_number : '' }}</td>
            </tr>
            <tr>
                <td class="header_profile">ID Card Expires</td>
                <td>{{  $user->idcard_expiry  ?  date('d-M-Y', strtotime($user->idcard_expiry))  : '' }}</td>
            </tr>
            <tr>
                <td class="header_profile">Phone (Home)</td>
                <td>
                    <a href="#" data-field = 'phone' data-model="User" data-type="text" data-id = '{{ $user->id }}' data-placeholder="Required"
                       class="editable {{  $user->phone ? 'editable-click' : 'editable-empty'  }}">{{ $user->phone  ? $user->phone : 'Empty'}}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">Phone (Mobile)</td>
                <td>
                    <a href="#" data-field = 'mobile' data-model="User" data-type="text" data-id = '{{ $user->id }}' data-placeholder="Required"
                       class="editable {{  $user->mobile ? 'editable-click' : 'editable-empty'  }}">{{ $user->mobile ? $user->mobile : 'Empty' }}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">Reports To</td>
                <td>
                    @php $full_name = $user->reportsTo ? $user->reportsTo->first_name . " " . $user->reportsTo->last_name  : "-" @endphp
                    {{ $user->reports_to_user_id ? $full_name : '' }}
                </td>
            </tr>
            </tbody>
        </table>
    {!!  Form::close()  !!}

</div>