<?php require_once(public_path("smart/inc/init.php")); ?>

<link rel="stylesheet" href="{{ asset("/assets/js/vendor/select2/select2.css") }}">
<link rel="stylesheet" href="{{ asset("/assets/js/vendor/select2/select2-bootstrap.css") }}">

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @if ($errors->all())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{!! $error !!}</li>
                    @endforeach
                </ul>
            </div>
            @endif
            {!! Form::open(['method' => 'POST', 'class' => 'form-inline', 'id' => 'formCrewSchedule']) !!}
                <div class="form-group">
                    <label form="from">@lang("content.from")</label>
                    {!! Form::text('from', \request("from") ? \request("from") : date('Y-m-d'), ['class'=>'form-control dateFrom', 'placeholder'=>'From Date', 'required', 'id' => 'from']) !!}
                </div>
                <div class="form-group">
                    <label form="to">@lang("content.to")</label>
                    {!! Form::text('to',  \request("to") ? \request("to") : date('Y-m-d'), ['class'=>'form-control dateTo', 'placeholder' => 'To Date', 'required', 'id' => 'to']) !!}
                </div>
                <button type="submit" class="btn btn-sm btn-primary margin_right" id="search">@lang("content.submit")</button>
                @if (isset($flights) && count($flights))
                <div class="form-group">
                    {!! Form::label('send', trans("content.send_email_to")) !!}
                    {!! Form::select('crewType', ['ccm' => 'Cabin Crew', 'fcm' => 'Flight Crew'], null, ['class'=>'form-control input-sm', 'id' => 'crewType']) !!}
                    <button type="button" class="btn btn-sm btn-success" id="btn-send-all-flights-email">@lang("content.send_all_emails")</button>
                </div>
                @endif
            {!! Form::close() !!}
            <hr/>

        </article>

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

        @if (isset($from) && isset($to) && $from && $to)

            <ul class="nav nav-tabs" role="tablist">
                @php $start_time = $from @endphp
                @while (strtotime($start_time) <= strtotime($to))
                    <li {!!($start_time == $date) ? 'class="active"' : ''!!}>
                        <a href="{{ route("homepage")."#". url("crew-schedule") }}?from={{ $from }}&to={{ $to }}&date={{ $start_time }}">
                        {{ date("Y-m-d", strtotime($start_time)) }}
                        </a>
                    </li>
                    @php $start_time = date("Y-m-d", strtotime("+1 day", strtotime($start_time))) @endphp
                @endwhile
            </ul>

            @if (isset($flights) && count($flights) > 0)
                <div class="tab-content padding-10 background-white">
                    <div class="tab-pane active" id="home" style="padding: 10px">

                    {!!  Form::open(['id' => 'flights-form', 'class' => 'form-inline'])  !!}

                <!--<button type="button" class="btn btn-sm btn-primary" id="btn-save-all-flights">Save All Flights Crew</button>-->

                @foreach($flights as $flight)
                    <?php
                    $flightNumber = $flight->flightNumber;
                    $aircraft     = $flight->aircraft;
                    $flightCrew   = $flight->flightCrew;
                    $selectedCaptains = [
                        'general' => [(object)['id' => null]],
                        'standby' => [(object)['id' => null]],
                        'dhc' => [(object)['id' => null]]
                    ];
                    $selectedFirstOfficers = [
                        'general' => [(object)['id' => null]],
                        'standby' => [(object)['id' => null]],
                        'dhc' => [(object)['id' => null]]
                    ];
                    $selectedFlightAttendants = [
                        'general' => [
                            (object)['id' => null], (object)['id' => null], (object)['id' => null], (object)['id' => null]
                        ],
                        'standby' => [
                                (object)['id' => null]
                        ],
                        'dhc' => [
                            (object)['id' => null]
                        ],
                        'sup' => [
                            (object)['id' => null]
                        ]
                    ];

                    if (count($flightCrew)) {
                        if (isset($flightCrew['captains'])) {
                            foreach ($selectedCaptains as $type => $captainsItems) {
                                if (isset($flightCrew['captains'][$type])) {
                                    foreach ($flightCrew['captains'][$type] as $key => $captainItem) {
                                        $captainsItems[$key] = $captainItem;
                                    }
                                    $selectedCaptains[$type] = $captainsItems;
                                }
                            }
                        }
                        if (isset($flightCrew['firstOfficers'])) {
                            foreach ($selectedFirstOfficers as $type => $firstOfficersItems) {
                                if (isset($flightCrew['firstOfficers'][$type])) {
                                    foreach ($flightCrew['firstOfficers'][$type] as $key => $firstOfficerItem) {
                                        $firstOfficersItems[$key] = $firstOfficerItem;
                                    }
                                    $selectedFirstOfficers[$type] = $firstOfficersItems;
                                }
                            }
                        }
                        if (isset($flightCrew['flightAttendants'])) {
                            foreach ($selectedFlightAttendants as $type => $flightAttendantsItems) {
                                if (isset($flightCrew['flightAttendants'][$type])) {
                                    foreach ($flightCrew['flightAttendants'][$type] as $key => $flightAttendantItem) {
                                        $flightAttendantsItems[$key] = $flightAttendantItem;
                                    }
                                    $selectedFlightAttendants[$type] = $flightAttendantsItems;
                                }
                            }
                        }
                    }
                    ?>
                    <br/>
                    <table class="table table-bordered table-striped table-hover"
                           id="flight-{{ $flight->id }}" data-child-id="{{ $flight->child_id  }}">

                        <tr>
                            <td colspan="2" class="text-success">
                                A/C:  <strong class="color-green margin-right-13">{{ $aircraft ? "" . $aircraft->name : "-" }}</strong>
                                PTD: <strong class="color-black margin-right-13">{{ baseDateFormat(getFlightDepartureInitialDatePTD($flight), true) }}</strong>
                                FLT:  <strong class="color-green margin-right-13">{{ $CURRENT_IATA_CODE ." - ". $flightNumber->flight_number }} ({{ getFlightSector($flight) }})</strong>
                                @if ($flight->child_id)
                                    <strong class="color-green">/ {{$flightNumber->flight_number + 1 }}</strong>
                                @else
                                    <strong class="text-warning font11">Notice: inbound not found</strong>
                                @endif
                            </td>
                            <td>
                                <div>
                                    <a target="_blank" href="{{ url("flight-docs/{$flight->id}") }}">General Declaration</a>
                                    | <a target="_blank" href="{{ url("flight-docs/{$flight->id}?type=FLIGHT_ORDER") }}">Flight Order</a>
                                    | <a target="_blank" href="{{ url("flight-docs/{$flight->id}?type=FLIGHT_LOG") }}">Flight Log</a>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <th>Captains</th>
                            <th>First Officers</th>
                            <th>@lang("content.cancellation_notification")</th>
                        </tr>

                        <tr>
                            {{--CAPTAINS--}}
                            <td class="captains">

                                @if ($selectedCaptains)
                                    @foreach($selectedCaptains['general'] as $i => $item)
                                        <div class="form-group padding-3" data-item-number="{{ $i + 1 }}">
                                            <label>CAP #{{ $i+1 }}</label>
                                            {!! Form::select('captain[]', $captains, $item->id, ['class'=>'form-control input-sm', 'id'=>'captain'.($i+1)]) !!}
                                        </div>
                                        @if ($i < count($selectedCaptains['general']) - 1)
                                            {{--<br />--}}
                                        @endif
                                    @endforeach
                                    <div class="btn-group" style="float: none; clear: both;">
                                        <button type="button" data-field="captain" data-maxAllowed='3' data-crew_type = ""  class="btn btn-success btn-sm add-crew">+</button>
                                        <button type="button" data-field="captain" data-minAllowed='1' data-crew_type = ""  class="btn btn-danger btn-sm remove-crew">-</button>
                                    </div>

                                    <br />
                                    <br />

                                    @foreach($selectedCaptains['dhc'] as $i => $item)
                                        <div class="form-group" data-item-number="{{ $i + 1 }}">
                                            <label>DHC #{{ $i + 1 }}</label>
                                            {!! Form::select('captain_dhc[]', $captains, $item->id, ['class'=>'form-control input-sm', 'id'=>'captain_dhc'.($i+1)]) !!}
                                        </div>
                                        @if ($i < count($selectedCaptains['dhc']) - 1)
                                            <br />
                                        @endif
                                    @endforeach

                                    <div class="btn-group" style="float: none; clear: both;">
                                        <button type="button" data-field="captain_dhc" data-maxAllowed='5' data-crew_type = "DHC"  class="btn btn-success btn-sm add-crew">+</button>
                                        <button type="button" data-field="captain_dhc" data-minAllowed='1' data-crew_type = "DHC"  class="btn btn-danger btn-sm remove-crew">-</button>
                                    </div>
                                    <br />

                                    @foreach($selectedCaptains['standby'] as $i=>$item)
                                        <div class="form-group" data-item-number="{{ $i + 1 }}">
                                            <label>SBY #{{ $i + 1 }}</label>
                                            {!! Form::select('captain_standby[]', $captains, $item->id, ['class'=>'form-control input-sm', 'id'=>'captain_standby'.($i+1)]) !!}
                                        </div>
                                        @if ($i < count($selectedCaptains['standby']) - 1)
                                            <br />
                                        @endif
                                    @endforeach
                                    <div class="btn-group" style="float: none; clear: both;">
                                        <button type="button" data-field="captain_standby" data-maxAllowed = '2' data-crew_type = "Standby"  class="btn btn-success btn-sm add-crew">+</button>
                                        <button type="button" data-field="captain_standby" data-minAllowed='1' data-crew_type = "Standby"  class="btn btn-danger btn-sm remove-crew">-</button>
                                    </div>
                                    <br />

                                @endif
                            </td>

                            {{--FIRST OFFICERS--}}
                            <td class="first_officers">
                                @foreach($selectedFirstOfficers['general'] as $i=>$item)
                                   <div class="form-group" data-item-number="{{ $i + 1 }}">
                                        <label>#{{ $i + 1 }}</label>
                                        {!! Form::select('first_officer[]', $firstOfficers, $item->id, ['class'=>'form-control input-sm', 'id'=>'first_officer'.($i+1)]) !!}
                                    </div>
                                    @if ($i < count($selectedFirstOfficers['general']) - 1)
                                        <br />
                                    @endif
                                @endforeach
                                <div class="btn-group" style="float: none; clear: both;">
                                    <button type="button" data-field="first_officer" data-maxAllowed = '3' data-crew_type = ""  class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="first_officer" data-minAllowed='1' data-crew_type = ""  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>
                                <br />

                                @foreach($selectedFirstOfficers['dhc'] as $i=>$item)
                                   <div class="form-group" data-item-number="{{ $i + 1 }}">
                                        <label>DHC #{{ $i + 1 }}</label>
                                        {!! Form::select('first_officer_dhc[]', $firstOfficers, $item->id, ['class'=>'form-control input-sm', 'id'=>'first_officer_dhc'.($i+1)]) !!}
                                    </div>
                                    @if ($i < count($selectedFirstOfficers['dhc']) - 1)
                                        <br />
                                    @endif
                                @endforeach
                                <div class="btn-group" style="float: none; clear: both;">
                                    <button type="button" data-field="first_officer_dhc" data-maxAllowed = '5' data-crew_type = "DHC"  class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="first_officer_dhc" data-minAllowed='1' data-crew_type = "DHC"  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>
                                <br />

                                @foreach($selectedFirstOfficers['standby'] as $i=>$item)
                                   <div class="form-group" data-item-number="{{ $i + 1 }}">
                                        <label>Standby #{{ $i + 1 }}</label>
                                        {!! Form::select('first_officer_standby[]', $firstOfficers, $item->id, ['class'=>'form-control input-sm', 'id'=>'first_officer_standby'.($i+1)]) !!}
                                    </div>
                                    @if ($i < count($selectedFirstOfficers['standby']) - 1)
                                        <br />
                                    @endif
                                @endforeach
                                <div class="btn-group" style="float: none; clear: both;">
                                    <button type="button" data-field="first_officer_standby" data-maxAllowed = '2' data-crew_type = "Standby"  class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="first_officer_standby" data-minAllowed='1' data-crew_type = "Standby"  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>
                                <br />
                            </td>

                            {{--Notification--}}
                            <td class="notification_of_cancellation">
                                <div class="form-group">
                                    <label>Captains</label>
                                    {!! Form::select('captains_cancelled[]', $captains, null, ['class' => 'form-control input-sm select2', 'id'=>'captains_cancelled', 'style'=>'width:260px', 'multiple'=>'multiple']) !!}
                                </div><br/>
                                <div class="form-group">
                                    <label>First Officers</label>
                                    {!! Form::select('first_officers_cancelled[]', $firstOfficers, null, ['class' => 'form-control input-sm select2', 'id'=>'first_officers_cancelled', 'style'=>'width:260px', 'multiple'=>'multiple']) !!}
                                </div><br/>
                                <div class="form-group">
                                    <label>Cabin Crew</label>
                                    {!! Form::select('cabin_crew_cancelled[]', $cabinCrew, null, ['class' => 'form-control input-sm select2', 'id'=>'cabin_crew_cancelled', 'style'=>'width:260px', 'multiple'=>'multiple']) !!}
                                </div><br/>
                                <button type="button" class="btn btn-primary btn-sm btn-send-cancel-notifications">@lang("content.send_notification")</button>
                            </td>
                        </tr>

                        <tr>
                            <th>Cabin Crew</th>
                            <th>Cabin Crew DHC, Standby | SNY</th>
                            <th>@lang("content.actions")</th>
                        </tr>

                        <tr>
                            {{--Cabin Crew--}}
                            <td class="cabin_crew">
                                @foreach($selectedFlightAttendants['general'] as $i=>$item)
                                    <div class="form-group" data-item-number="{{ $i + 1 }}">
                                        <label>#{{ $i + 1 }}</label>
                                        {!! Form::select('cabin_crew[]', $cabinCrew, $item->id, ['class'=>'form-control input-sm', 'id'=>'cabin_crew'.($i+1)]) !!}
                                    </div>
                                    @if ($i < count($selectedFlightAttendants['general']) - 1)
                                        <br />
                                    @endif
                                @endforeach
                                <div class="btn-group" style="float: none; clear: both;">
                                    <button type="button" data-field="cabin_crew" data-maxAllowed = '8' data-crew_type = "" class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="cabin_crew" data-minAllowed='3' data-crew_type = ""  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>
                            </td>

                            {{--Cabin Crew Standby DHC--}}
                            <td class="cabin_crew_dhc_standby">
                                @foreach($selectedFlightAttendants['dhc'] as $i=>$item)
                                    <div class="form-group" data-item-number="{{ $i + 1 }}">
                                        <label>DHC #{{ $i + 1 }}</label>
                                        {!! Form::select('cabin_crew_dhc[]', $cabinCrew, $item->id, ['class'=>'form-control input-sm', 'id'=>'cabin_crew_dhc'.($i+1)]) !!}
                                    </div>
                                    @if ($i < count($selectedFlightAttendants['dhc']) - 1)
                                        <br />
                                    @endif
                                @endforeach
                                <div class="btn-group" style="float: none; clear: both;">
                                    <button type="button" data-field="cabin_crew_dhc" data-maxAllowed = '10' data-crew_type = "DHC" class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="cabin_crew_dhc" data-minAllowed='1' data-crew_type = "DHC"  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>
                                <br />

                                @foreach($selectedFlightAttendants['standby'] as $i=>$item)
                                    <div class="form-group" data-item-number="{{ $i + 1 }}">
                                        <label>Standby #{{ $i + 1 }}</label>
                                        {!! Form::select('cabin_crew_standby[]', $cabinCrew, $item->id, ['class'=>'form-control input-sm', 'id'=>'cabin_crew_standby'.($i+1)]) !!}
                                    </div>
                                    @if ($i < count($selectedFlightAttendants['standby']) - 1)
                                        <br />
                                    @endif
                                @endforeach
                                <div class="btn-group" style="">
                                    <button type="button" data-field="cabin_crew_standby" data-maxAllowed = '3'  data-crew_type = "Standby" class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="cabin_crew_standby" data-minAllowed='1' data-crew_type = "Standby"  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>
                                <br />

                                @foreach($selectedFlightAttendants['sup'] as $i => $item)
                                    <div class="form-group" data-item-number="{{ $i + 1 }}">
                                        <label>SNY #{{ $i + 1 }}</label>
                                        {!! Form::select('cabin_crew_sup[]', $staff, $item->id, ['class'=>'form-control input-sm', 'id'=>'cabin_crew_sup'.($i+1)]) !!}
                                    </div>
                                    @if ($i < count($selectedFlightAttendants['sup']) - 1)
                                        <br />
                                    @endif
                                @endforeach
                                <div class="btn-group" style="">
                                    <button type="button" data-field="cabin_crew_sup" data-maxAllowed = '3'  data-crew_type = "SUP" class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="cabin_crew_sup" data-minAllowed='1' data-crew_type = "SUP"  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>

                            </td>

                            {{--Actions--}}
                            <td>
                                <div style="margin: 0 0 10px 0">
                                    {!! Form::label('crewLabel', trans("content.send_email_to")) !!}
                                    {!! Form::select('crewType', ['ccm' => 'Cabin Crew', 'fcm' => 'Flight Crew'], null, ['class'=>'form-control input-sm individualCrewType']) !!}
                                </div>
                                <div class="btn-group">
                                    <button type="button" class="save-flight-crew btn btn-primary btn-sm">@lang("content.save_changes")</button>
                                    <button type="button" class="send-email-to-flight-crew btn btn-success btn-sm">@lang("content.send_email_to")</button>
                                </div>
                            </td>
                        </tr>

                    </table>
                    @endforeach

                    {!! Form::close() !!}
                    </div>
                </div>
            @else
                <br/>
                <div class="alert alert-warning" style="width: 50%">
                    <h4>@lang("content.found") 0 @lang("content.flights")</h4>
                </div>
            @endif

        @endif

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var exceptionInputs = ['#from', '#to', '#search'];


    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        {{--ApplyTableFilter("#table");--}}
    };

    loadScript("{{ asset("/assets/js/vendor/select2/select2.min.js") }}",
        loadScript("{{ asset("/assets/js/views/crew-schedule/index.js?2") }}",pagefunction)
    );

</script>


