<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div>
                {!! Form::open(['method' => 'POST', 'class' => 'form-inline', 'id' => 'formSearch']) !!}
                    <div class="form-group marginBottomRight">
                        <label for="first_name">@lang("content.first_name")</label>
                        {!! Form::text('first_name', \request("first_name"), ['class'=>'form-control input-sm', 'placeholder'=>'First Name', 'id'=>'first_name']) !!}
                    </div>
                    <div class="form-group marginBottomRight">
                        <label for="last_name">@lang("content.last_name")</label>
                        {!! Form::text('last_name', \request("last_name"), ['class'=>'form-control input-sm', 'id'=>'last_name', 'placeholder' => 'Last Name']) !!}
                    </div>

                    <div class="form-group marginBottomRight">
                        <label for="in">@lang("content.in")</label>
                        {!! Form::select('crew_type', $crewTypes, $crewType, ['id' => 'in', 'class' => 'singleselect']) !!}
                    </div>

                    <div class="form-group marginBottomRight">
                        <label for="location">@lang("content.location")</label>
                        {!! Form::select('location', $locations, \request("location"), ['class' => 'singleselect', 'id' => 'location']) !!}
                    </div>

                    <div class="form-group marginBottomRight">
                        {!! Form::submit("Submit", ['name' => 'submit', 'value' => "Submit", 'class' => 'btn-sm btn btn-primary']) !!}
                    </div>

                    <div id="additional_fields" style="{!! (\request("in") == 2) ? "display:none" : "" !!}">

                        <div class="form-group marginBottomRight">
                            <label>@lang("content.employee")</label>

                            <div class="btn-group margin_right">
                                {!! Form::select('user_type[]', $userTypes, \request("user_type"), [ "multiple" => "multiple", "class" => "multiselect", "style" => "width: 168px !important" ] ) !!}
                            </div>
                        </div>

                        <div class="form-group marginBottomRight" id="ccm_type">
                            <label>@lang("content.cabin_crew_type")</label>

                            <div class="btn-group margin_right">
                                {!! Form::select('ccm_type', $ccmTypes, \request("ccm_type"), [ "class" => "singleselect"] ) !!}
                            </div>
                        </div>

                        <div class="form-group marginBottomRight" id="english_level_block">
                            <label>@lang("content.english_level")</label>

                            <div class="btn-group margin_right">
                                {!! Form::select('english_level[]', ['1' => 1, '2' => 2, '3' => 3, '4' => 4, '5' => 5, '6' => 6], \request("english_level"), [ "multiple" => "multiple", "class" => "multiselect", 'id' => 'english_level']) !!}
                            </div>
                        </div>

                        <div class="form-group marginBottomRight">
                            <label>@lang("content.languages")</label>

                            <div class="btn-group margin_right">
                                {!! Form::select('lang[]', $languages, \request("lang"), [ "multiple" => "multiple", "class" => "multiselect"] ) !!}
                            </div>
                        </div>

                        <div class="form-group marginBottomRight">
                            <label>@lang("content.condition")</label>

                            <div class="btn-group">
                                {!! Form::select('condition[]', $conditions, \request("condition"), [ "multiple" => "multiple", "class" => "multiselect", 'id' => 'condition'] ) !!}
                            </div>
                        </div>

                        <div class="form-group marginBottomRight" id="date_range" style="{!! (\request("condition")) ? "" : "display:none" !!}">
                            <div class="form-group">
                                <label for="from">@lang("content.from")</label>
                                {!! Form::text('from', \request("from") ? \request("from") : date('Y-m-d'), ['class' => 'form-control datepicker', 'id' => 'from']) !!}
                            </div>
                            <div class="form-group">
                                <label for="to">@lang("content.to")</label>
                                {!! Form::text('to', \request("to") ? \request("to") : date('Y-m-d'), ['class' => 'form-control', 'id' => 'to']) !!}
                            </div>
                        </div>

                    </div>

                {!! Form::close() !!}
            </div>

            @if (isset($users) && count($users))

                <div class="alert alert-success">
                    @lang("content.found"): {!! count($users) !!} @lang("content.records").
                </div>

                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                    <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                    -->
                    <header>
                        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                        <h2>@lang("content.list") </h2>

                    </header>

                    <!-- widget div-->
                    <div>

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->

                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body no-padding">

                            <table class="table table-bordered table-striped table-hover">
                                <thead>
                                <tr>
                                    <th rowspan="2">No</th>
                                    <th rowspan="2" style="width: 36px !important;"></th>
                                    <th rowspan="2">@lang("content.first_name")</th>
                                    <th rowspan="2">@lang("content.last_name")</th>
                                    <th rowspan="2">@lang("content.position")</th>
                                    @if (\request("crew_type") == FCM_CREW)
                                        <th rowspan="2">@lang("content.english_level")</th>
                                    @else
                                        <th rowspan="2">@lang("content.business_class_crew")</th>
                                    @endif
                                    <th rowspan="2">SMS</th>
                                    <th rowspan="2">@lang("content.location")</th>
                                    <th colspan="3">@lang("content.flight_hours")</th>
                                    <th colspan="3">@lang("content.not_available")</th>
                                </tr>
                                <tr>
                                    <th>@lang("content.last_7_days")</th>
                                    <th>@lang("content.current_month")</th>
                                    <th>@lang("content.year_to_date")</th>
                                    <th>@lang("content.from")</th>
                                    <th>@lang("content.to")</th>
                                    <th>@lang("content.reason")</th>
                                </tr>
                                </thead>
                                <tbody>
                                @php $i = 0 @endphp
                                @foreach ($users as $user)
                                    @php $picture = $user->thumb ? 'users/' . $user->thumb : 'default-user-picture.png' @endphp
                                    <tr class="{!! $user->is_contractor ? 'contractorCrew' : '' !!}">
                                        <td>{{ ++$i }}</td>
                                        <td><a href="{{ route("homepage")."#". url("crew/profile?id={$user->user_id}") }}" target="_blank">
                                                <img src="{{ asset("assets/img/{$picture}") }}" class="img-thumbnail"  style="padding: 0;"/></a>
                                        </td>
                                        <td><a href="{{ route("homepage")."#". url("crew/profile?id={$user->user_id}") }}"target="_blank">{{ $user->first_name }}</a></td>
                                        <td><a href="{{ route("homepage")."#". url("crew/profile?id={$user->user_id}") }}"target="_blank">{{ $user->last_name }}</a></td>
                                        <td>{{ $user->position }}</td>
                                        @if (\request("crew_type") == FCM_CREW)
                                            <td>{{ $user->english_level }}</td>
                                        @else
                                            <td>{!! $user->is_business_crew ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>" !!}</td>
                                        @endif
                                        <td>{!! ($user->cmc_to && strtotime($user->cmc_to) > time()) ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>" !!}</td>
                                        <td>{{ $user->location && $user->location->airport ? $user->location->airport->iata : '' }}</td>
                                        <td>{{ isset($crewHours[$user->user_id]['last7days']) ? round($crewHours[$user->user_id]['last7days'], 2) : 0 }}</td>
                                        <td>{{ isset($crewHours[$user->user_id]['monthToDate']) ? round($crewHours[$user->user_id]['monthToDate'], 2) : 0 }}</td>
                                        <td>{{ isset($crewHours[$user->user_id]['yearToDate']) ? round($crewHours[$user->user_id]['yearToDate'], 2) : 0 }}</td>
                                        @php $from = '' @endphp
                                        @php $to = '' @endphp
                                        @php $reason = '' @endphp
                                        @forelse($user->userHistory as $history)
                                            @if (\request("from"))
                                                @if(strtotime(\request("from")) <= strtotime($history->to))
                                                    @php $from .= $history->from.'<br/>' @endphp
                                                    @php $to .= $history->to.'<br/>' @endphp
                                                    @php $reason .= $conditions[$history->condition_id].'<br/>' @endphp
                                                @endif
                                            @else
                                                @if(strtotime(date('Y-m-d')) <= strtotime($history->to))
                                                    @php $from .= $history->from.'<br/>' @endphp
                                                    @php $to .= $history->to.'<br/>' @endphp
                                                    @php $reason .= $conditions[$history->condition_id].'<br/>' @endphp
                                                @endif
                                            @endif
                                        @empty
                                        @endforelse
                                        <td>{{ $from }}</td>
                                        <td>{{ $to }}</td>
                                        <td>{{ $reason }}</td>

                                    </tr>
                                @endforeach
                                </tbody>
                            </table>

                        </div>

                    </div>

                </div>

            @elseif (\request("in"))
                <div class="alert alert-info">
                    <button type="button" class="close" data-dismiss="alert"><span
                                aria-hidden="true">&times;</span><span
                                class="sr-only">Close</span></button>
                    <h4>No Result!</h4>

                    <p>Not found any user for given params</p>
                </div>
            @endif

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");
    };

    loadScript("{{ asset("/assets/js/views/crew-query/index.js") }}", pagefunction);
</script>