<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <ul class="nav nav-tabs" id="myTab">
                    <div class="liner"></div>
                    <li class="{{ $selectedReport == "" ? "active" : "" }}">
                        <a href="#home" data-toggle="tab" title="welcome">
                            <i class="glyphicon glyphicon-home"></i>
                            <span class="tabText">@lang("content.home")</span>
                        </a>
                    </li>

                    <li>
                        <a href="#indicators" data-toggle="tab" title="welcome">
                            <i class="glyphicon glyphicon-tasks"></i>
                            <span class="tabText">Indicators</span>
                        </a>
                    </li>

                    <li>
                        <a href="#saved_queries" data-toggle="tab" title="profile">
                            <i class="glyphicon glyphicon-download"></i>
                            <span class="tabText">Saved Queries</span>
                        </a>
                    </li>
{{--
                    <li>
                        <a href="#population" data-toggle="tab" title="population">
                            <i class="glyphicon glyphicon-globe"></i>
                            <span class="tabText">Population</span>
                        </a>
                    </li>
--}}
                    <li class="{{ $selectedReport != "" ? "active" : "" }}">
                        <a href="#revenue_performance" data-toggle="tab" title="population">
                            <i class="glyphicon glyphicon-globe"></i>
                            <span class="tabText">Revenue Performance</span>
                        </a>
                    </li>
                </ul>

            <div class="tab-content">

                <div class="tab-pane {{ $selectedReport == "" ? "active" : "" }}" id="home">

                    <div class="col-lg-4" style="height: 700px; padding: 0">
                        @include('country/layouts/base-info')
                        @include('country/layouts/country-manager')
                    </div>

                    <div class="col-lg-8" id="map_div" style="height: 700px;"></div>
                </div>


                <div class="tab-pane" id="indicators">
                    {{--Country Base Info--}}
                    <div class="col-lg-4" style="height: 800px; padding: 0">
                        @include('country/layouts/base-info')

                        {{-- Draw Chart Form--}}
                        <div class="col-md-12 home_boxes" style="margin: 0">
                            @include('country/layouts/show-form', ['target' => '_blank'])
                        </div>

                    </div>

                    <article class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                        {{--Charts--}}
                        @foreach($charts as $j => $chart)
                            @include("template.canvas", [ "col" => 6, "id" => $j, "chartId" => $chart['div_id'], "title" => $chart['title'] ])
                            {{--<div class="col-md-4 home_boxes" style="margin:0">--}}
{{--                                        @include('country/layouts/chart')--}}
                            {{--</div>--}}
                        @endforeach
                    </article>
                </div>

                <div class="tab-pane" id="saved_queries">
                    {{--Saved Queries--}}
                    @include('country/layouts/saved-queries', ['height' => '700px'])
                </div>

                <div class="tab-pane" id="population">
                    <div class="col-lg-4" style="height: 700px; padding: 0">
                        {{--@include('country/layouts/base-info', ['widgetBgColor' => 'bg-light-blue', 'bodyBgColor' => 'bg-dark-blue'])--}}
                    </div>
                    <div class="col-lg-8" id="regions_div" style="height: 700px;"></div>
                </div>

                <div class="tab-pane {{ $selectedReport != "" ? "active" : "" }}" id="revenue_performance">
                    {{--@include('country.revenue-performance', ['countryProfile' => true])--}}
                </div>


                <div class="clearfix"></div>
            </div>

            <span style="color: #009000"></span>

        </article>

    </div>

</section>





<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        $(document).ready(function () {
            $('#form_elements').show();
        });

        var lineOptions = GetChartJsLineOptions();

        var ctx, chartData;

        // Chart PAX/REVENUE
        @foreach($charts as $chart)
            chartData = {
            labels: {!! json_encode($chart["data"]["date"]) !!},
            datasets: [
                {
                    label: "PAX (Outbound)",
                    backgroundColor: "rgba(50, 147, 50, 0.5)",
                    hoverBackgroundColor: "rgba(50, 147, 50, 0.8)",
                    borderColor: "rgba(50, 147, 50, 1)",
                    pointBackgroundColor: "rgba(50, 147, 50, 0.8)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(50, 147, 50, 1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius: 3,
                    data: {!! json_encode($chart["data"]["value"]) !!}
                    }
                ]
            };

            ctx = document.getElementById("{{ $chart['div_id'] }}").getContext("2d");
            new Chart(ctx, {
                type: 'line',
                data: chartData,
                options: lineOptions
            });
        @endforeach

   // Pax And Revenue Charts
        {{--@if (isset($paxChart))--}}
            {{--C3Charts({!! $paxChart  !!}, '#bar_chart_pax', 'bar', {height: 350, rotation: false, xLabel: 'PAX, no', xCategoryType: 'category', xCategoryArray : {!! $xAxisValues !!}  });--}}
            {{--C3Charts({!! $paxChart  !!}, '#donut_chart_pax', 'donut', {height: 350,  donutTitle : "PAX, no" });--}}
        {{--@endif--}}

        {{--@if (isset($revenueChart))--}}
            {{--C3Charts({!! $revenueChart  !!}, '#bar_chart_revenue', 'bar', {height: 350, rotation: false, xLabel: 'Revenue, USD', xCategoryType: 'category', xCategoryArray : {!! $xAxisValues !!} });--}}
            {{--C3Charts({!! $revenueChart  !!}, '#donut_chart_revenue', 'donut', {height: 350,  donutTitle : "Revenue, USD" });--}}
        {{--@endif--}}

//        google.load("visualization", "1", {packages: ["corechart", 'geomap', 'map']});
//        var options_pie = getChartOptions("", '100%', '100%', 'undefined', 'undefined', 15, 5, 'bottom', undefined, 'undefined', '70%', 45, 0.4),
//                options = getChartOptions("", '100%', '100%', 'undefined', 'undefined', 15, 5, 'undefined', 'no_legend', 'undefined', '70%', 30),
//                chartsArray = [];

        // JS Charts
        //google.setOnLoadCallback(function () {
            drawRegionsMap();
            drawMap();
        //});


        function drawRegionsMap() {

            var mapOptions = {
                center: new google.maps.LatLng(41.38155, 2.13752),
                zoom: 12,
            };
            map = new google.maps.Map(document.getElementById('regions_div'), mapOptions);

            /*
            var data = google.visualization.arrayToDataTable({!! $cities !!});

            var options = {
                region: '{{ $country->abbr }}',
                colors: [0xFF8747, 0xFFB581, 0xc06000],
                dataMode: 'markers',
                width: '100%',
                height: '700px'
            };

            var chart = new google.visualization.GeoMap(document.getElementById('regions_div'));

            chart.draw(data, options);
            */
        }

        function drawMap() {

            var mapOptions = {
                center: new google.maps.LatLng({{ $country->latitude }}, {{ $country->longitude }}),
                zoom: {{ $zoomLevel }},
            };

            var map = new google.maps.Map(document.getElementById('map_div'), mapOptions);

            /*
            var data = google.visualization.arrayToDataTable({!! $countryMap !!});

            var options = {
                mapType: 'normal',
                zoomLevel: {{ $zoomLevel }},
                showTip: true,
                useMapTypeControl: true,
                maps: {
                    // Your custom mapTypeId holding custom map styles.
                    styledMap: {
                        name: 'Styled Map', // This name will be displayed in the map type control.
                        styles: [
                            {
                                featureType: 'poi.attraction',
                                stylers: [{color: '#fce8b2'}]
                            },
                            {
                                featureType: 'road.highway',
                                stylers: [{hue: '#0277bd'}, {saturation: -50}]
                            },
                            {
                                featureType: 'road.highway',
                                elementType: 'labels.icon',
                                stylers: [{hue: '#000'}, {saturation: 100}, {lightness: 50}]
                            },
                            {
                                featureType: 'landscape',
                                stylers: [{hue: '#259b24'}, {saturation: 10}, {lightness: -22}]
                            }
                        ]
                    },
                    imBlue: {
                        name: 'Blue Style',
                        styles: [
                            {
                                featureType: 'landscape',
                                stylers: [{color: '#c5cae9'}]
                            },
                            {
                                featureType: 'water',
                                stylers: [{color: '#0288d1'}]
                            },
                            {
                                featureType: 'transit.station.airport',
                                stylers: [{color: '#0000ff'}, {saturation: 50}, {lightness: -50}]
                            }
                        ]
                    }
                }
            };

            var map = new google.visualization.Map(document.getElementById('map_div'));

            map.draw(data, options);

            */
        }
        // END CHART PAX/REVENUE
    };

    $(window).unbind('gMapsLoaded');
    $(window).bind('gMapsLoaded', function(){
        loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", function(){
            loadScript("{{ asset("/assets/js/views/country/show.js") }}", pagefunction);
        });
    });
    window.loadGoogleMaps();


</script>




