<?php
/**
 * Created by PhpStorm.
 * User: dimmer
 */
?>

@php $countryProfile = isset($countryProfile) ? $countryProfile : null @endphp

<div class="jarviswidget" id="wid-chart-id-6"
     data-widget-fullscreenbutton="false" data-widget-editbutton="false"
     data-widget-sortable="false">
    <!-- widget options:
        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        data-widget-colorbutton="false"
        data-widget-editbutton="false"
        data-widget-togglebutton="false"
        data-widget-deletebutton="false"
        data-widget-fullscreenbutton="false"
        data-widget-custombutton="false"
        data-widget-collapsed="true"
        data-widget-sortable="false"

    -->
    <header>
        <h2>Country Query</h2>
    </header>

    <!-- widget div-->
    <div>
        {!! Form::open(['class' => 'form-inline', 'method'=>'GET', 'data-no_alert', 'id' => 'formCountryQuery']) !!}
        <div class="col-lg-12">

            <div id="form_elements" style="display: none; width: 100%; min-height: 90px">
                @include('country.revenue-form', ['submit' => false, 'countryProfile' => $countryProfile])
            </div>

            @if (isset($tableData) && count($tableData))
                @php $grand_total_pax = isset($tableData['pax']['total']) ? $tableData['pax']['total'] : 0 @endphp
                @php $grand_total_revenue = isset($tableData['revenue']['total']) ? $tableData['revenue']['total'] : 0 @endphp
                @php $grand_total_yield = $grand_total_pax ? $grand_total_revenue / $grand_total_pax : 0 @endphp
                <div class="alert alert-success" style="display: block; height: 50px">
                        <span style="float: left">
                            Found: <h5 class="info">{{ isset($grand_total_pax) ? number_format($grand_total_pax) : 0 }}
                                Records.</h5>
                        </span>
                        <span style="float: right">
                            Revenue: <h5 class="info">
                                ${{ isset($grand_total_revenue) ? number_format($grand_total_revenue) : 0 }}</h5>
                            PAX: <h5 class="info">{{ isset($grand_total_pax) ? number_format($grand_total_pax) : 0 }}</h5>
                            Yield: <h5 class="info">
                                ${{ isset($grand_total_pax) ? (is_numeric($grand_total_yield) ? number_format($grand_total_yield) : 0) : 0 }}</h5>
                        </span>
                </div>
            @endif

            <div class="tabbable">
                <ul class="nav nav-tabs" id="myTab">
                    @if (!$countryProfile)
                        <li class="{{ ($selectedReport == REGION_REPORT || $selectedReport == "") ? "active" : "" }}">
                            <a href="#region_page" data-toggle="tab" title="">
                                <i class="glyphicon glyphicon-home"></i>
                                <span class="tabText">@lang("content.region")</span>
                            </a>
                        </li>
                        <li class="{{ $selectedReport == COUNTRY_REPORT ? "active" : "" }}">
                            <a href="#country_page" data-toggle="tab" title="">
                                <i class="glyphicon glyphicon-book"></i>
                                <span class="tabText">@lang("content.country")</span>
                            </a>
                        </li>
                        <li class="{{ $selectedReport == CITY_REPORT ? "active" : "" }}">
                            <a href="#city_page" data-toggle="tab" title="">
                                <i class="glyphicon glyphicon-book"></i>
                                <span class="tabText">@lang("content.city")</span>
                            </a>
                        </li>
                    @else
                        <li class="{{ ($selectedReport == CITY_REPORT || $selectedReport == "") ? "active" : "" }}">
                            <a href="#city_page" data-toggle="tab" title="">
                                <i class="glyphicon glyphicon-book"></i>
                                <span class="tabText">@lang("content.city")</span>
                            </a>
                        </li>
                    @endif

                    <li class="{{ $selectedReport == AGENCY_REPORT ? "active" : "" }}">
                        <a href="#agency_page" data-toggle="tab" title="">
                            <i class="glyphicon glyphicon-book"></i>
                            <span class="tabText">P.O.S.</span>
                        </a>
                    </li>
                    <li class="{{ $selectedReport == SALES_CHANNEL_REPORT ? "active" : "" }}">
                        <a href="#sales_channel_page" data-toggle="tab" title="">
                            <i class="glyphicon glyphicon-book"></i>
                            <span class="tabText">@lang("content.sales_channel")</span>
                        </a>
                    </li>
                    <li class="{{ $selectedReport == GDS_REPORT ? "active" : "" }}">
                        <a href="#gds_page" data-toggle="tab" title="">
                            <i class="glyphicon glyphicon-book"></i>
                            <span class="tabText">GDS</span>
                        </a>
                    </li>
                    <li class="{{ $selectedReport == FLIGHT_NUMBER_REPORT ? "active" : "" }}">
                        <a href="#flight_number_page" data-toggle="tab" title="">
                            <i class="glyphicon glyphicon-book"></i>
                            <span class="tabText">@lang("content.flight_number")</span>
                        </a>
                    </li>
                    <li class="{{ $selectedReport == SECTOR_REPORT ? "active" : "" }}">
                        <a href="#sector_page" data-toggle="tab" title="">
                            <i class="glyphicon glyphicon-book"></i>
                            <span class="tabText">@lang("content.sector")</span>
                        </a>
                    </li>
                    <li class="{{ $selectedReport == ROUTE_REPORT ? "active" : "" }}">
                        <a href="#route_page" data-toggle="tab" title="">
                            <i class="glyphicon glyphicon-book"></i>
                            <span class="tabText">@lang("content.route")</span>
                        </a>
                    </li>
                    <li class="{{ $selectedReport == CABIN_REPORT ? "active" : "" }}">
                        <a href="#cabin_page" data-toggle="tab" title="">
                            <i class="glyphicon glyphicon-book"></i>
                            <span class="tabText">@lang("content.cabin")</span>
                        </a>
                    </li>
                    <li class="{{ $selectedReport == RBD_REPORT ? "active" : "" }}">
                        <a href="#rbd_page" data-toggle="tab" title="">
                            <i class="glyphicon glyphicon-book"></i>
                            <span class="tabText">RBD</span>
                        </a>
                    </li>
                </ul>

                <div class="tab-content" style="background-color: #ffffff">
                    @if (!$countryProfile)
                        <div class="tab-pane tab_holder {{ ($selectedReport == REGION_REPORT || $selectedReport == "") ? "active" : "" }}"
                             id="region_page">
                            <div class="col-md-12" style="margin-bottom: 20px; overflow: hidden">
                                <div class="col-sm-11"></div>
                                <div class="col-sm-1">
                                    {!!Form::submit("Submit", [ 'name' => "region_report", 'class' => "btn btn-primary" ])!!}
                                </div>
                            </div>
                            @include('country.revenue-report', ['report' => REGION_REPORT, 'report_name' => "Region"])
                        </div>

                        <div class="tab-pane tab_holder {{ $selectedReport == COUNTRY_REPORT ? "active" : "" }}"
                             id="country_page">
                            <div class="col-md-12" style="margin-bottom: 20px">
                                <div class="col-sm-11"></div>
                                <div class="col-sm-1">
                                    {!!Form::submit("Submit", [ 'name' => "country_report", 'class' => "btn btn-primary" ])!!}
                                </div>
                            </div>
                            @include('country.revenue-report', ['report' => COUNTRY_REPORT, 'report_name' => "Country"])
                        </div>

                        <div class="tab-pane tab_holder {{ $selectedReport == CITY_REPORT ? "active" : "" }}" id="city_page">
                            <div class="col-md-12" style="margin-bottom: 20px">
                                <div class="col-sm-11"></div>
                                <div class="col-sm-1">
                                    {!!Form::submit("Submit", [ 'name' => "city_report", 'class' => "btn btn-primary" ])!!}
                                </div>
                            </div>
                            @include('country.revenue-report', ['report' => CITY_REPORT, 'report_name' => "City"])
                        </div>

                    @else
                        <div class="tab-pane tab_holder {{ ($selectedReport == CITY_REPORT  || $selectedReport == "") ? "active" : "" }}" id="city_page">
                            <div class="col-md-12" style="margin-bottom: 20px">
                                <div class="col-sm-11"></div>
                                <div class="col-sm-1">
                                    {!!Form::submit("Submit", [ 'name' => "city_report", 'class' => "btn btn-primary" ])!!}
                                </div>
                            </div>
                            @include('country.revenue-report', ['report' => CITY_REPORT, 'report_name' => "City"])
                        </div>
                    @endif

                    <div class="tab-pane tab_holder {{ $selectedReport == AGENCY_REPORT ? "active" : "" }}" id="agency_page">
                        <div class="col-md-12" style="margin-bottom: 20px">
                            <div class="col-sm-11"></div>
                            <div class="col-sm-1">
                                {!!Form::submit("Submit", [ 'name' => "agency_report", 'class' => "btn btn-primary" ])!!}
                            </div>
                        </div>
                        @include('country.revenue-report', ['report' => AGENCY_REPORT, 'report_name' => "Agency"])
                    </div>

                    <div class="tab-pane tab_holder {{ $selectedReport == SALES_CHANNEL_REPORT ? "active" : "" }}" id="sales_channel_page">
                        <div class="col-md-12" style="margin-bottom: 20px">
                            <div class="col-sm-11"></div>
                            <div class="col-sm-1">
                                {!!Form::submit("Submit", [ 'name' => "sales_channel_report", 'class' => "btn btn-primary" ])!!}
                            </div>
                        </div>
                        @include('country.revenue-report', ['report' => SALES_CHANNEL_REPORT, 'report_name' => "Sales Channel"])
                    </div>

                    <div class="tab-pane tab_holder {{ $selectedReport == GDS_REPORT ? "active" : "" }}" id="gds_page">
                        <div class="col-md-12" style="margin-bottom: 20px">
                            <div class="col-sm-11"></div>
                            <div class="col-sm-1">
                                {!!Form::submit("Submit", [ 'name' => "gds_report", 'class' => "btn btn-primary" ])!!}
                            </div>
                        </div>
                        @include('country.revenue-report', ['report' => GDS_REPORT, 'report_name' => "GDS"])
                    </div>

                    <div class="tab-pane tab_holder {{ $selectedReport == FLIGHT_NUMBER_REPORT ? "active" : "" }}" id="flight_number_page">
                        <div class="col-md-12" style="margin-bottom: 20px">
                            <div class="col-sm-11"></div>
                            <div class="col-sm-1">
                                {!!Form::submit("Submit", [ 'name' => "flight_number_report", 'class' => "btn btn-primary" ])!!}
                            </div>
                        </div>
                        @include('country.revenue-report', ['report' => FLIGHT_NUMBER_REPORT, 'report_name' => "Flight Number", 'boundLegend' => TRUE])
                    </div>

                    <div class="tab-pane tab_holder {{ $selectedReport == SECTOR_REPORT ? "active" : "" }}" id="sector_page">
                        <div class="col-md-12" style="margin-bottom: 20px">
                            <div class="col-sm-11"></div>
                            <div class="col-sm-1">
                                {!!Form::submit("Submit", [ 'name' => "sector_report", 'class' => "btn btn-primary" ])!!}
                            </div>
                        </div>
                        @include('country.revenue-report', ['report' => SECTOR_REPORT, 'report_name' => "Sector", 'boundLegend' => TRUE])
                    </div>

                    <div class="tab-pane tab_holder {{ $selectedReport == ROUTE_REPORT ? "active" : "" }}" id="route_page">
                        <div class="col-md-12" style="margin-bottom: 20px">
                            <div class="col-sm-11"></div>
                            <div class="col-sm-1">
                                {!!Form::submit("Submit", [ 'name' => "route_report", 'class' => "btn btn-primary" ])!!}
                            </div>
                        </div>
                        @include('country.revenue-report-route', ['report' => ROUTE_REPORT, 'report_name' => "Route"])
                    </div>

                    <div class="tab-pane tab_holder {{ $selectedReport == CABIN_REPORT ? "active" : "" }}" id="cabin_page">
                        <div class="col-md-12" style="margin-bottom: 20px">
                            <div class="col-sm-11"></div>
                            <div class="col-sm-1">
                                {!!Form::submit("Submit", [ 'name' => "cabin_report", 'class' => "btn btn-primary" ])!!}
                            </div>
                        </div>
                        @include('country.revenue-report', ['report' => CABIN_REPORT, 'report_name' => "Cabin"])
                    </div>

                    <div class="tab-pane tab_holder {{ $selectedReport == RBD_REPORT ? "active" : "" }}" id="rbd_page">
                        <div class="col-md-12" style="margin-bottom: 20px">
                            <div class="col-sm-11"></div>
                            <div class="col-sm-1">
                                {!!Form::submit("Submit", [ 'name' => "rbd_report", 'class' => "btn btn-primary" ])!!}
                            </div>
                        </div>
                        @include('country.revenue-report', ['report' => RBD_REPORT, 'report_name' => "RBD"])
                    </div>

                    <div class="clearfix"></div>
                </div>
            </div>

        </div>
        {!! Form::close() !!}
    </div>
</div>
