@php $formAttributes = ['method' => 'GET', 'class' => 'form-horizontal', 'url' => url('country/chart'), 'id' => 'formIndicators'] @endphp
@php $editMode = isset($editMode) ? true : false @endphp
@if (isset($target))
    @php $formAttributes['target'] = $target @endphp
@endif

    <!-- Widget ID (each widget will need unique ID)-->
    <div class="jarviswidget" id="wid-chart-id-5"
         data-widget-fullscreenbutton="false" data-widget-editbutton="false"
         data-widget-sortable="false">
        <!-- widget options:
            usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

            data-widget-colorbutton="false"
            data-widget-editbutton="false"
            data-widget-togglebutton="false"
            data-widget-deletebutton="false"
            data-widget-fullscreenbutton="false"
            data-widget-custombutton="false"
            data-widget-collapsed="true"
            data-widget-sortable="false"

        -->
        <header>
            <h2>World Development Indicators</h2>
        </header>

        <!-- widget div-->
        <div>
            {!! Form::open($formAttributes) !!}

            <div class="col-sm-12 list-header">
                <div class="col-xs-3 list">Income Levels</div>
                <div class="col-xs-9">
                    {!! Form::select('incomeLevels[]', $incomeLevels, \request("incomeLevels"), ['id' => 'incomeLevels', 'multiple' => 'multiple', 'class' => 'form-control multiselect_search_all']) !!}
                </div>
            </div>
            <div class="col-sm-12 list-header">
                <div class="col-xs-3 list">Regions</div>
                <div class="col-xs-9">
                    {!! Form::select('regions[]', $regions, \request("regions"), ['id' => 'regions', 'multiple' => 'multiple', 'class' => 'form-control multiselect_search_all']) !!}
                </div>
            </div>
            <div class="col-sm-12 list-header">
                <div class="col-xs-3 list">Countries</div>
                <div class="col-xs-9">
                    {!! Form::select('countries[]', $countries, \request("countries"), ['id' => 'countries', 'multiple' => 'multiple', 'class' => 'form-control multiselect_search_all']) !!}
                </div>
            </div>
            <div class="col-sm-12 list-header">
                <div class="col-xs-3 list">@lang("content.period")</div>
                <div class="col-xs-3">
                    {!! Form::select('periodFrom', $period, \request("periodFrom"), ['class' => 'form-control', 'required' => 'required']) !!}
                </div>
                <div class="col-xs-3">
                    {!! Form::select('periodTo', $period, \request("periodTo"), ['class' => 'form-control']) !!}
                </div>
            </div>
            <div class="col-sm-12 list-header">
                <div class="col-xs-3 list">Category</div>
                <div class="col-xs-9">
                    {!! Form::select('category', $categories, \request("category"), ['id' => 'indicator_category', 'class' => 'form-control']) !!}
                </div>
            </div>
            <div class="col-sm-12 list-header">
                <div class="col-xs-3 list">Indicator</div>
                <div class="col-xs-9">
                    {!! Form::select('indicator_id', $indicators, \request("indicator_id"), ['class' => 'form-control', 'required' => 'required']) !!}
                </div>
            </div>

            <div class="col-sm-12 list-header" style="margin-top: 20px">
                <div class="col-xs-8">
                    {!! Form::submit('Draw Chart', array('class'=>'btn btn-warning'))!!}
                    {!! Form::hidden('currentUrl', URL::current()) !!}
                    @if ($editMode)
                        <a href="#" class="btn btn-success ajax_within_page" data-parentElement="#saved_queries .stats-list .body" data-operationType="prepend" data-actionUrl = "{{ route("homepage")."#". url('template/ajax-add-indicators-query') }}">Save New</a>
                        @if (isset($userIndicatorId) && $userIndicatorId)
                            <a href="#" class="btn btn-primary ajax_within_page" data-parentElement="#saved_queries .stats-list .body" data-substituteId="#query_{{ $userIndicatorId }}" data-operationType="substitute" data-actionUrl = "{{ route("homepage")."#". url("indicator/user/{$userIndicatorId}/update") }}">Update Current</a>
                        @endif
                    @endif
                </div>
                <div class="col-xs-4" data-right>
                    <img style="height: 30px; text-align: right" src="{{ asset('assets/img/logos/world_bank2.png') }}"/>
                </div>
            </div>


            {!! Form::close() !!}

        </div>

    </div>
