@if ($countryManager)
    @php $user = $countryManager->user @endphp
    @php $picture = 'profile.png' @endphp
    @if ( $user->thumb && file_exists(asset("storage/users/{$user->thumb}")))
        @php $picture = $user->thumb @endphp
    @endif

    <div class="col-md-12 home_boxes" style="margin: 0">
        <div class="widget widget-stats" style="height: 257px">
            <div class="col-sm-12" style="padding: 0">
                <div class="stats-chart" style="float: left; width: 20%; height: auto">
                    <a target="_blank" href="{{ url("/user/{$user->id}")  }}"><img width="100%" src="{{ asset("storage/users/{$picture}") }}" /></a>
                </div>
                <div class="stats-list" style="float: left; width: 70%; margin-top: 10px">
                    <div class="list-my-group-2">
                        <div class="body bg-dark-blue">
                            <div>
                                <div class="title">@lang("content.name")</div>
                                <div>{{ $user->first_name." ".$user->last_name }}</div>
                            </div>
                            <div>
                                <div class="title">@lang("content.position")</div>
                                <div><a target="_blank" href="{{ url("/organization/new-chart/{$countryManager->organization_id}") }}">
                                        {{ $countryManager->position->name }}</a>
                                </div>
                            </div>
                            <div>
                                <div class="title">Level</div>
                                <div>{{ $countryManager->level }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            @if ($reportees && count($reportees))
                @foreach($reportees as $each)
                    @if (!$each || !$each->user)
                        @continue
                    @endif

                    @php $reportee = $each->user @endphp

                    @php $picture = 'profile.png' @endphp
                    @if ( $reportee->thumb && file_exists(asset("storage/users/{$reportee->thumb}")))
                        @php $picture = $reportee->thumb @endphp
                    @endif

                    <div class="col-sm-6" style="padding: 0;">
                        <div class="stats-chart" style="float: left; width: 22%; height: auto">
                            <a target="_blank" href="{{ url("/user/{$reportee->id}")  }}">
                                <img width="100%" height="100%" src="{{ asset("storage/users/{$picture}") }}" />
                            </a>
                        </div>
                        <div class="stats-list" style="float: left; width: 70%; margin-top: 10px">
                            <div class="list-my-group-2">
                                <div class="body font12 bg-dark-blue">
                                    <div>
                                        <div>{{ $reportee->first_name." ".$reportee->last_name }}</div>
                                    </div>
                                    <div>
                                        <div>
                                            <a target="_blank" href="{{ url("/organization/new-chart/{$each->id}") }}">
                                                {{ $each->position ? $each->position->name : "" }}
                                            </a>
                                        </div>
                                    </div>
                                    {{--<div>
                                        <div class="title">Level</div>
                                        <div>{{ $each->organizationLevel->level }}</div>
                                    </div>--}}
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>
    </div>
@endif
