<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
            <!-- Widget ID (each widget will need unique ID)-->
            <div class="jarviswidget" id="wid-chart-id-chart-1"
                 data-widget-fullscreenbutton="false" data-widget-editbutton="false"
                 data-widget-sortable="false">
                <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                -->
                <header>
                    <h2>@lang("content.list")</h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->
                        <input class="form-control" type="text">
                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body">

                        <div>
                            {!! Form::open(['method' => 'GET', 'target' => '_blank', 'class' => 'form-horizontal form-inline', 'url' => url('country/search')]) !!}
                                {!! Form::select('country', $countries, null, ['class' => 'form-control']) !!}
                                {!! Form::submit('Submit', [ 'name' => 'submit', 'class' => 'btn btn-warning']) !!}
                            {!! Form::close() !!}
                        </div>

                        @foreach($countryFlags as $i => $each)
                            <p class="flag_tooltip">
                                <a target="_blank" href="{{ route("homepage")."#".url("/country/{$each['id']}") }}"><img src="{{ $each['thumb'] }}" alt="" />
                                    <span>
                                        <strong>{{ $each['country'] }}</strong><br />
                                        ISO: {{ $each['iso'] }}<br />
                                        @lang("content.population"): {{ number_format($each['population']) }}<br />
                                        @lang("content.area"): {{ number_format($each['area']) }}<br />
                                        @lang("content.density"): {{ $each['density'] }}
                                    </span>
                                </a>
                            </p>
                        @endforeach
                        {{--<div class="col-md-8" id="countries" style="height: 650px; padding: 10px; border: 1px solid #ffb02c"></div>--}}
                    </div>

                </div>

            </div>

        </article>

        <article class="col-sm-12 col-md-8 col-lg-8">

            <!-- new widget -->
            <div class="jarviswidget" id="wid-id-2" data-widget-colorbutton="false" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->

                <header>
                    <span class="widget-icon"> <i class="fa fa-map-marker"></i> </span>
                    <h2>@lang("content.map")</h2>
                </header>

                <!-- widget div-->
                <div>
                    <div class="widget-body no-padding">
                        <!-- content goes here -->

                        <div id="vector-map" class="vector-map" style="height: 500px !important;"></div>
                        <div id="heat-fill">
                            <span class="fill-a">0</span>

                            <span class="fill-b">{{ $maxPopulation }}</span>
                        </div>

                        {{--<table class="table table-striped table-hover table-condensed">--}}
                            {{--<thead>--}}
                            {{--<tr>--}}
                                {{--<th>Country</th>--}}
                                {{--<th>Visits</th>--}}
                                {{--<th class="text-align-center">User Activity</th>--}}
                                {{--<th class="text-align-center hidden-xs">Online</th>--}}
                                {{--<th class="text-align-center">Demographic</th>--}}
                            {{--</tr>--}}
                            {{--</thead>--}}
                            {{--<tbody>--}}
                            {{--<tr>--}}
                                {{--<td><a href="javascript:void(0);">USA</a></td>--}}
                                {{--<td>4,977</td>--}}
                                {{--<td class="text-align-center">--}}
                                    {{--<div class="sparkline txt-color-blue text-align-center" data-sparkline-height="22px" data-sparkline-width="90px" data-sparkline-barwidth="2">--}}
                                        {{--2700, 3631, 2471, 1300, 1877, 2500, 2577, 2700, 3631, 2471, 2000, 2100, 3000--}}
                                    {{--</div></td>--}}
                                {{--<td class="text-align-center hidden-xs">143</td>--}}
                                {{--<td class="text-align-center">--}}
                                    {{--<div class="sparkline display-inline" data-sparkline-type='pie' data-sparkline-piecolor='["#E979BB", "#57889C"]' data-sparkline-offset="90" data-sparkline-piesize="23px">--}}
                                        {{--17,83--}}
                                    {{--</div>--}}
                                    {{--<div class="btn-group display-inline pull-right text-align-left hidden-tablet">--}}
                                        {{--<button class="btn btn-xs btn-default dropdown-toggle" data-toggle="dropdown">--}}
                                            {{--<i class="fa fa-cog fa-lg"></i>--}}
                                        {{--</button>--}}
                                        {{--<ul class="dropdown-menu dropdown-menu-xs pull-right">--}}
                                            {{--<li>--}}
                                                {{--<a href="javascript:void(0);"><i class="fa fa-file fa-lg fa-fw txt-color-greenLight"></i> <u>P</u>DF</a>--}}
                                            {{--</li>--}}
                                            {{--<li>--}}
                                                {{--<a href="javascript:void(0);"><i class="fa fa-times fa-lg fa-fw txt-color-red"></i> <u>D</u>elete</a>--}}
                                            {{--</li>--}}
                                            {{--<li class="divider"></li>--}}
                                            {{--<li class="text-align-center">--}}
                                                {{--<a href="javascript:void(0);">Cancel</a>--}}
                                            {{--</li>--}}
                                        {{--</ul>--}}
                                    {{--</div></td>--}}
                            {{--</tr>--}}
                           {{----}}
                            {{--</tbody>--}}
                            {{--<tfoot>--}}
                            {{--<tr>--}}
                                {{--<td colspan=5>--}}
                                    {{--<ul class="pagination pagination-xs no-margin">--}}
                                        {{--<li class="prev disabled">--}}
                                            {{--<a href="javascript:void(0);">Previous</a>--}}
                                        {{--</li>--}}
                                        {{--<li class="active">--}}
                                            {{--<a href="javascript:void(0);">1</a>--}}
                                        {{--</li>--}}
                                        {{--<li>--}}
                                            {{--<a href="javascript:void(0);">2</a>--}}
                                        {{--</li>--}}
                                        {{--<li>--}}
                                            {{--<a href="javascript:void(0);">3</a>--}}
                                        {{--</li>--}}
                                        {{--<li class="next">--}}
                                            {{--<a href="javascript:void(0);">Next</a>--}}
                                        {{--</li>--}}
                                    {{--</ul></td>--}}
                            {{--</tr>--}}
                            {{--</tfoot>--}}
                        {{--</table>--}}

                        <!-- end content -->

                    </div>

                </div>
                <!-- end widget div -->
            </div>
            <!-- end widget -->

        </article>

    </div>

</section>




{{--<script type="text/javascript" src="https://www.google.com/jsapi"></script>--}}

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        data_array = {!! json_encode($chartArray) !!};

        // Load Map dependency 1 then call for dependency 2 and then run renderVectorMap function
        loadScript("<?php echo ASSETS_URL ?>/js/plugin/vectormap/jquery-jvectormap-1.2.2.min.js", function(){
            loadScript("<?php echo ASSETS_URL ?>/js/plugin/vectormap/jquery-jvectormap-world-mill-en.js", renderVectorMap)
        });

        function renderVectorMap() {
            $('#vector-map').vectorMap({
                map: 'world_mill_en',
                backgroundColor: '#fff',
                regionStyle: {
                    initial: {
                        fill: '#c4c4c4'
                    },
                    hover: {
                        "fill-opacity": 1
                    }
                },
                series: {
                    regions: [{
                        values: data_array,
                        scale: ['#60c5ed', '#0f232b'],
                        normalizeFunction: 'polynomial'
                    }]
                },
                onRegionLabelShow: function (e, el, code) {
                    if (typeof data_array[code] == 'undefined') {
                        e.preventDefault();
                    } else {
                        var countrylbl = data_array[code];
                        el.html(el.html() + '(Population: ' + countrylbl + ')');
                    }
                }
            });
        };



       /* google.load("visualization", "1", {packages: ["geoChart"]});

        google.setOnLoadCallback(function () {
            drawMap();
        });

        function drawMap() {

            var data = google.visualization.arrayToDataTable(json_encode($countryChart) !!});

            var options = {};

            var chart = new google.visualization.GeoChart(document.getElementById('countries'));

            chart.draw(data, options);

            google.visualization.events.addListener(chart, 'select', CountryPicked);

            function CountryPicked() {
//                alert('The user selected' + chart.getSelection().length + ' items.');
                console.log(123)
            }
        }*/
    };

    pagefunction();

    var pagedestroy = function(){
        // destroy vector map objects
        $('#vector-map').find('*').addBack().off().remove();
    }

//    loadScript("https://www.google.com/jsapi", pagefunction);

</script>



