<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-lg-4" style="height: 800px; padding: 0">
                {{--Draw Chart Form--}}
                <div class="col-md-12 home_boxes" style="margin: 0">
                    @include('country/layouts/show-form', ['editMode' => true])
                </div>

                {{--Saved Queries--}}
                <div class="col-md-12 home_boxes" style="margin: 0">
                    @include('country/layouts/saved-queries')
                </div>
            </div>

            {{--Charts--}}
            <article class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                {{--Charts--}}
                @foreach($charts as $j => $chart)
                    @include("template.canvas", [ "col" => 12, "id" => $j, "chartId" => $chart['div_id'], "title" => $chart['title'] ])
                @endforeach
            </article>

        </article>

    </div>

</section>





<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        $(function () {
            $('a[title]').tooltip();
        });

        var lineOptions = GetChartJsLineOptions();

        var ctx, myNewChart, chartData;
        // Chart PAX/REVENUE
        @foreach($charts as $chart)
            chartData = {
            labels: {!! json_encode($chart["data"]["date"]) !!},
            datasets: [
                {
                    label: "PAX (Outbound)",
                    backgroundColor: "rgba(50, 147, 50, 0.5)",
                    hoverBackgroundColor: "rgba(50, 147, 50, 0.8)",
                    borderColor: "rgba(50, 147, 50, 1)",
                    pointBackgroundColor: "rgba(50, 147, 50, 0.8)",
                    pointBorderColor: "#fff",
                    pointHoverBackgroundColor: "#fff",
                    pointHoverBorderColor: "rgba(50, 147, 50, 1)",
                    borderWidth: 2,
                    pointBorderWidth: 1,
                    pointRadius: 3,
                    data: {!! json_encode($chart["data"]["value"]) !!}
                }
            ]
        };

        ctx = document.getElementById("{{ $chart['div_id'] }}").getContext("2d");
        myNewChart = new Chart(ctx, {
            type: 'line',
            data: chartData,
            options: lineOptions
        });
        @endforeach
    };

    loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", function () {
        loadScript("{{ asset("/assets/js/views/country/chart.js") }}", pagefunction);
    });

</script>






