
{{--@section('content')--}}

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

           <div>

                <div class="col-md-12" style="margin-bottom: 15px">

                    {!! Form::open(['method' => 'GET', 'url' => url('commercial/indicators'), 'class' => 'form-inline']) !!}

                        <div class="form-group marginBottomRight">
                            <label>@lang("content.flight_number")</label>
                            <div class="btn-group">
                                @if (is_array($flightNumbers))
                                    {!! Form::select('flight_number[]', $flightNumbers, \request("flightNumber"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'flight_number']) !!}
                                @else
                                    <select name="flightNumber[]" class="multiselect_search" id="flight_number" multiple>
                                        @foreach($flightNumbers as $each)
                                            <option value="{{ $each->id }}" {!! \request("flightNumber") && in_array($each->id, \request("flightNumber")) ? "selected" : "" !!} data-airline_id ="{{ $each->airline_id }}">{{ $each->sector }}</option>
                                        @endforeach
                                    </select>
                                @endif
                            </div>
                        </div>


                        <div class="form-group marginBottomRight">
                            <label class="control-label" for="from">@lang("content.from")</label>
                            {!! Form::input('text', 'departure_from', \request("departure_from") ? \request("departure_from") : date("Y-m-d", strtotime("-1 days")), ['class'=>'form-control date']) !!}
                        </div>

                        <div class="form-group marginBottomRight">
                            <label class="control-label" for="to">@lang("content.to")</label>
                            {!! Form::input('text', 'departure_to', \request("departure_to") ? \request("departure_to") :date("Y-m-d", strtotime("-1 days")), ['class'=>'form-control date']) !!}
                        </div>

                        <div class="form-groupmarginBottomRight">
                            {!! Form::submit("Submit", ['name' => "submit", 'class' => "btn btn-primary"]) !!}
                        </div>
                    {!! Form::close() !!}

                </div>

                <div class="col-md-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                        <!-- widget options:
                        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                        data-widget-colorbutton="false"
                        data-widget-editbutton="false"
                        data-widget-togglebutton="false"
                        data-widget-deletebutton="false"
                        data-widget-fullscreenbutton="false"
                        data-widget-custombutton="false"
                        data-widget-collapsed="true"
                        data-widget-sortable="false"

                        -->
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                            <h2>@lang("content.list") </h2>

                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget edit box -->
                            <div class="jarviswidget-editbox">
                                <!-- This area used as dropdown edit box -->

                            </div>
                            <!-- end widget edit box -->

                            <!-- widget content -->
                            <div class="widget-body no-padding _overflow">

                                <table class="table table-bordered table-striped table-hover">
                                    <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>@lang("content.departure_date")</th>
                                        <th>@lang("content.capacity")</th>
                                        <th>@lang("content.revenue"), USD</th>
                                        <th>PAX</th>
                                        <th>@lang("content.yield"), USD</th>
                                        <th>ASK</th>
                                        <th>RPK</th>
                                        <th>RASK</th>
                                        <th>@lang("content.load_factor"), %</th>
                                        <th>@lang("content.yield")/km</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @php $j = 0 @endphp
                                    @foreach($data as $i => $each)
                                        @if (!(isset($each['indicators']) && $each['indicators']))
                                            @continue
                                        @endif

                                        <tr>
                                            <td>{{ ++$j }}</td>
                                            <td>{{ baseDateFormat($i) }}</td>
                                            <td>{{ number_format($each['indicators']['capacity']) }}</td>
                                            <td>{{ number_format($each['indicators']['revenue']) }}</td>
                                            <td>{{ number_format($each['indicators']['pax']) }}</td>
                                            <td>{{ number_format($each['indicators']['yield']) }}</td>
                                            <td>{{ number_format($each['indicators']['ask']) }}</td>
                                            <td>{{ number_format($each['indicators']['rpk']) }}</td>
                                            <td>{{ $each['indicators']['rask'] }}</td>
                                            <td>{{ $each['indicators']['loadFactor'] }}</td>
                                            <td>{{ $each['indicators']['yieldKm'] }}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>

                            </div>

                        </div>
                    </div>
                </div>

                <div class="col-sm-12 col-md-6">
                    <div class="graph">
                        <div id="legend1" class="legend"></div>
                        <div id="chart1" class="padding-10" style="height: 350px;"></div>
                    </div>
                </div>

                <div class="col-sm-12 col-md-6">
                    <div class="graph">
                        <div id="legend2" class="legend"></div>
                        <div id="chart2" class="padding-10" style="height: 350px;"></div>
                    </div>
                </div>

            </div>

        </article>

    </div>

</section>


<link rel="stylesheet" href="{{ asset("/assets/css/morris.css") }}"/>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();


        @if ( isset($charts['ask-rpk']) && count($charts['ask-rpk']))
            Morris_Graph('Line',{!! $charts['ask-rpk']['data'] !!}, {!! $charts['ask-rpk']['label'] !!},'{!! $charts['ask-rpk']['x'] !!}',{!! $charts['ask-rpk']['y'] !!},'ASK/RPK', 'chart1', '#legend1', '');
        @endif
        @if (isset($charts['cap-pax-yield']) && count($charts['cap-pax-yield']))
            Morris_Graph('Bar', {!! $charts['cap-pax-yield']['data'] !!}, {!! $charts['cap-pax-yield']['label'] !!},'{!! $charts['cap-pax-yield']['x'] !!}',{!! $charts['cap-pax-yield']['y'] !!},'CAP/PAX/Yield', 'chart2', '#legend2');
        @endif

        ApplyTableFilter(".table");

    };

    loadScript("{{ asset("/assets/js/vendor/raphael-min.js") }}", function () {
        loadScript("{{ asset("/assets/js/vendor/morris.min.js") }}", function () {
            loadScript("{{ asset("/assets/js/vendor/morris_graph.js") }}", pagefunction);
        });
    });

</script>

{{--@endsection--}}

{{-- JS scripts section --}}


