<?php
/**
 * Created by PhpStorm.

 */
?>


<div class="col-md-12" >
    @if ($report == $selected_report && count($tableData))

        <div class="col-md-12" style="width: 100%; overflow: auto;">
            <table class="table table-bordered table-striped table-hover">
                <thead>
                <tr>
                    <th rowspan="3">No.</th>
                    <th rowspan="3" style="min-width: 250px">{{ isset($report_name) ? $report_name : "Queried Results" }}</th>
                    <th colspan="{{ 3 * ( count($unique_periods) + 1) }}">Period | Flight Number | Sector</th>
                </tr>
                <tr>
                    <th colspan="3" style="background-color: #00aa15 !important;">@lang("content.total")</th>
                    @foreach($unique_periods as $each)
                        <th colspan="3">{{ $each }}</th>
                    @endforeach
                </tr>
                <tr>
                    <th style="background-color: #00aa15 !important;">PAX</th>
                    <th style="background-color: #00aa15 !important;">@lang("content.revenue")</th>
                    <th style="background-color: #00aa15 !important;">@lang("content.yield")</th>
                    @for($j = 0; $j < count($unique_periods); $j++)
                        <th>PAX</th>
                        <th>@lang("content.revenue")</th>
                        <th>@lang("content.yield")</th>
                    @endfor
                </tr>
                </thead>
                <tbody>

                <tr class="total_row">
                    <td></td>
                    <td>TOTAL:</td>
                    {{--Grand Total Figures--}}
                    <td>{{ number_format($grand_total_pax) }}</td>
                    <td>{{ number_format($grand_total_revenue) }}</td>
                    <td>{{ number_format($grand_total_yield) }}</td>

                    @foreach($unique_periods as $period)
                        @php $pax = isset($tableData['pax'][$period]) ? $tableData['pax'][$period] : 0 @endphp
                        @php $revenue = isset($tableData['revenue'][$period]) ? $tableData['revenue'][$period] : 0 @endphp
                        @php $yield = $pax ? $revenue / $pax : 0 @endphp

                        {{--Total Period Figures--}}
                        <td>{{ number_format($pax) }}</td>
                        <td>{{ number_format($revenue) }}</td>
                        <td>{{ number_format($yield) }}</td>
                    @endforeach
                </tr>


                @php $period_total_pax = [] @endphp
                @php $period_total_revenue = [] @endphp

                @foreach($unique_pos as $i => $pos)
                    @php $country = isset($tableData[$pos]['country']) ? $tableData[$pos]['country'] : false @endphp
                    @php $country_id = isset($tableData[$pos]['country_id']) ? $tableData[$pos]['country_id'] : "" @endphp
                    @php $agency_id = isset($tableData[$pos]['agency_id']) ? $tableData[$pos]['agency_id'] : "" @endphp
                    @php $city = isset($tableData[$pos]['city']) ? ", ".$tableData[$pos]['city'] : "" @endphp

                    @php $total_pax = isset($tableData[$pos]['pax']['total']) ? $tableData[$pos]['pax']['total'] : 0 @endphp
                    @php $total_revenue = isset($tableData[$pos]['revenue']['total']) ? $tableData[$pos]['revenue']['total'] : 0 @endphp
                    @php $total_yield = $total_pax ? $total_revenue / $total_pax : 0 @endphp
                    @php $boundClass = isset($tableData[$pos]['bound']) ? ($tableData[$pos]['bound']  ? "inbound_row" : "outbound_row") : "" @endphp

                    <tr>
                        <td>{{ $i + 1 }}</td>
                        <td class="{{ $boundClass }}" data-left style="padding: 0 4px; vertical-align: middle">
                            @if ($country)
                                <a target="_blank" href='{{ url("country/{$country_id}") }}'>
                                    <img style="" src="{{ asset("/assets/img/icons/flags/24/{$country}.png") }}" />
                                </a>
                            @endif
                            @if ($agency_id)
                                <a target="_blank" href='{{ url("agency")."/".$agency_id }}'>{{ $pos }}</a>
                            @else
                                {{ $pos }}
                            @endif
                            {{ $city }}
                        </td>

                        {{--Total By POS--}}
                        <td>{{ number_format($total_pax) }}</td>
                        <td>{{ number_format($total_revenue) }}</td>
                        <td>{{ number_format($total_yield) }}</td>

                        @foreach($unique_periods as $period)
                            @if (isset($tableData[$pos]['pax'][$period]) || isset($tableData[$pos]['revenue'][$period]))
                                @php $pax = isset($tableData[$pos]['pax'][$period]) ? $tableData[$pos]['pax'][$period] : 0 @endphp
                                @php $revenue = isset($tableData[$pos]['revenue'][$period]) ? $tableData[$pos]['revenue'][$period] : 0 @endphp
                                @php $yield = $pax ? $revenue / $pax : 0 @endphp

                                <td>{{ number_format($pax) }}</td>
                                <td>{{ number_format($revenue) }}</td>
                                <td>{{ is_numeric($yield) ? number_format($yield) : $yield }}</td>
                            @else
                                <td>0</td>
                                <td>0</td>
                                <td>0</td>
                            @endif
                        @endforeach
                    </tr>
                @endforeach

                </tbody>
            </table>
        </div>


        @if (isset($boundLegend) && $boundLegend)
            <div class="col-sm-12" style="margin: 20px 0">
                <span class="color_item"><span class="flight_color total_row"></span> - @lang("content.total")</span>
                <span class="color_item"><span class="flight_color route_row"></span> - Route</span>
                <span class="color_item"><span class="flight_color outbound_row"></span> - Outbound</span>
                <span class="color_item"><span class="flight_color inbound_row"></span> - Inbound</span>
            </div>
        @endif

        <div class="col-lg-12" style="padding: 0; margin: 20px 0">
            <div class="col-xs-12 c3chart title" style="margin: 0; border: 1px solid #0083B4">
                <h4 class="text-center">PAX</h4>
            </div>
            <div class="col-md-6 c3chart" style="margin: 0; border: 1px solid #0083B4">
                <div id="donut_chart_pax"></div>
            </div>
            <div class="col-md-6 c3chart" style="margin: 0; border: 1px solid #0083B4; border-left: 0">
                <div id="bar_chart_pax"></div>
            </div>

            <div class="col-xs-12 c3chart title" style="margin: 10px 0 0 0; border: 1px solid #0083B4">
                <h4 class="text-center">@lang("content.revenue")</h4>
            </div>
            <div class="col-md-6 c3chart" style="margin: 0; border: 1px solid #0083B4">
                <div id="donut_chart_revenue"></div>
            </div>
            <div class="col-md-6 c3chart" style="margin: 0; border: 1px solid #0083B4; border-left: 0">
                <div id="bar_chart_revenue"></div>
            </div>
        </div>

    @endif


</div>
