<?php
/**
 * Created by PhpStorm.

 */
?>


<div class="col-md-12" style="width: 100%; min-height: 400px; overflow: auto;">
    @if ($report == $selected_report && count($tableData))

        <div class="col-md-12" style="width: 100%; min-height: 400px; overflow: auto;">
            <table class="table table-bordered table-striped table-hover">
                <thead>
                <tr>
                    <th rowspan="3">No.</th>
                    <th rowspan="3" style="min-width: 250px">{{ isset($report_name) ? $report_name : "Queried Results" }}</th>
                    <th colspan="{{ 3 * ( count($unique_periods) + 1) }}">Period | Flight Number | Sector</th>
                </tr>
                <tr>
                    <th colspan="3" style="background-color: #00aa15 !important;">@lang("content.total")</th>
                    @foreach($unique_periods as $each)
                        <th colspan="3">{{ $each }}</th>
                    @endforeach
                </tr>
                <tr>
                    <th style="background-color: #00aa15 !important;">PAX</th>
                    <th style="background-color: #00aa15 !important;">@lang("content.revenue")</th>
                    <th style="background-color: #00aa15 !important;">@lang("content.yield")</th>
                    @for($j = 0; $j < count($unique_periods); $j++)
                        <th>PAX</th>
                        <th>@lang("content.revenue")</th>
                        <th>@lang("content.yield")</th>
                    @endfor
                </tr>
                </thead>
                <tbody>

                <tr class="total_row">
                    <td></td>
                    <td>TOTAL:</td>
                    {{--Grand Total Figures--}}
                    <td>{{ number_format($grand_total_pax) }}</td>
                    <td>{{ number_format($grand_total_revenue) }}</td>
                    <td>{{ number_format($grand_total_yield) }}</td>

                    @foreach($unique_periods as $period)
                        @php $pax = isset($tableData['pax'][$period]) ? $tableData['pax'][$period] : 0 @endphp
                        @php $revenue = isset($tableData['revenue'][$period]) ? $tableData['revenue'][$period] : 0 @endphp
                        @php $yield = $pax ? $revenue / $pax : 0 @endphp

                        {{--Total Period Figures--}}
                        <td>{{ number_format($pax) }}</td>
                        <td>{{ number_format($revenue) }}</td>
                        <td>{{ number_format($yield) }}</td>
                    @endforeach
                </tr>


                @php $period_total_pax = [] @endphp
                @php $period_total_revenue = [] @endphp

                @foreach($unique_route as $i => $route)
                    @php $total_pax = isset($tableData[$route]['pax']['total']) ? $tableData[$route]['pax']['total'] : 0 @endphp
                    @php $total_revenue = isset($tableData[$route]['revenue']['total']) ? $tableData[$route]['revenue']['total'] : 0 @endphp
                    @php $total_yield = $total_pax ? $total_revenue / $total_pax : 0 @endphp

                    <tr class="route_row">
                        <td>{{ $i + 1 }}</td>
                        <td data-left style="padding: 0 4px; vertical-align: middle">{{ $route }}</td>

                        {{--Total By POS--}}
                        <td>{{ number_format($total_pax) }}</td>
                        <td>{{ number_format($total_revenue) }}</td>
                        <td>{{ number_format($total_yield) }}</td>

                        @foreach($unique_periods as $period)
                            @if (isset($tableData[$route]['pax'][$period]) || isset($tableData[$route]['revenue'][$period]))
                                @php $pax = isset($tableData[$route]['pax'][$period]) ? $tableData[$route]['pax'][$period] : 0 @endphp
                                @php $revenue = isset($tableData[$route]['revenue'][$period]) ? $tableData[$route]['revenue'][$period] : 0 @endphp
                                @php $yield = $pax ? $revenue / $pax : 0 @endphp

                                <td>{{ number_format($pax) }}</td>
                                <td>{{ number_format($revenue) }}</td>
                                <td>{{ is_numeric($yield) ? number_format($yield) : $yield }}</td>
                            @else
                                <td>0</td>
                                <td>0</td>
                                <td>0</td>
                            @endif
                        @endforeach
                    </tr>

                    {{--By Sector --}}
                    @php $sectorCount = 0 @endphp
                    @foreach($tableData[$route] as $sector => $sectorData)
                        @if (!in_array($sector, ["pax", "revenue"]))
                            @php $sectorCount++ @endphp

                            @php $sector_pax = isset($sectorData['pax']['total']) ? $sectorData['pax']['total'] : 0 @endphp
                            @php $sector_revenue = isset($sectorData['revenue']['total']) ? $sectorData['revenue']['total'] : 0 @endphp
                            @php $sector_yield = $sector_pax ? $sector_revenue / $sector_pax : 0 @endphp

                            <tr>
                                <td></td>
                                <td class="{{ $sectorData['bound'] ? "inbound_row" : "outbound_row" }}" data-left style="padding: 0 4px; vertical-align: middle">{{ $sectorCount. ") ".$sector }}</td>

                                {{--Total By POS--}}
                                <td>{{ number_format($sector_pax) }}</td>
                                <td>{{ number_format($sector_revenue) }}</td>
                                <td>{{ number_format($sector_yield) }}</td>

                                @foreach($unique_periods as $period)
                                    @if (isset($tableData[$route]['pax'][$period]) || isset($tableData[$route]['revenue'][$period]))
                                        @php $pax = isset($sectorData['pax'][$period]) ? $sectorData['pax'][$period] : 0 @endphp
                                        @php $revenue = isset($sectorData['revenue'][$period]) ? $sectorData['revenue'][$period] : 0 @endphp
                                        @php $yield = $pax ? $revenue / $pax : 0 @endphp

                                        <td>{{ number_format($pax) }}</td>
                                        <td>{{ number_format($revenue) }}</td>
                                        <td>{{ is_numeric($yield) ? number_format($yield) : $yield }}</td>
                                    @else
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                    @endif
                                @endforeach
                            </tr>
                        @endif
                    @endforeach
                @endforeach

                </tbody>
            </table>
        </div>

        <div class="col-sm-12" style="margin: 20px 0">
            <span class="color_item"><span class="flight_color total_row"></span> - @lang("content.total")</span>
            <span class="color_item"><span class="flight_color route_row"></span> - Route</span>
            <span class="color_item"><span class="flight_color outbound_row"></span> - Outbound</span>
            <span class="color_item"><span class="flight_color inbound_row"></span> - Inbound</span>
        </div>

        <div class="col-lg-12" style="padding: 0; margin: 20px 0">
            <div class="col-xs-12 c3chart title" style="margin: 0; border: 1px solid #0083B4">
                <h4 class="text-center">PAX</h4>
            </div>
            <div class="col-md-6 c3chart" style="margin: 0; border: 1px solid #0083B4">
                <div id="donut_chart_pax"></div>
            </div>
            <div class="col-md-6 c3chart" style="margin: 0; border: 1px solid #0083B4; border-left: 0">
                <div id="bar_chart_pax"></div>
            </div>

            <div class="col-xs-12 c3chart title" style="margin: 10px 0 0 0; border: 1px solid #0083B4">
                <h4 class="text-center">@lang("content.revenue")</h4>
            </div>
            <div class="col-md-6 c3chart" style="margin: 0; border: 1px solid #0083B4">
                <div id="donut_chart_revenue"></div>
            </div>
            <div class="col-md-6 c3chart" style="margin: 0; border: 1px solid #0083B4; border-left: 0">
                <div id="bar_chart_revenue"></div>
            </div>
        </div>

    @endif


</div>
