@extends("layout")


@section("content")

    @include('general.tab-header', ['departmentName' => 'Check In', 'moduleName' => 'Users'])

    <div class="col-lg-12" style="background-color: #ffffff; padding: 20px; margin-bottom: 20px">

        <div class="col-sm-4" style=" height: 100%; padding: 20px;">

            <div style="width: 100%; margin: 0 10px 0 0; display: inline-block; ">
                <!-- Current avatar -->

                <div class="col-sm-6">
                    <img src="{{ $picture }}" style=" border: 1px solid #FF7E00; ">
                </div>
            </div>
            <div>
                <div class="col-sm-12" style="padding: 0">
                    <div class="col-xs-12">
                        <div class="col-xs-5"><h4>@lang("content.first_name")</h4></div>
                        <div class="col-xs-7"><h4 id="first_name">{{ $user ? $user->first_name : "" }}</h4></div>
                    </div>

                    <div class="col-xs-12">
                        <div class="col-xs-5"><h4>@lang("content.last_name")</h4></div>
                        <div class="col-xs-7"><h4 id="last_name">{{ $user ? $user->last_name : "" }}</h4></div>
                    </div>
                </div>
            </div>
        </div>


        <div class="col-sm-8" style="border: 1px solid #2486B7; background-color: #2486B7; color: #ffffff; height: 100%; padding: 20px">
            <h2>User Log-in</h2>
            {!! Form::open(['method' => 'POST', 'url' => 'check-in']) !!}
            <div class="col-sm-12" style="margin: 30px 0">
                <h3 class="col-md-4">E-Mail Address</h3>

                <div class="col-md-8">
                    <input type="email" class="form-control check-in-inputs" name="email" id="email" value="{!! old('email') !!}">
                </div>
            </div>

            <div class="col-sm-12">

                <h3 class="col-md-4">Password</h3>

                <div class="col-md-8">
                    <input type="password" class="form-control check-in-inputs" name="password" id="password">
                </div>
            </div>

            <div class="col-sm-12" style="margin: 30px 0">
                <input id="submit" type="submit" class="btn btn-success" value="Submit"/>
            </div>

            {!! Form::close() !!}
        </div>
    </div>

    <div style="clear: both; float: none;">
        <ul class="nav nav-tabs" id="myTab">
            <div class="liner"></div>
            <li class="active">
                <a href="#messages" data-toggle="tab" title="welcome">
                    <i class="glyphicon glyphicon-home"></i>
                    <span class="tabText">Messages</span>
                </a>
            </li>

            <li>
                <a href="#flights" data-toggle="tab" title="welcome" class="not-active">
                    <i class="glyphicon glyphicon-tasks"></i>
                    <span class="tabText">Flights</span>
                </a>
            </li>

        </ul>
        <div class="tab-content" style="background-color: #ffffff; height: 100px">
            <div class="tab-pane active" id="messages">
                <div class="alert alert-info">No Messages Found</div>
            </div>

            <div class="tab-pane" id="flights">
            </div>
        </div>
    </div>
@stop

@section("js_scripts")

    <script>

    </script>

@stop