@extends('chat.layouts.app')

@section("css")
@endsection

@section('content')
<section id="widget-grid" class="">
    <div class="container">
        <div class="row">
            <div class="col-sm-12">

                <div style="float: left; width: 500px; padding: 0; height: 670px; overflow: auto;">

                    {{--<button data-toggle="modal" data-target="#picture_notes"></button>--}}
                    {{--<button id="notify">Notify me!</button>--}}

                    <div class="">
                        {!! Form::open(['class' => 'form-inline', 'method' => 'GET', 'id' => 'formOPS', 'url' => url("flight-com")]) !!}
                        <div class="form-group">
                            <label>@lang("content.date")</label>
                            {!! Form::text('date', !\request("date") ? $dateToday : \request("date"), ['class'=>'form-control dateFrom myinput', 'style' => 'width: 120px;', 'placeholder'=>'Date', 'id'=>'date']) !!}

                        </div>
                        <div class="btn-group">
                            <button name="submit" value="1" type="submit" class="btn btn-primary">@lang("content.submit")</button>
                            <a href="{{ url("flight-com") }}" class="btn btn-danger">@lang("content.today")</a>
                            {!! Form::hidden("flight_id", null, ["id" => "refresh_flight_id"]) !!}
                            <button name="refresh" value="1" type="submit" class="btn btn-warning">@lang("content.refresh")</button>
                        </div>
                        {!! Form::close() !!}
                    </div>

                    <ul id="tabFlights" class="nav nav-tabs bordered" style="margin-top: 15px;">
                        <li>
                            <a href="#tabFltArrivals" role="tab" data-toggle="tab">@lang("content.arrivals")</a>
                        </li>
                        <li class="active">
                            <a href="#tabFltDepartures" role="tab" data-toggle="tab">@lang("content.departures")</a>
                        </li>
                        <li class="">
                            <a href="#tabFltAll" role="tab" data-toggle="tab">@lang("content.all")</a>
                        </li>
                        <li class="" style="float: right;">
                            <a target="_blank" style="background: #ffe0e0" href="{{ url("flight-watch") }}">
                                @lang("modules.flight_watch")
                            </a>
                        </li>
                    </ul>

                    <div id="" class="tab-content padding-10 background-white">

                        <div class="tab-pane" id="tabFltArrivals">
                            <flight-coms :initial-flights="{{ json_encode($flightsData[ARRIVAL]) }}" :type="{{ ARRIVAL }}"  :user="{{ $user }}"></flight-coms>
                            {{--@include("chat.layouts.flights-table", ["data" => $flightsData[ARRIVAL], "fltType" => ARRIVAL])--}}
                        </div>
                        <div class="tab-pane active" id="tabFltDepartures">
                            <flight-coms :initial-flights="{{ json_encode($flightsData[DEPARTURE]) }}" :type="{{ DEPARTURE }}"  :user="{{ $user }}"></flight-coms>
{{--                            @include("chat.layouts.flights-table", ["data" => $flightsData[DEPARTURE], "fltType" => DEPARTURE])--}}
                        </div>
                        <div class="tab-pane" id="tabFltAll">
                            <flight-coms :initial-flights="{{ json_encode($flightsData[ALL]) }}" :type="{{ ALL }}"  :user="{{ $user }}"></flight-coms>
                            {{--@include("chat.layouts.flights-table", ["data" => $flightsData[ALL], "fltType" => ALL])--}}
                        </div>
                    </div>

                </div>

                <div style="float:right; width: calc(100% - 510px);height: 650px; ">
                    <flight-com-chat :initial-flights="{{ json_encode($flightsData[ALL]) }}"></flight-com-chat>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section("scripts")

    <script type="text/javascript">
        var baseUrl = "{{ url('/') }}";
    </script>

    <script src="{{ asset('js/app.js?31') }}"></script>

@endsection
