@extends("flight-com.layouts.layout")

@section("css")

    {{--<link href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.0/css/bootstrap.min.css" rel="stylesheet" id="bootstrap-css">--}}
    {{--<script src="//maxcdn.bootstrapcdn.com/bootstrap/3.3.0/js/bootstrap.min.js"></script>--}}
    {{--<script src="//code.jquery.com/jquery-1.11.1.min.js"></script>--}}
    <!------ Include the above in your HEAD tag ---------->

    <link href="{{ asset("assets/flight-com/css/m-main.css?53") }}" rel="stylesheet">

    <style>
        .dataTables_filter > label {
            width: 100%;
        }

        .dataTables_filter > label > input[type=search] {
            border-radius: 0;
            width: calc(100% - 64px);
            height: 64px;
            font-size: 32px;
        }

        .input-group-addon:first-child{
            float: left;
            height: 64px;
            width: 64px;
            margin: 0;
            padding-top: 18px;
        }

        .dataTables_length, .dt-buttons, .dataTables_paginate{
            display: none;
        }

        table.table tr.table-title > th{
            font-size: 28px;

        }
    </style>
@endsection

@section("content")

<section id="widget-grid" class="">

    @include("flight-com.layouts.picture-upload")

    <div class="col-sm-12" style="padding: 10px;">

        <div class="col-sm-12">

            <div style="display: inline-block; padding: 10px; width: 100%;">
                <div style="float: left;" class="form-div">
                    {!! Form::open(['class' => 'form-inline', 'method' => 'GET', 'id' => 'formOPS']) !!}
                    <div class="form-group">
                        <label>@lang("content.date")</label>
                        {!! Form::text('date', !\request("date") ? $dateToday : \request("date"), ['class'=>'form-control dateFrom myinput', 'placeholder'=>'Date', 'id'=>'date', 'style' => 'width: 200px;', ]) !!}

                    </div>
                    <div class="btn-group">
                        <button type="submit" class="btn btn-primary">@lang("content.submit")</button>
                        <a href="{{ url("flight-com") }}" class="btn btn-danger" style="font-size: 24px;">@lang("content.today")</a>
                        {!! Form::hidden("flight_id", null, ["id" => "refresh_flight_id"]) !!}
                        <button name="refresh" value="1" type="submit" class="btn btn-warning">@lang("content.refresh")</button>
                    </div>
                    {!! Form::close() !!}
                </div>

                <div style="float: right;">
                    <a data-toggle="collapse" id="show_hide_flights" class="btn btn-success" href="#flightsTab" role="button"
                       aria-expanded="false" aria-controls="flightsTab" style="font-size: 24px;">Show/Hide Flights</a>
                </div>
            </div>

            <div class="collapse in" id="flightsTab">

                <div class="col-sm-12" style="padding: 0; height: 100%; overflow: auto;">

                    <ul id="tabFlights" class="nav nav-tabs bordered dep-arr-tabs" style="margin-top: 5px;">
                        <li>
                            <a href="#tabFltArrivals" role="tab" data-toggle="tab">@lang("content.arrivals")</a>
                        </li>
                        <li class="active">
                            <a href="#tabFltDepartures" role="tab" data-toggle="tab">@lang("content.departures")</a>
                        </li>
                        <li class="">
                            <a href="#tabFltAll" role="tab" data-toggle="tab">@lang("content.all")</a>
                        </li>
                        <li class="" style="float: right;">
                            <a target="_blank" style="background: #ffe0e0" href="{{ url("flight-watch") }}">
                                @lang("modules.flight_watch")</a>
                        </li>
                    </ul>

                    <div id="" class="tab-content padding-10 background-white">

                        <div class="tab-pane" id="tabFltArrivals">
                            @include("flight-com.layouts.flights-table", ["data" => $flightsData[ARRIVAL], "isMobile"   => true, "fltType" => ARRIVAL])
                        </div>

                        <div class="tab-pane active" id="tabFltDepartures">
                            @include("flight-com.layouts.flights-table", ["data" => $flightsData[DEPARTURE], "isMobile"   => true, "fltType" => DEPARTURE])
                        </div>

                        <div class="tab-pane" id="tabFltAll">
                            @include("flight-com.layouts.flights-table", ["data" => $flightsData[ALL], "fltType" => ALL])
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="col-sm-12">

            <div class="top_menu" id="top_menu" data-flight_id="">
                {{--<div class="buttons">--}}
                {{--<div class="button close"></div>--}}
                {{--<div class="button minimize"></div>--}}
                {{--<div class="button maximize"></div>--}}
                {{--</div>--}}

                <div class="col-12">
                    <div>
                        <div style="display: inline-block; width: calc(100% - 155px);">
                            <span id="flight_title" class="title" style="">Please select a flight</span>
                            <span id="gate_info" class="gate-info"></span>
                            {{--<a class="module" target="_blank" href="{{ url("flight-watch") }}" style="margin-left: 10px;">@lang("modules.flight_watch")</a>--}}
                            <span id="flight_tracker" style="margin-left: 10px;"></span>
                            {{--<span id="flight_radar" style="margin-left: 10px;"></span>--}}

                            <div class="clearfix"></div>
                            <div>
                                <span id="flight_subtitle" class="sub-title"></span>
                            </div>
                        </div>

                        <div class="countdown-container" style="width: 145px;">
                            <div id="countdown_timer" class="countdown styled" style="display: none;"></div>
                        </div>


                        {{--<div style="float: right;">--}}
                        {{--<a id="show_flt_details_btn" style="display: none; font-size: 24px;" data-toggle="collapse" class="btn btn-success" href="#flightDetails" role="button" aria-expanded="false" aria-controls="flightDetails">Show Details</a>--}}
                        {{--</div>--}}
                    </div>
                </div>
            </div>

            <ul id="main-tabs" class="nav nav-tabs bordered" style="margin-top: 0;">
                <li class="active">
                    <a href="#tabChat" id="tabChatAnchor" role="tab" data-toggle="tab">CHAT</a>
                </li>
                <li class="">
                    <a id="trc_tab" href="#trc" role="tab" data-toggle="tab">TRC</a>
                </li>
                <li>
                    <a id="ckn_tab" href="#fltPaxTab" role="tab" data-toggle="tab">CKN</a>
                </li>
                <li>
                    <a id="pic_tab" href="#fltPictures" role="tab" data-toggle="tab">PIC</a>
                </li>
                <li class="">
                    <a id="mvt_tab" href="#mvt" role="tab" data-toggle="tab">MVT</a>
                </li>
                <li class="">
                    <a id="ldm_tab" href="#ldm" role="tab" data-toggle="tab">LDM</a>
                </li>
                <li class="">
                    <a id="lds_tab" href="#lds" role="tab" data-toggle="tab">LDS</a>
                </li>
                <li class="">
                    <a id="not_tab" href="#not" role="tab" data-toggle="tab">NOTOC</a>
                </li>
                <li class="">
                    <a id="cpm_tab" href="#cpm" role="tab" data-toggle="tab">CPM</a>
                </li>
                <li class="">
                    <a id="psm_tab" href="#psm" role="tab" data-toggle="tab">PSM</a>
                </li>
                <li class="">
                    <a id="ptm_tab" href="#ptm" role="tab" data-toggle="tab">PTM</a>
                </li>
                <li class="">
                    <a id="sod_tab" href="#sod" role="tab" data-toggle="tab">SOD</a>
                </li>
            </ul>

            <div id="" class="tab-content padding-10 background-white">

                <div class="tab-pane active" id="tabChat">
                    @include("flight-com.layouts.chat-tab-mobile")
                </div>

                <div class="tab-pane" id="trc">
                    @include("flight-com.layouts.trc-tab-mobile")
                </div>

                <div class="tab-pane" id="fltPaxTab">
                    @include("flight-com.layouts.ckn-tab-mobile")
                </div>

                <div class="tab-pane" id="fltPictures">
                    <div>
                        <div id="flt_pictures_container"></div>

                        <div class="clearfix"></div>
                    </div>
                </div>

                <div class="tab-pane" id="mvt" style="min-height: 300px">
                    @include("flight.mvt_arr_dep_tab", ["maxHeight" => "100%"])
                </div>

                <div class="tab-pane" id="ldm" style="min-height: 300px">
                    @include("flight.message_tab", ["type" => LDM, "maxHeight" => "100%"])
                </div>

                <div class="tab-pane" id="lds" style="min-height: 300px">
                    @include("flight.message_tab", ["type" => LDS, "maxHeight" => "100%"])
                </div>

                <div class="tab-pane" id="not" style="min-height: 300px">
                    @include("flight.message_tab", ["type" => NOT, "maxHeight" => "100%"])
                </div>

                <div class="tab-pane" id="cpm" style="min-height: 300px">
                    @include("flight.message_tab", ["type" => CPM, "maxHeight" => "100%"])
                </div>

                <div class="tab-pane" id="psm" style="min-height: 300px">
                    @include("flight.message_tab", ["type" => PSM, "maxHeight" => "100%"])
                </div>

                <div class="tab-pane" id="ptm" style="min-height: 300px">
                    @include("flight.message_tab", ["type" => PTM, "maxHeight" => "100%"])
                </div>
                <div class="tab-pane" id="sod" style="min-height: 300px">
                    @include("flight.staff_tab", ["maxHeight" => "100%"])
                </div>
            </div>

            <div class="message_template_no_more_messages">
                <li class="message">
                    <div class="col-sm-12 text-center">
                        <div class='label label-danger' style="font-size: 14px !important;">No more messages</div>
                    </div>
                </li>
            </div>

            <div class="message_template">
                <li class="message">
                    <div class="avatar"></div>
                    <div class="text_wrapper">
                        <div class="text"></div>
                    </div>
                </li>
            </div>

            <div class="message_template_same">
                <li class="message">
                    <div class="text_wrapper same_user">
                        <div class="text"></div>
                    </div>
                </li>
            </div>

            @include("template.modal-loading", ["text" => "Please wait. Messages are being loaded"])

        </div>
    </div>


</section>

@endsection

@section("js")
    <script src="{{ asset("/assets/js/jquery.countdown.min.js") }}"></script>
{{--    <script src="{{ asset("/assets/js/timer.jquery.min.js") }}"></script>--}}

    <script src="{{ asset("/smart/js/plugin/datatables-new/jquery.dataTables.min.js") }}"></script>
    <script src="{{ asset("/smart/js/plugin/datatables-new/buttons.html5.min.js") }}"></script>
    <script src="{{ asset("/smart/js/plugin/datatables-new/dataTables.buttons.min.js") }}"></script>
    <script src="{{ asset("/smart/js/plugin/datatables-new/buttons.bootstrap.min.js") }}"></script>
    {{--<script src="{{ asset("/smart/js/plugin/datatables-new/jszip.min.js") }}"></script>--}}
    {{--<script src="{{ asset("/smart/js/plugin/datatables-new/pdfmake.min.js") }}"></script>--}}
    {{--<script src="{{ asset("/smart/js/plugin/datatables-new/vfs_fonts.js") }}"></script>--}}
    <script src="{{ asset("/smart/js/plugin/datatables-new/buttons.print.min.js") }}"></script>
    <script src="{{ asset("/smart/js/plugin/datatables-new/buttons.colVis.min.js") }}"></script>
    <script src="{{ asset("/smart/js/plugin/datatables/dataTables.bootstrap.min.js") }}"></script>
    <script src="{{ asset("/assets/js/vendor/moment.min.js") }}"></script>
    <script src="{{ asset("/assets/js/aes.js") }}"></script>
    <script src="{{ asset("/assets/flight-com/js/push.min.js") }}"></script>
    <script src="{{ asset("/assets/flight-com/js/notify.min.js") }}"></script>
    <script src="{{ asset("/smart/js/helpers.js?2") }}"></script>
    <script src="{{ asset("/assets/flight-com/js/general.js") }}"></script>
    <script src="{{ asset("/assets/js/vendor/jquery.datetimepicker.js") }}"></script>


    <script type="text/javascript">

        var baseUrl = "{{ url('/') }}",
            baseHomeUrl = "{{ route("homepage")."#".url('/') }}",
            userID = {{ $user->id }},
            preK = "{{ PRE_KEY }}",
            postK = "{{ POST_KEY }}",
            isMobile = {{ $isMobile }},
            lastMessages = [],
            selectedFlightID = {{ $flight_id ? $flight_id : 0 }},
            airlineByFlight = {!! json_encode($airlineByFlight) !!},
            aircraftByAirline = {!! json_encode($aircraftByAirline) !!},
            keys = {!! json_encode($keysArray) !!},
            flightIDs = {!! json_encode($flightIDs) !!};

        ApplyTableFilter(".table");

    </script>

    <script src="{{ asset("/assets/flight-com/js/main.js?97") }}"></script>

@endsection