<!DOCTYPE html>
<html>
<head>
    @php $page_title = "Flight Comms" @endphp
    @php list($title, $ico) = getTitleAndIcon() @endphp

    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    {{--<meta name="viewport" content="width=device-width, initial-scale=1.0">--}}
    <title> <?php echo ($page_title != "" ? $page_title." - " : "").$title ; ?></title>
    <link rel="shortcut icon" href="<?php echo asset("/assets/img/icons/{$ico}") ?>" type="image/x-icon" />
    <link rel="icon" href="<?php echo asset("/assets/img/icons/{$ico}") ?>" type="image/x-icon" />

    <link href="{{ asset("/assets/css/bootstrap.min.css") }}" rel="stylesheet" />
    {{--<link href="{{ asset("/assets/chart/bootstrap/css/bootstrap.min.css") }}" rel="stylesheet" />--}}
    <link rel="stylesheet" href="{{ asset("/assets/css/theme.blue.css") }}"/>
    <link rel="stylesheet" href="{{ asset("/assets/css/jquery.datetimepicker.css") }}"/>
    <link rel="stylesheet" href="{{ asset("/assets/css/bootstrap-multiselect.css") }}"/>

{{--    <link href="{{ asset("/assets/css/main.css") }}?" rel="stylesheet /">--}}
    <link href="{{ asset('/assets/css/app.css') }}" rel="stylesheet" />

    <!-- Fonts -->
    <link href="{{ asset("/css/fonts.css") }}" rel="stylesheet" type='text/css' />

    <link href="{{ asset("/assets/css/prettify.css") }}" rel="stylesheet" />
    <link href="{{ asset("/assets/css/jquery-ui.min.css") }}" rel="stylesheet" />
    <link href="{{ asset("/assets/css/messenger.css") }}" rel="stylesheet" />

    {{--<link rel="stylesheet" href="{{ asset("/assets/flight-com/css/jquery.timepicker.min.css") }}" />--}}
    <link href="{{ asset("/assets/css/timepicki.css") }}" rel="stylesheet" />
    <link href="{{ asset("/assets/css/timepicki-style.css") }}" rel="stylesheet" />

    <link rel="stylesheet" type="text/css" media="screen" href="{{ asset("smart/css/font-awesome.min.css") }}">
        {{--<link href="{{ asset("/assets/css/general.css") }}" rel="stylesheet" />--}}

        {{--<link href="{{ asset("/assets/css/countdown.css") }}" rel="stylesheet" />--}}

    @yield("css")

    <script>
        var baseUrl = "{{ url('/') }}";
        var CURRENT_IATA_CODE = "{{ $CURRENT_IATA_CODE }}";

        var authUserId = "", authUserName = "", authUserStatus = "";
        @if (isset($auth) && is_object($auth) && $auth->user())
            authUserId = "{{ $auth->user()->id }}";
            authUserName = "{{ $auth->user()->first_name." ".$auth->user()->last_name}}";
            authUserStatus = "{{ $auth->user()->chatStatus ? $auth->user()->chatStatus->status : STATUS_ONLINE }}";
        @endif

    </script>
</head>

@if (isset($auth) && is_object($auth) && $auth->user())
    {{--<body style="margin: 0 !important; background: none;" onload="chat.updateChat()">--}}
    <body style="margin: 0 !important; background: none;">
@else
    <body style="margin: 0 !important; background: none;">
@endif

    <div id="content" class="content">
        @yield("content")
    </div>

    @include("flight-com.layouts.footer")

    </body>



</html>