<!DOCTYPE html>
<html lang="{{ config('app.locale') }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    @php $page_title = "Flight Comms" @endphp
    @php list($title, $ico) = getTitleAndIcon() @endphp

    {{--<meta name="viewport" content="width=device-width, initial-scale=1.0">--}}
    <title> <?php echo ($page_title != "" ? $page_title." - " : "").$title ; ?></title>
    <link rel="shortcut icon" href="<?php echo asset("/assets/img/icons/{$ico}") ?>" type="image/x-icon" />
    <link rel="icon" href="<?php echo asset("/assets/img/icons/{$ico}") ?>" type="image/x-icon" />

    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    {{--<meta name="viewport" content="width=device-width, initial-scale=1.0">--}}
    <title> <?php echo ($page_title != "" ? $page_title." - " : "").$title ; ?></title>
    <link rel="shortcut icon" href="<?php echo asset("/assets/img/icons/{$ico}") ?>" type="image/x-icon" />
    <link rel="icon" href="<?php echo asset("/assets/img/icons/{$ico}") ?>" type="image/x-icon" />

    {{--<link href="{{ asset("/assets/css/bootstrap.min.css") }}" rel="stylesheet" />--}}
    {{--<link rel="stylesheet" href="{{ asset("/assets/css/theme.blue.css") }}"/>--}}
    <link rel="stylesheet" href="{{ asset("/assets/css/jquery.datetimepicker.css") }}"/>
    <link rel="stylesheet" href="{{ asset("/assets/css/bootstrap-multiselect.css") }}"/>

    <!-- Fonts -->
    <link href="{{ asset("/css/fonts.css") }}" rel="stylesheet" type='text/css' />

    <link href="{{ asset("/assets/css/prettify.css") }}" rel="stylesheet" />
    <link href="{{ asset("/assets/css/jquery-ui.min.css") }}" rel="stylesheet" />
    <link href="{{ asset("/assets/css/messenger.css") }}" rel="stylesheet" />

    <link href="{{ asset("/assets/css/timepicki.css") }}" rel="stylesheet" />
    <link href="{{ asset("/assets/css/timepicki-style.css") }}" rel="stylesheet" />

    <link rel="stylesheet" type="text/css" media="screen" href="{{ asset("smart/css/font-awesome.min.css") }}">
{{--    <link href="{{ asset("assets/flight-com/css/main.css?52") }}" rel="stylesheet">--}}

    <!-- Styles -->
    <link href="{{ asset('css/ready/app.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/chat/css/web.css?2') }}" rel="stylesheet">

    <link href="{{ asset("assets/flight-com/css/main.css?52") }}" rel="stylesheet">
    <link href="{{ asset("/css/general.css") }}" rel="stylesheet" />
</head>
<body style="margin-top: 0;">
<div id="app">
    <nav class="navbar navbar-default navbar-static-top">
        <div class="container">
            <div class="navbar-header">

                <!-- Collapsed Hamburger -->
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#app-navbar-collapse">
                    <span class="sr-only">Toggle Navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>

                <!-- Branding Image -->
                <a class="navbar-brand" href="{{ url('/') }}">
                    {{ config('app.name', 'Laravel') }}
                </a>
            </div>

            <div class="collapse navbar-collapse" id="app-navbar-collapse">
                <!-- Left Side Of Navbar -->
                <ul class="nav navbar-nav">
                    &nbsp;
                </ul>

                <!-- Right Side Of Navbar -->
                <ul class="nav navbar-nav navbar-right">
                    <!-- Authentication Links -->
                    @if (Auth::guest())
                        <li><a href="{{ route('login') }}">Login</a></li>
                        <li><a href="{{ route('register') }}">Register</a></li>
                    @else
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
                                {{ Auth::user()->last_name }} <span class="caret"></span>
                            </a>

                            <ul class="dropdown-menu" role="menu">
                                <li>
                                    <a href="{{ route('logout') }}"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                        Logout
                                    </a>

                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                        {{ csrf_field() }}
                                    </form>
                                </li>
                            </ul>
                        </li>
                    @endif
                </ul>
            </div>
        </div>
    </nav>

    @yield('content')
</div>

@yield("scripts")

</body>
</html>
