@extends($ajaxCall)

@section("content")

    @include('general.tab-header', ['departmentName' => 'Charts', 'moduleName' => 'Commercial'])

    <div class="col-lg-12">
        @include('chart/form')
    </div>

    <div class="ajax_info_container"></div>

    <div class="ajax_main_container">
        <div class="col-lg-6 home_boxes">
            <div class="widget widget-stats bg-black">
                <div class="stats-icon stats-icon-lg">
                    <img height="80%" src="{{ asset("/assets/img/icons/chart/{$chart->image}") }}"/>
                </div>
                <div class="stats-title">{{ strtoupper($chart->chart) }}</div>
                <div class="stats-list">
                    <div id="{{ $chart->constant }}" style="height: 350px"></div>
                </div>
            </div>
        </div>
    </div>
@stop

@section("js_scripts")
    @if (!$isAjaxCall)
        <script type="text/javascript" src="https://www.google.com/jsapi"></script>
        <script type="text/javascript">
            google.load("visualization", "1", {packages: ["corechart"]});
        </script>
    @endif

    <script type="text/javascript">
        @if (isset($chartData))
        var chart = {};
        chart.chart_type = "{{ $chart->chartType->constant }}";
        chart.data = {!! json_encode($chartData) !!};
        chart.options = getChartOptions("{{ strtoupper($chart->chart) }}", '100%', '100%', 'undefined', 'undefined', 20, 5, 'undefined', 'no_legend', 'undefined', '75%', 'none');
        @if ($isAjaxCall)
        drawGoogleChart(chart.data, chart.options, "{{ $chart->constant }}", chart.chart_type);
        @else
            google.setOnLoadCallback(function () {
                    drawGoogleChart(chart.data, chart.options, "{{ $chart->constant }}", chart.chart_type)
                });
        @endif
        @endif
    </script>
@stop