



<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Charts', 'moduleName' => 'Commercial'])

            <div class="col-lg-12">
                @include('chart/form')
            </div>

            @if (count($chartData))
                @foreach($chartData as $j => $each)
                    @php $dataCounter = count($each['data']) @endphp
                    @php $height = $dataCounter * 35 < 200 ? 200 : $dataCounter * 35 @endphp
                    @if ($dataCounter > 1)
                        @if ($each["div_id"] != CHART_REVENUE_BY_COUNTRY)
                            <div class="col-sm-12 col-md-6">
                                @include("template.canvas", [ "col" => 12, "id" => $j, "chartId" => $each['div_id'], "title" => strtoupper($each['title']) ])
                            </div>
                        @endif
                    @else
                        <div class="alert alert-warning">{{ strtoupper($each['title']) }}. No Data Found.</div>
                    @endif

                @endforeach
            @endif

            @if (count($countryChart))
                <div class="col-sm-12 col-md-6">
                    @include('home/homepage/revenue_by_country', ['chart' => $countryChart['data'], "col" => "12", "id" => "0-0", "title" => $countryChart['title'] ])
                </div>
            @endif

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#revenueTable");

        var charts = [], i;

        var barOptions = GetChartJsBarOptions();

        var ctx, myNewChart, chartData;

        var colors = [
            "211,139,155",
            "68,148,210",
            "51,127,105",
            "50, 147, 50",
        ];

        @foreach($chartData as $i => $each)
            @if (count($each['data']) > 1)
                @if (isset($each['div_id']) && $each['skip'] == 0 && count($each["data"][$each["keys"][0]]) > 0)
                    @php $type = $each['chart_type'] @endphp

                    var index = {{ $i % 4 }}

                    chartData = {
                        labels: {!! json_encode($each["data"][$each["keys"][0]]) !!},
                        datasets: [
                            {
                                label: "{{ $each["keys"][0] }}",
                                backgroundColor: "rgba(" + colors[index] +", 0.5)",
                                hoverBackgroundColor: "rgba(" + colors[index] +", 0.8)",
                                borderColor: "rgba(" + colors[index] +", 1)",
                                pointBackgroundColor: "rgba(" + colors[index] +", 0.8)",
                                pointBorderColor: "#fff",
                                pointHoverBackgroundColor: "#fff",
                                pointHoverBorderColor: "rgba(" + colors[index] +", 1)",
                                borderWidth: 2,
                                pointBorderWidth: 1,
                                pointRadius: 3,
                                data: {!! json_encode($each["data"][$each["keys"][1]]) !!}
                            }
                        ]
                    };

                    ctx = document.getElementById("{{ $each['div_id'] }}").getContext("2d");

                    @if ($type == CHART_PIE)
                        new Chart(ctx, { type: 'polarArea', data: chartData });
                    @elseif (($type == CHART_COLUMN))
                        new Chart(ctx, { type: 'bar', data: chartData, options: barOptions });
                    @else
                        new Chart(ctx, { type: 'horizontalBar', data: chartData, options: barOptions });
                    @endif

                @endif

            @endif

        @endforeach

        var data_array = {!! json_encode($chartArray) !!};

        loadScript("<?php echo ASSETS_URL ?>/js/plugin/vectormap/jquery-jvectormap-1.2.2.min.js", function(){
            loadScript("<?php echo ASSETS_URL ?>/js/plugin/vectormap/jquery-jvectormap-world-mill-en.js", renderVectorMap)
        });


        function renderVectorMap() {
            $('#revenue_by_country').vectorMap({
                map: 'world_mill_en',
                backgroundColor: '#fff',
                regionStyle: {
                    initial: {
                        fill: '#c4c4c4'
                    },
                    hover: {
                        "fill-opacity": 1
                    }
                },
                series: {
                    regions: [{
                        values: data_array,
                        scale: ['#60c5ed', '#0f232b'],
                        normalizeFunction: 'polynomial'
                    }]
                },
                onRegionLabelShow: function (e, el, code) {
                    if (typeof data_array[code] == 'undefined') {
                        e.preventDefault();
                    } else {
                        var countrylbl = data_array[code];
                        el.html(el.html() + '(Revenue: ' + countrylbl + ')');
                    }
                }
            });
        }
    };

    loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", pagefunction);

</script>





