@php $height = isset($height) ? $height : "150px" @endphp
@php $width = isset($width) ? $width : "auto" @endphp
@php $padding = isset($padding) ? $padding : "auto" @endphp
@php $class = isset($class) ? $class : "" @endphp
@php $headerClass = isset($headerClass) ? $headerClass : "" @endphp
@php $headerColor = isset($headerColor) ? $headerColor : "auto" @endphp
@php $bodyColor = isset($bodyColor) ? $bodyColor : "black" @endphp
<div id="chart_revenue_by_country" style="height: {{ $height }}; display: block; margin-bottom: 10px">
    @if ($chart && count($chart) > 0)
    <div class="col-md-12 widget_countries {{ $class }}" style="width: {{ $width }}; padding: {{ $padding }};">
        <table class="table table-bordered table-striped table-hover">
            <thead>
                <tr>
                    <th></th>
                    <th style="color: {{ $headerColor }};">{{ $chart[0]['country'] }}</th>
                    <th style="color: {{ $headerColor }};">{{ $chart[0]['revenue'] }}</th>
                    <th style="color: {{ $headerColor }};">{{ $chart[0]['pax'] }}</th>
                    <th style="color: {{ $headerColor }};">{{ $chart[0]['yield'] }}</th>
                    <th style="color: {{ $headerColor }};">{{ $chart[0]['share'] }}</th>
                </tr>
            </thead>
            <tbody>
            @foreach($chart as $i => $each)
                @if ($i == 0)
                    @continue
                @else
                    <tr>
                        <td style="color: {{ $bodyColor }};"><img src="{{ asset("/assets/img/icons/flags/24/{$each['country']}.png") }}" /></td>
                        <td style="color: {{ $bodyColor }};">{{ $each['abbr'] }}</td>
                        <td style="color: {{ $bodyColor }};">{{ number_format($each['revenue']) }}</td>
                        <td style="color: {{ $bodyColor }};">{{ $each['pax'] }}</td>
                        <td style="color: {{ $bodyColor }};">{{ number_format($each['yield']) }}</td>
                        <td style="color: {{ $bodyColor }};">{{ number_format($each['share'], 1) }}</td>
                    </tr>
                @endif
            @endforeach
            </tbody>
        </table>
    </div>
    @endif
</div>

