<div class="col-md-12 no-padding margin-bottom-10">
    <a href="{{ route("homepage")."#". url("airport/add?operated=1") }}"
       class="btn btn-primary">@lang("content.add_airport")</a>
</div>

<div class="clearfix"></div>

<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-online" data-widget-editbutton="false"
     data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover" id="{{ $tableID }}">

                    <thead>
                    <tr>
                        <th>No</th>
                        <th>@lang("content.name")</th>
                        <th>IATA</th>
                        <th>ICAO</th>
                        <th>@lang("content.city")</th>
                        <th>@lang("content.country")</th>
                        {{--<th>Elevation</th>--}}
                        {{--<th>Latitude</th>--}}
                        {{--<th>Longitude</th>--}}
                        <th>@lang("content.timezone")</th>
                        <th>@lang("content.operated")</th>
                        <th>@lang("content.email_forwarding")</th>
                        <th style="width: 250px;">@lang("content.actions")</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($airports as $i => $airport)
                        <tr>
                            <td>{{ $i + 1 }}</td>
                            <td>{{ $airport->name }}</td>
                            <td>{{ $airport->iata }}</td>
                            <td>{{ $airport->icao }}</td>
                            <td>{{ $airport->city ? $airport->city->city : "" }}</td>
                            <td>{{ $airport->country ? $airport->country->country : "" }}</td>
                            {{--<td>{{ $each->elevation }}</td>--}}
                            {{--<td>{{ $each->latitude }}</td>--}}
                            {{--<td>{{ $each->longitude }}</td>--}}
                            <td>UTC {{ getUTCOffset($airport->timezone) }}</td>
                            <td data-center>{!! $airport->operated ? "<i class='glyphicon glyphicon-ok color-green'></i>" : "<i class='glyphicon glyphicon-remove color-red'></i>" !!}</td>
                            <td data-center>{!! $airport->email_recipients && trim($airport->email_recipients) && !$airport->stop_emails ? "<i class='glyphicon glyphicon-ok color-green'></i>" : "<i class='glyphicon glyphicon-remove color-red'></i>" !!}</td>
                            <td>
                                <div class="btn-group">
                                    <a href="{{ route("homepage")."#". url("/airport/{$airport->id}/offline") }}"
                                       class="btn btn-danger">@lang("content.make_offline")</a>
                                    <a target="_blank"
                                       href="{{ route("homepage")."#". url("/airport-license/show?airport_id={$airport->id}") }}"
                                       class="btn btn-success">@lang("content.licenses_approvals")</a>
                                    <a target="_blank" href="{{ route("homepage")."#". url("/airport/{$airport->id}/edit") }}"
                                       class="btn btn-warning">@lang("content.edit")</a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>

            </div>

        </div>

    </div>

</div>
