
<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    @php $ap = airlineModule() ? "content.hub_airports" : "content.handling_airports" @endphp
                    <a href="#handling" role="tab" data-toggle="tab">{{ trans($ap) }}</a>
                </li>
                @if (airlineModule())
                    <li class="">
                        <a href="#online" role="tab" data-toggle="tab">@lang("content.online_airports")</a>
                    </li>
                @endif
                <li class="">
                    <a href="#staff" role="tab" data-toggle="tab">@lang("content.staff_locations")</a>
                </li>
            </ul>

            @php $active = 0 @endphp
            <div id="tabContent" class="tab-content padding-10 background-white">

                <div class="tab-pane active" id="handling">
                    @if (airlineModule())
                        @include("airport.layouts.index-airline-hub-tab", ["airports" => $handlingAirports, "tableID" => "tableHandling"])
                    @else
                        @include("airport.layouts.index-handling-tab", ["airports" => $handlingAirports, "tableID" => "tableHandling"])
                    @endif
                </div>

                @if (airlineModule())
                    <div class="tab-pane" id="online">
                        @include("airport.layouts.index-online-tab", ["airports" => $onlineAirports, "tableID" => "tableOnline"])
                    </div>
                @endif
                <div class="tab-pane" id="staff">
                    @include("airport.layouts.index-staff-locations-tab", ["tableID" => "tableStaff"])
                </div>
            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#tableHandling");
        ApplyTableFilter("#tableOnline");
    }

    pagefunction();

</script>