<?php require_once(public_path("smart/inc/init.php")); ?>

            <!-- widget grid -->
    <section id="widget-grid" class="">

        <!-- row -->
        <div class="row">

            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                {!! Form::open([ 'method' => 'POST', 'class' => '', 'url' => url("/airport/{$airport->id}?page={$currentPage}") ]) !!}
                <table class="table">
                    <thead>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.name")</td>
                            <td>{!! Form::text('name', $airport->name, ['class' => 'form-control']) !!}</td>
                            <td style="width: 25%"></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">IATA</td>
                            <td>{!! Form::text('iata', $airport->iata, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">ICAO</td>
                            <td>{!! Form::text('icao', $airport->icao, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.country")</td>
                            <td>{!! Form::select('country', $countries, $airport->country_id, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.city")</td>
                            <td>{!! Form::select('city', $cities, $airport->city_id, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.elevation")</td>
                            <td>{!! Form::text('elevation', $airport->elevation, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.latitude")</td>
                            <td>{!! Form::text('latitude', $airport->latitude, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.longitude")</td>
                            <td>{!! Form::text('longitude', $airport->longitude, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.timezone")</td>
                            <td>{!! Form::select('timezone', $timezones, $airport->timezone, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.operated")</td>
                            <td>{!! Form::checkbox('operated', 1, $airport->operated, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.flight_watch")</td>
                            <td>{!! Form::checkbox('flight_watch', 1, $airport->flight_watch, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center color-red">@lang("content.email_recipients")</td>
                            <td>
                                {!! Form::textarea('email_recipients', $airport->email_recipients, ['class' => 'form-control', 'rows' => 3]) !!}
                                <span class="color-red">* Separate emails recipients with ";"</span>
                            </td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.email_hub")</td>
                            <td>{!! Form::checkbox('email_hub', 1, $airport->email_hub, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.stop_email_forwarding")</td>
                            <td>{!! Form::checkbox('stop_emails', 1, $airport->stop_emails, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td colspan="3">{!! Form::submit("Submit", ['class' => 'btn btn-success btn-sm']) !!}</td>
                        </tr>
                    </tbody>
                </table>
                {!! Form::close() !!}

            </article>

        </div>

    </section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();
    }

    pagefunction();

</script>