 <?php require_once(public_path("smart/inc/init.php")); ?>

            <!-- widget grid -->
    <section id="widget-grid" class="">

        <!-- row -->
        <div class="row">

            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                {!! Form::open([ 'method' => 'POST', 'class' => '', 'url' => url("airport") ]) !!}
                <table class="table">
                    <thead>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="td_header vertical-center">Handling Airport</td>
                            <td>{!! Form::checkbox('handling_airport', 1, null, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">Flight Watch</td>
                            <td>{!! Form::checkbox('flight_watch', 1, null, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        @if (airlineModule())
                            <tr>
                                <td class="td_header vertical-center">Operated</td>
                                <td>{!! Form::checkbox('operated', 1, null, ['class' => 'form-control']) !!}</td>
                                <td></td>
                            </tr>
                        @endif
                        <tr>
                            <td class="td_header vertical-center">@lang("content.name")</td>
                            <td>{!! Form::text('name', null, ['class' => 'form-control']) !!}</td>
                            <td style="width: 25%"></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">IATA</td>
                            <td>{!! Form::text('iata', $iata, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">ICAO</td>
                            <td>{!! Form::text('icao', null, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.country")</td>
                            <td>{!! Form::select('country', $countries, null, ['class' => 'form-control', "id" => "country_id"]) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.city")</td>
                            <td>{!! Form::select('city', [], null, ['class' => 'form-control', "id" => "city_id"]) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">Elevation</td>
                            <td>{!! Form::text('elevation', null, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">Latitude</td>
                            <td>{!! Form::text('latitude', null, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">Longitude</td>
                            <td>{!! Form::text('longitude', null, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">Timezone</td>
                            <td>{!! Form::select('timezone', $timezones, null, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center color-red">@lang("content.email_recipients")</td>
                            <td>
                                {!! Form::textarea('email_recipients', null, ['class' => 'form-control', 'rows' => 3]) !!}
                                <span class="color-red">* Separate emails recipients with ";"</span>
                            </td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.email_hub")</td>
                            <td>
                                {!! Form::checkbox('email_hub', 1, null, ['class' => 'form-control']) !!}
                                <span class="color-red">* Separate emails with ";"</span>
                            </td>
                        </tr>
                        <tr>
                            <td class="td_header vertical-center">@lang("content.stop_email_forwarding")</td>
                            <td>{!! Form::checkbox('stop_emails', 1, null, ['class' => 'form-control']) !!}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td colspan="3">{!! Form::submit("Submit", ['class' => 'btn btn-success btn-sm']) !!}</td>
                        </tr>
                    </tbody>
                </table>
                {!! Form::close() !!}

            </article>

        </div>

    </section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        var citiesByCountry = {!! json_encode($citiesByCountry) !!}

        var city_id = $("#city_id");

        $(document).on("change", "#country_id", function () {
            var countryID = $(this).val();
            city_id.children().remove();

            if (typeof citiesByCountry[countryID] !== "undefined"){
                $.each(citiesByCountry[countryID], function (j, each) {
                    // $.each(array, function (j, each) {
                    city_id.append("<option value='" + each.id + "'>" + each.city + "</option>");
                    // });
                });
            }

        });
    }

    pagefunction();

</script>