<?php require_once(public_path("smart/inc/init.php")); ?>

@php $envAirline = env(AIRLINE) @endphp

        <!-- widget grid -->
<section id="widget-grid" class="bg-color-white">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <img src="{{ $picture }}" style="max-height: 80px; padding: 10px;" />

            <div class="col-md-12">

                <ul id="tabStations" class="nav nav-tabs bordered">
                    <li class="{{ !\request("current_tab") ? "active" : "" }}">
                        <a href="#general" role="tab" data-toggle="tab">@lang("content.general")</a>
                    </li>

                    <li class="{{ \request("current_tab") == "sla" ? "active" : "" }}">
                        <a href="#sla" role="tab" data-toggle="tab">SLA</a>
                    </li>

                    <li class="{{ \request("current_tab") == "flights" ? "active" : "" }}">
                        <a href="#flights" role="tab" data-toggle="tab">FHR</a>
                    </li>

                    <li class="{{ \request("current_tab") == "licenses" ? "active" : "" }}">
                        <a href="#licenses" role="tab" data-toggle="tab">@lang("content.licenses_approvals")</a>
                    </li>

                    <li class="{{ \request("current_tab") == "approved_staff" ? "active" : "" }}">
                        <a href="#approved_staff" role="tab" data-toggle="tab">@lang("content.approved_staff")</a>
                    </li>

                    <li class="{{ \request("current_tab") == "actypes" ? "active" : "" }}">
                        <a href="#actypes" role="tab" data-toggle="tab">@lang("content.subfleet")</a>
                    </li>

                    <li class="{{ \request("current_tab") == "ac" ? "active" : "" }}">
                        <a href="#ac" role="tab" data-toggle="tab">@lang("content.aircraft")</a>
                    </li>

                    <li class="{{ \request("current_tab") == "dl" ? "active" : "" }}">
                        <a href="#dl" role="tab" data-toggle="tab">@lang("content.delay_codes")</a>
                    </li>

                    <li class="{{ \request("current_tab") == "fltno" ? "active" : "" }}">
                        <a href="#fltno" role="tab" data-toggle="tab">@lang("content.flight_numbers")</a>
                    </li>

                    <li class="{{ \request("current_tab") == "sch" ? "active" : "" }}">
                        <a href="#sch" role="tab" data-toggle="tab">@lang("content.schedule")</a>
                    </li>

                    <li class="{{ \request("current_tab") == "lbr" ? "active" : "" }}">
                        <a href="#lbr" role="tab" data-toggle="tab">@lang("content.library")</a>
                    </li>

                    @if ($envAirline == CAA)
                        <li class="{{ \request("current_tab") == "flm" ? "active" : "" }}">
                            <a href="#flm" role="tab" data-toggle="tab">@lang("modules.fleet_management")</a>
                        </li>
                        <li class="{{ \request("current_tab") == "acm" ? "active" : "" }}">
                            <a href="#acm" role="tab" data-toggle="tab">@lang("modules.ac_maintenance")</a>
                        </li>
                    @endif

                </ul>

                <div id="tabContent" class="tab-content padding-10 background-white">

                    @php $currentAirlineId = $airline->id @endphp

                    <div class="tab-pane {{ !\request("current_tab") ? "active" : "" }}" id="general" style="min-height: 300px;">
                        @include("airline.layouts.show-general-tab")
                    </div>

                    <div class="tab-pane {{ \request("current_tab") == "sla" ? "active" : "" }}" id="sla" style="min-height: 300px;">
                        @include("airline-service.sla-tab")
                    </div>

                    <div class="tab-pane {{ \request("current_tab") == "flights" ? "active" : "" }}" id="flights" style="min-height: 300px;">
                        @include("airline.layouts.flights-tab")
                    </div>

                    <div class="tab-pane {{ \request("current_tab") == "licenses" ? "active" : "" }}" id="licenses" style="min-height: 300px;">
                        @include("airline-license.licenses-list")
                    </div>

                    <div class="tab-pane {{ \request("current_tab") == "approved_staff" ? "active" : "" }}" id="approved_staff" style="min-height: 300px;">
                        @include("airline.layouts.staff-services-tab")
                    </div>

                    <div class="tab-pane {{ \request("current_tab") == "actypes" ? "active" : "" }}" id="actypes" style="min-height: 300px;">
                        @include("aircraft.list-aircraft-types")
                    </div>

                    <div class="tab-pane {{ \request("current_tab") == "ac" ? "active" : "" }}" id="ac" style="min-height: 300px;">
                        @include("aircraft.list-aircraft", ["airlineID" => $airline->id])
                    </div>

                    <div class="tab-pane {{ \request("current_tab") == "dl" ? "active" : "" }}" id="dl" style="min-height: 300px;">
                        @include("delay-code.layouts.index-list-tab")
                    </div>

                    <div class="tab-pane {{ \request("current_tab") == "fltno" ? "active" : "" }}" id="fltno" style="min-height: 300px;">
                        @include("flight-number.flight-number-list")
                    </div>

                    <div class="tab-pane {{ \request("current_tab") == "sch" ? "active" : "" }}" id="sch" style="min-height: 300px;">
                        @include("handling-flight-schedule.schedule-list", ["list" => $schedules])
                    </div>

                    <div class="tab-pane {{ \request("current_tab") == "lbr" ? "active" : "" }}" id="lbr" style="min-height: 300px;">
                        @include("airline.layouts.library-tab")
                    </div>

                    @if ($envAirline == CAA)
                        <div class="tab-pane {{ \request("current_tab") == "flm" ? "active" : "" }}" id="flm" style="min-height: 300px;">
                            @include("fleet-management.layouts.list-aircraft")
                        </div>
                        <div class="tab-pane {{ \request("current_tab") == "acm" ? "active" : "" }}" id="acm" style="min-height: 300px;">
                            @include("aircraft.layouts.maintenance-list")
                        </div>
                    @endif


                </div>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

//    ApplyMultipleFormSubmit();

    var pagefunction = function() {

//        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#fhr-table", undefined, [[ 0, "asc" ], [ 4, "asc" ], ]);
        ApplyTableFilter("#table-services");
        ApplyTableFilter("#staff-services-table");
        ApplyTableFilter("#aircraft-type-table");
        ApplyTableFilter("#aircraft-table");
        ApplyTableFilter("#delays");
        ApplyTableFilter("#table-flight-numbers");
        ApplyTableFilter("#flight-schedule-table");

        ApplyTableFilter("#table-flights");

        ApplyFormSubmit();
    }

    pagefunction();

</script>