<div class="col-md-12 no-padding margin-bottom-10">
    <a href="{{ route("homepage")."#". url("service/create?s=".rand(100, 999)) }}" class="btn btn-primary">@lang("content.add_service")</a>
</div>

<div class="clearfix"></div>

<div class="jarviswidget jarviswidget-color-blueDark" id="wid-service" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover" id="service-table">
                    <thead>
                    <tr>
                        <th rowspan="2">No</th>
                        <th rowspan="2">@lang("content.service")</th>
                        <th rowspan="2">@lang("content.decode")</th>
                        <th rowspan="2">@lang("content.include_all_stations")</th>

                        <th colspan="5" data-center>@lang("content.turnaround_services")</th>
                        <th colspan="5" data-center>@lang("content.arrival_services")</th>
                        <th colspan="5" data-center>@lang("content.departure_services")</th>

                        <th colspan="2" data-center>@lang("content.effective_time")</th>
                        <th rowspan="2" style="min-width: 180px !important;">@lang("content.actions")</th>
                    </tr>
                    <tr>
                        <th>@lang("content.staff_req")</th>
                        <th>@lang("content.staff_min")</th>
                        <th>@lang("content.report_time")<br/>(@lang("content.mins"), @lang("content.before_arrival"))</th>
                        <th>@lang("content.release_time")<br/>(@lang("content.mins"), @lang("content.after_departure"))</th>
                        <th>@lang("content.duration")</th>

                        <th>@lang("content.staff_req")</th>
                        <th>@lang("content.staff_min")</th>
                        <th>@lang("content.report_time")<br/>(@lang("content.mins"), @lang("content.before_arrival"))</th>
                        <th>@lang("content.release_time")<br/>(@lang("content.mins"), @lang("content.after_arrival"))</th>
                        <th>@lang("content.duration")</th>

                        <th>@lang("content.staff_req")</th>
                        <th>@lang("content.staff_min")</th>
                        <th>@lang("content.report_time")<br/>(@lang("content.mins"), @lang("content.before_departure"))</th>
                        <th>@lang("content.release_time")<br/>(@lang("content.mins"), @lang("content.after_departure"))</th>
                        <th>@lang("content.duration")</th>

                        <th>@lang("content.from")</th>
                        <th>@lang("content.to")</th>

                    </tr>
                    </thead>
                    <tbody>
                    @foreach($services as $i => $each)
                        <tr>
                            <td data-center>{{ $i + 1 }}</td>
                            <td><strong>{{ $each->abbr }}</strong></td>
                            <td>{{ $each->name }}</td>

                            <td data-center>{!! $each->include_all_stations ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>" !!}</td>

                            @include("service.layouts.turnaround-service", ["obj" => $each])

                            @include("service.layouts.arrival-service", ["obj" => $each])

                            @include("service.layouts.departure-service", ["obj" => $each])


                            <td>{{ $each->effective_from }}</td>
                            <td>{{ $each->effective_to }}</td>

                            <td>
                                <div class="btn-group">
                                    <a target="_blank" href="{{ route("homepage")."#". url("service/{$each->id}/edit?s=".rand(100, 999)) }}" class="btn btn-warning">@lang("content.edit")</a>
                                    <a href="{{ route("homepage")."#". url("service/{$each->id}/delete") }}" class="btn btn-danger">@lang("content.delete")</a>
                                </div>
                            </td>
                        </tr>
                    @endforeach

                    </tbody>

                </table>

            </div>

        </div>

    </div>

</div>
