<div class="jarviswidget jarviswidget-color-blueDark" id="wid-license-tab" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>Approved Staff List</h2>
    </header>

    <div>

        {!! Form::open([ 'url' => url("airline/{$airline->id}/staff"), 'class' => 'form-inline', 'method' => 'POST', 'id' => 'formOPS']) !!}

        <div class="form-group marginBottomRight">
            <div class="btn-group">
                <select name="staff[]" class="multiselect_search" id="staff" multiple>
                    @foreach($staffList as $each)
                        <option value="{{ $each->id }}">{{ getUserLocation($each)." - ".getUserName($each) }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="form-group marginBottomRight">
            {!! Form::hidden("airline_id", $airline->id) !!}
            <button type="submit" class="btn btn-primary">Authorise Access</button>
        </div>

        {!! Form::close() !!}

    </div>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive editable_div">

            @php $rest = 160 @endphp
            @php $eachPerc = 60 @endphp
            @php $width = $rest + (count($services) * $eachPerc) @endphp
            @php $j = 0 @endphp


                <table class="table table-hover" id="staff-services-table" style="width: {{ $width }}px; min-width: 100%;">
                    <thead>
                        <tr style="height: 70px; vertical-align: middle;">
                            <th>No</th>
                            <th>@lang("content.picture")</th>
                            <th style="min-width: 100px;">@lang("content.first_name")</th>
                            <th style="min-width: 100px;">@lang("content.last_name")</th>
                            <th style="">@lang("content.station")</th>

                            @foreach($services as $id => $service)
                                <th  class="no-sort rotate-45" style="width: {{ $eachPerc }}px !important; border-bottom: 0; vertical-align: middle;">{{ $service->abbr }}</th>
                            @endforeach
                        </tr>
                    </thead>

                    <tbody>

                    @foreach($airlineApprovedStaff as $i => $staff)

                        @php $picture = $staff->thumb ? '/storage/users/'.$staff->thumb : '/assets/img/default-user-picture.png' @endphp
                        @php $staffServicesIds = $staff->service ? $staff->service->pluck("service_id")->all() : [] @endphp
                        @php $base = $staff->location && $staff->location->airport ? $staff->location->airport->iata : "-" @endphp

                        <tr>
                            <td style="vertical-align: middle;">{{ $i + 1 }}</td>
                            <td><a target="_blank" href="{{ route("homepage")."#".url("/staff/$staff->id/edit") }}" ><img src="{{ $picture }}" width="100" class="img-thumbnail thumb_report_prev" /></a></td>
                            <td><a target="_blank" href="{{ route("homepage")."#". url("staff/{$staff->id}/edit") }}">{{ $staff->first_name }}</a></td>
                            <td><a target="_blank" href="{{ route("homepage")."#". url("staff/{$staff->id}/edit") }}">{{ $staff->last_name }}</a></td>
                            <td>{{ $base }}</td>
                            @foreach($services as $service)
                                <td style="width: {{ $eachPerc }}px !important; vertical-align: middle;">
                                    @if (in_array($service->id, $staffServicesIds))
                                        <i class="fa fa-check"></i>
                                    @endif
                                </td>
                            @endforeach

                        </tr>

                        @php $j++ @endphp

                    @endforeach

                    </tbody>

                </table>

            </div>

        </div>

    </div>

</div>
