<div class="col-md-12 margin-top-10">

    <div class="col-sm-4">
        <!-- Current avatar -->
        @include('forms.general.airline-logo-upload', ['picture' => $airline->picture, 'postUrl' => url("airline/upload/{$airline->id}")])

    </div>

    <div class="col-sm-7 margin-top-10 editable_div">

        {!!  Form::open(['method' => 'POST', 'class' => 'form-inline'])  !!}

            <table class="table table-bordered table-striped table-hover editable_table airline" data-airline_id="{{ $airline->id }}" style="width:100%; padding: 0; margin: 0">
                <thead>

                </thead>
                <tbody>
                <tr>
                    <td colspan="2">
                        <div class="col-sm-4 bg-color-gray no-margin padding-5" style="border-right: 1px solid #ffffff" data-center>
                            <strong>IATA<br/><span class="color-blue">{{ $airline->iata }}</span></strong>
                        </div>
                        <div class="col-sm-4 bg-color-gray no-margin padding-5" style="border-right: 1px solid #ffffff" data-center>
                            <strong>ICAO<br/><span class="color-blue">{{ $airline->icao }}</span></strong>
                        </div>
                        <div class="col-sm-4 bg-color-gray no-margin padding-5" style="border-right: 1px solid #ffffff" data-center>
                            <strong>Callsign<br/><span class="color-blue">{{ $airline->callsign }}</span></strong>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">@lang("content.airline")</td>
                    <td class="color-blue">{{ $airline->airline }}</td>
                </tr>
                @if ($airline->country)
                    <tr>
                        <td class="header_profile">@lang("content.country")</td>
                        <td class="color-blue">{{ $airline->country ? $airline->country->country : '' }}</td>
                    </tr>
                @endif

                @foreach($properties as $name => $each)
                    @if (is_array($each))
                        @if ($airline->{$each[0]})
                            <tr>
                                <td><strong>{{ $name }}</strong></td>
                                <td class="color-blue">{{ date("d-M-Y", strtotime($airline->{$each[0]})) }}</td>
                            </tr>
                        @endif
                    @else
                        @if ($airline->{$each})
                            @php $list = explode("; ", $airline->{$each}) @endphp
                            <tr>
                                <td><strong>{{ $name }}</strong></td>
                                <td class="color-blue">
                                    @if (count($list) > 1)
                                        <ul class="no-margin" style="padding-left: 15px;">
                                            @foreach($list as $item)
                                                <li>{{ $item }}</li>
                                            @endforeach
                                        </ul>
                                    @else
                                        {{ $airline->{$each} }}
                                    @endif
                                </td>
                            </tr>
                        @endif
                    @endif
                @endforeach

                </tbody>
            </table>

        {!!  Form::close()  !!}

        <div class="col-sm-12 no-padding margin-top-10">
            <a target="_blank" href="{{ route("homepage")."#". url("/airline/{$airline->id}/edit") }}" class="btn btn-warning">@lang("content.edit")</a>
        </div>

    </div>

</div>

<div class="clearfix"></div>
