@if (isset($flights) && count($flights->lines))
    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-license" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

            <header>
                <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                <h2>@lang("content.list")</h2>
            </header>

            <!-- widget div-->
            <div>

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->

                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body no-padding" style="min-height: 50px !important;">

                    <div class="table-responsive">

                        <table class="table table-bordered table-hover" id="fhr-table">
                            <thead>
                            <tr>
                                {{--<th>No</th>--}}
                                <th rowspan="2" style="min-width: 60px !important;">@lang("content.date")</th>
                                <th rowspan="2">@lang("content.station")</th>

                                <th rowspan="2" style="min-width: 50px !important;">DEP<br>FLT No</th>
                                <th rowspan="2">TO</th>
                                <th rowspan="2" style="">STD</th>
                                <th rowspan="2" style="min-width: 50px !important;">ARR<br>FLT No</th>
                                <th rowspan="2">FROM</th>
                                <th rowspan="2" style="min-width: 100px !important;">STA</th>

                                <th rowspan="2" style="min-width: 50px !important;">A/C Reg</th>
                                <th rowspan="2" style="">A/C Type</th>
                                <th rowspan="2" style="">ATA</th>
                                <th rowspan="2" style="">ATD</th>

                                <th colspan="2">DL Code</th>

                                <th colspan="4">PAX</th>

                                <th rowspan="2">FHR</th>
                            </tr>
                            <tr>
                                <th>Code</th>
                                <th>Time</th>

                                <th>IN</th>
                                <th>INF</th>
                                <th>OUT</th>
                                <th>INF</th>
                            </tr>

                            </thead>
                            <tbody>
                            @foreach ($flights->lines as $k => $line)

                                @php $items = $line->getFlights() @endphp
                                @php $depFlight = $depFn = $depAp = $arrAp = $depAC = null @endphp

                                @if (count($items) == 2)
                                    @php $depFlight = $items[1] @endphp
                                    @php $depAp = getFlightDepartureAirport($depFlight, false, true) @endphp
                                    @php $arrAp = getFlightArrivalAirport($depFlight, false, true) @endphp
                                    @php $depSTD = $depFlight->std && $depFlight->std != EMPTY_DATETIME ? baseDateFormat($depFlight->std, true) : null @endphp
                                    @php $depSTDDate = $depSTD ? date("Y-m-d", strtotime($depSTD)) : null @endphp

                                    @php $depFn = getFlightNumberFull($depFlight->flightNumber) @endphp
                                    @php $depAC = getFlightAircraft($depFlight) @endphp
                                    @php $depACType = getFlightAircraftType($depFlight) @endphp

                                    @php $arrFlight = $items[0] @endphp
                                    @php $arrFN = getFlightNumberFull($arrFlight->flightNumber) @endphp
                                    @php $arrDepAp = getFlightDepartureAirport($arrFlight, false, true) @endphp
                                    @php $arrSTA = $arrFlight->sta && $arrFlight->sta != EMPTY_DATETIME ? baseDateFormat($arrFlight->sta, true) : null @endphp
                                    @php $arrSTADate = $arrSTA ? date("Y-m-d", strtotime($arrSTA)) : null @endphp
                                    <tr>
                                        <td>{{ getFlightDepartureInitialDate($depFlight, true)}}</td>

                                        {{--Departure Flight--}}
                                        <td>{{ $depAp }}</td>
                                        <td>{{ $depFn }}</td>
                                        <td>{{ $arrAp }}</td>
                                        <td>{{ baseTimeFormat($depSTD) }}</td>

                                        {{--Arrival Flight--}}
                                        <td>{{ $arrFN }}</td>
                                        <td>{{ $arrDepAp }}</td>
                                        <td>{{ ($depSTDDate != $arrSTADate ? $arrSTADate." " : ""). baseTimeFormat($arrSTA) }}</td>


                                        <td>{{ $depAC }}</td>
                                        <td>{{ $depACType }}</td>

                                        {{--Arrival flight ATA--}}
                                        <td>{{ $arrFlight->ata && $arrFlight->ata != EMPTY_DATETIME ? baseTimeFormat($arrFlight->ata) : "" }}</td>

                                        {{--Departure flight ATD--}}
                                        <td>{{ $depFlight->atd && $depFlight->atd != EMPTY_DATETIME ? baseTimeFormat($depFlight->atd) : "" }}</td>

                                        {{--DELAYS OUT--}}
                                        @php list($codes, $times) = getFlightDelays($depFlight) @endphp
                                        @if (count($codes))
                                            <td class="color-red">DL {{ implode("/", $codes) }}</td>
                                            <td class="color-red">{{ implode("/", $times) }}</td>
                                        @else
                                            <td></td>
                                            <td></td>
                                        @endif

                                        {{--- PAX IN---}}
                                        <td>{{ getFlightPaxTotal($arrFlight, true) }}</td>
                                        <td>{{ $arrFlight->pax_inf_actual }}</td>

                                        {{--- PAX OUT---}}
                                        <td>{{ getFlightPaxTotal($depFlight, true) }}</td>
                                        <td>{{ $depFlight->pax_inf_actual }}</td>

                                        {{--- Baggage IN---}}
{{--                                        <td>{{ $arrFlight->baggage_pcs }}</td>--}}
{{--                                        <td>{{ $arrFlight->baggage }}</td>--}}
                                        {{--- Baggage OUT---}}
{{--                                        <td>{{ $depFlight->baggage_pcs }}</td>--}}
{{--                                        <td>{{ $depFlight->baggage }}</td>--}}
                                        {{--- Cargo IN---}}
{{--                                        <td>{{ $arrFlight->cargo_pcs }}</td>--}}
{{--                                        <td>{{ $arrFlight->cargo }}</td>--}}
                                        {{--- Cargo OUT---}}
{{--                                        <td>{{ $depFlight->cargo_pcs }}</td>--}}
{{--                                        <td>{{ $depFlight->cargo }}</td>--}}

                                        {{--Counters--}}
                                        <td>
                                            <a target="_blank" href="{{ route("homepage") ."#". url("flight-view/fhr/{$depFlight->id}") }}" target="_blank">FHR</a>
                                        </td>
                                    </tr>
                                @else
                                    @php $flight = $items[0] @endphp
                                    @php $fn = getFlightNumberFull($flight->flightNumber) @endphp
                                    @if ($flight->type == DEPARTURE)

                                        @php $ac = getFlightAircraft($flight) @endphp
                                        @php $acType = getFlightAircraftType($flight) @endphp
                                        @php $depAp = getFlightDepartureAirport($flight, false, true) @endphp
                                        @php $arrAp = getFlightArrivalAirport($flight, false, true) @endphp
                                        <tr>
                                            {{--<td>{{ $k + 1 }}</td>--}}
                                            <td>{{ getFlightDepartureInitialDate($flight, true) }}</td>

                                            {{--Departure Flight--}}
                                            <td>{{ $depAp }}</td>
                                            <td>{{ $fn }}</td>
                                            <td>{{ $arrAp }}</td>

                                            {{--Departure Flight--}}
                                            <td>{{ $flight->std && $flight->std != EMPTY_DATETIME ? baseTimeFormat($flight->std) : "" }}</td>

                                            {{--Arrival Flight--}}
                                            <td></td>
                                            <td></td>
                                            <td></td>

                                            <td>{{ $ac }}</td>
                                            <td>{{ $acType }}</td>

                                            {{--Arrival flight ATA--}}
                                            <td></td>

                                            {{--Departure flight ATD--}}
                                            <td>{{ $flight->atd && $flight->atd != EMPTY_DATETIME ? baseTimeFormat($flight->atd) : "" }}</td>

                                            @php list($codes, $times) = getFlightDelays($flight) @endphp
                                            @if (count($codes))
                                                <td class="color-red">DL {{ implode("/", $codes) }}</td>
                                                <td class="color-red">{{ implode("/", $times) }}</td>
                                            @else
                                                <td></td>
                                                <td></td>
                                            @endif

                                            {{--- PAX IN---}}
                                            <td></td>
                                            <td></td>

                                            {{--- PAX OUT---}}
                                            <td>{{ getFlightPaxTotal($flight, true) }}</td>
                                            <td>{{ $flight->pax_inf_actual }}</td>

                                            {{--- BAGGAGE IN---}}
{{--                                            <td></td>--}}
{{--                                            <td></td>--}}
                                            {{--- BAGGAGE OUT---}}
{{--                                            <td>{{ $flight->baggage_pcs }}</td>--}}
{{--                                            <td>{{ $flight->baggage }}</td>--}}
                                            {{--- Cargo IN---}}
{{--                                            <td></td>--}}
{{--                                            <td></td>--}}
                                            {{--- Cargo OUT---}}
{{--                                            <td>{{ $flight->cargo_pcs }}</td>--}}
{{--                                            <td>{{ $flight->cargo }}</td>--}}
                                            {{--Counters--}}
                                            <td>
                                                <a href="{{ route("homepage") ."#". url("flight-view/fhr/{$flight->id}") }}" target="_blank">
{{--                                                    <span class="widget-icon font-lg"> <i class="fa fa-book"></i> </span>--}}
                                                    FHR
                                                </a>
                                            </td>
                                        </tr>
                                    @endif
                                @endif

                            @endforeach
                            </tbody>

                        </table>

                    </div>

                </div>

            </div>

        </div>
    @endif
