<div class="col-md-12" style="padding: 15px !important;">

    <div class="col-sm-4">
        <!-- Current avatar -->
        @include('forms.general.airline-logo-upload', ['picture' => $airline->picture, 'postUrl' => url("airline/upload/{$airline->id}")])

    </div>

    <div class="col-sm-7 margin-top-10 editable_div">

        {!!  Form::open(['method' => 'POST', 'class' => 'form-inline'])  !!}

            <table class="table table-bordered table-striped table-hover editable_table airline" data-airline_id="{{ $airline->id }}" style="width:100%; padding: 0; margin: 0">
                <thead>

                </thead>
                <tbody>
                <tr>
                    <td class="header_profile">@lang("content.airline")</td>
                    <td>
                        <a href="#" data-field='airline' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required" style="font-weight: bold; font-size: 1.2em;"
                           class="editable {{  $airline->airline ? 'editable-click' : 'editable-empty' }}">{{ $airline->airline ? $airline->airline : 'Empty'}}</a>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <div class="col-sm-4 bg-color-gray no-margin padding-5" style="border-right: 1px solid #ffffff" data-center><strong>
                            IATA<br/>
                            <a href="#" data-field='iata' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                               data-placeholder="Required"
                               class="editable {{  $airline->iata ? 'editable-click' : 'editable-empty' }}">{{ $airline->iata ? $airline->iata : 'Empty'}}</a>
                            </strong>
                        </div>
                        <div class="col-sm-4 bg-color-gray no-margin padding-5" style="border-right: 1px solid #ffffff" data-center><strong>
                            ICAO<br/>
                            <a href="#" data-field='icao' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                               data-placeholder="Required"
                               class="editable {{  $airline->icao ? 'editable-click' : 'editable-empty' }}">{{ $airline->icao ? $airline->icao : 'Empty'}}</a>
                            </strong>
                        </div>
                        <div class="col-sm-4 bg-color-gray no-margin padding-5" data-center><strong>
                            Callsign<br/>
                            <a href="#" data-field='callsign' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                               data-placeholder="Required"
                               class="editable {{  $airline->callsign ? 'editable-click' : 'editable-empty' }}">{{ $airline->callsign ? $airline->callsign : 'Empty' }}</a>
                            </strong>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">@lang("content.country")</td>
                    <td>
                        <a href="#" data-field='country_id' data-model="Airline" data-type="select"
                           data-id='{{ $airline->id }}'
                           data-placeholder="Required" data-value='{{ $airline->country_id }}'
                           class="editable {{  $airline->country_id ? 'editable-click' : 'editable-empty'  }}">
                            {{  $airline->country ? $airline->country->country : 'Empty' }}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Founded</td>
                    <td>
                        <a href="#" data-field='founded' data-model="Airline" data-type="date" data-id='{{ $airline->id }}'
                           data-placeholder="Required" data-format='d-M-Y'
                           data-js_format='DD-MMM-YYYY' data-value='{{ $airline->founded }}'
                           class="editable {{  $airline->founded ? 'editable-click' : 'editable-empty'  }}">
                            {{  $airline->founded  ?  date('d-M-Y', strtotime($airline->founded))  : 'Empty' }}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Commenced operations</td>
                    <td>
                        <a href="#" data-field='commenced' data-model="Airline" data-type="date" data-id='{{ $airline->id }}'
                           data-placeholder="Required" data-format='d-M-Y'
                           data-js_format='DD-MMM-YYYY' data-value='{{ $airline->commenced }}'
                           class="editable {{  $airline->commenced ? 'editable-click' : 'editable-empty'  }}">
                            {{  $airline->commenced  ?  date('d-M-Y', strtotime($airline->commenced))  : 'Empty' }}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Operating bases</td>
                    <td>
                        <a href="#" data-field='operating_bases' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{ $airline->operating_bases ? 'editable-click' : 'editable-empty' }}">{{ $airline->operating_bases ? $airline->operating_bases : 'Empty'}}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Hubs</td>
                    <td>
                        <a href="#" data-field='hubs' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->hubs ? 'editable-click' : 'editable-empty' }}">{{ $airline->hubs ? $airline->hubs  : 'Empty' }}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Secondary Hubs</td>
                    <td>
                        <a href="#" data-field='secondary_hubs' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->secondary_hubs ? 'editable-click' : 'editable-empty' }}">{{ $airline->secondary_hubs ? $airline->secondary_hubs  : 'Empty' }}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Focus cities</td>
                    <td>
                        <a href="#" data-field='focus_cities' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->focus_cities ? 'editable-click' : 'editable-empty' }}">{{ $airline->focus_cities ? $airline->focus_cities  : 'Empty' }}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Frequent-flyer program</td>
                    <td>
                        <a href="#" data-field='ffp' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->ffp ? 'editable-click' : 'editable-empty' }}">{{ $airline->ffp ? $airline->ffp : 'Empty'}}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Alliance</td>
                    <td>
                        <a href="#" data-field='alliance' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->alliance ? 'editable-click' : 'editable-empty' }}">{{ $airline->alliance ? $airline->alliance  : 'Empty' }}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Subsidiaries</td>
                    <td>
                        <a href="#" data-field='subsidiaries' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->subsidiaries ? 'editable-click' : 'editable-empty' }}">{{ $airline->subsidiaries ? $airline->subsidiaries  : 'Empty' }}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Fleet size</td>
                    <td>
                        <a href="#" data-field='fleet_size' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->fleet_size ? 'editable-click' : 'editable-empty' }}">{{ $airline->fleet_size ? $airline->fleet_size  : 'Empty' }}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Destinations</td>
                    <td>
                        <a href="#" data-field='destinations' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->destinations ? 'editable-click' : 'editable-empty' }}">{{ $airline->destinations ? $airline->destinations : 'Empty'}}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Company slogan</td>
                    <td>
                        <a href="#" data-field='slogan' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->slogan ? 'editable-click' : 'editable-empty' }}">{{ $airline->slogan ? $airline->slogan : 'Empty'}}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Parent company</td>
                    <td>
                        <a href="#" data-field='parent_company' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->parent_company ? 'editable-click' : 'editable-empty' }}">{{ $airline->parent_company ? $airline->parent_company : 'Empty'}}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Headquarters</td>
                    <td>
                        <a href="#" data-field='headquarters' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->headquarters ? 'editable-click' : 'editable-empty' }}">{{ $airline->headquarters ? $airline->headquarters : 'Empty'}}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Key people</td>
                    <td>
                        <a href="#" data-field='key_people' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->key_people ? 'editable-click' : 'editable-empty' }}">{{ $airline->key_people ? $airline->key_people : 'Empty'}}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Employees</td>
                    <td>
                        <a href="#" data-field='employees' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->employees ? 'editable-click' : 'editable-empty' }}">{{ $airline->employees ? $airline->employees : 'Empty'}}</a>
                    </td>
                </tr>
                <tr>
                    <td class="header_profile">Website</td>
                    <td>
                        <a href="#" data-field='website' data-model="Airline" data-type="text" data-id='{{ $airline->id }}'
                           data-placeholder="Required"
                           class="editable {{  $airline->website ? 'editable-click' : 'editable-empty' }}">{{ $airline->website ? $airline->website : 'Empty'}}</a>
                    </td>
                </tr>
                </tbody>
            </table>

        {!!  Form::close()  !!}

        <div class="col-sm-12 no-padding margin-top-10">
            <a href="{{ route("homepage")."#". url("/airline/{$airline->id}/offline") }}" class="btn btn-danger">Make
                Offline</a>
        </div>

    </div>

</div>

<div class="clearfix"></div>
