@php $isAdmin = isAnyAdmin() @endphp
<div class="col-md-12 no-padding margin-bottom-10">
    <a href="{{ route("homepage")."#". url("/airline-service/create?s=".rand(100, 999)."&airline_id={$airline->id}") }}"
       class="btn btn-primary">Add Services To All Airports</a>
</div>

<div class="clearfix"></div>

@if (count($slaByAirports))

    <ul id="tabStations" class="nav nav-tabs bordered">
        @php $j = 0 @endphp
        @foreach($slaByAirports as $i => $each)
            <li class="{{ $j++ == 0 ? "active" : "" }}">
                <a href="#airport-{{ $i }}" role="tab" data-toggle="tab">{{ $i }}</a>
            </li>
        @endforeach

        @if ($isAdmin)
            <li class="">
                <a href="#log_tab" role="tab" data-toggle="tab">LOG</a>
            </li>
        @endif
    </ul>

    <div id="tab-sla-by-airports" class="tab-content padding-10 background-white">

        @php $j = 0 @endphp
        @foreach($slaByAirports as $i => $slaItem)

            <div class="tab-pane {{ $j++ == 0 ? "active" : "" }}" id="airport-{{ $i }}">

                <div class="col-md-12 no-padding margin-bottom-10">
                    <a href="{{ route("homepage")."#". url("/airline-service/create?s=".rand(100, 999)."&airline_id={$airline->id}&airport_id={$airports[$i]}") }}"
                       class="btn btn-success">Add Services</a>
                </div>

                <div class="clearfix"></div>

                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-airport-{{ $i }}"
                     data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                        <h2>SLA</h2>
                    </header>

                    <!-- widget div-->
                    <div>

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->

                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body no-padding" style="min-height: 50px !important;">


                            <div class="table-responsive">

                                <table class="table table-bordered table-hover" id="sla-{{ $i }}">
                                    <thead>
                                    <tr>
                                        <th rowspan="2">No</th>
                                        <th colspan="3" data-center>@lang("content.service")</th>
                                        <th rowspan="2" style="min-width: 90px !important;">Effective date</th>
                                        <th rowspan="2" style="min-width: 90px !important;">Discontinue date</th>

                                        <th colspan="5" data-center>@lang("content.turnaround_services")</th>
                                        <th colspan="5" data-center>@lang("content.arrival_services")</th>
                                        <th colspan="5" data-center>@lang("content.departure_services")</th>

                                        <th colspan="2" data-center>@lang("content.effective_time")</th>
                                        <th rowspan="2" style="min-width: 120px;">@lang("content.actions")</th>
                                    </tr>
                                    <tr>
                                        <th>@lang("content.name")</th>
                                        <th>@lang("content.status")</th>
                                        <th>@lang("content.include_all_stations")</th>

                                        <th>@lang("content.staff_req")</th>
                                        <th>@lang("content.staff_min")</th>
                                        <th>@lang("content.start_time")<br/>(mins, before arrival)</th>
                                        <th>@lang("content.release_time")<br/>(mins, after departure)</th>
                                        <th>@lang("content.duration")</th>

                                        <th>@lang("content.staff_req")</th>
                                        <th>@lang("content.staff_min")</th>
                                        <th>@lang("content.start_time")<br/>(mins, before arrival)</th>
                                        <th>@lang("content.release_time")<br/>(mins, after arrival)</th>
                                        <th>@lang("content.duration")</th>

                                        <th>@lang("content.staff_req")</th>
                                        <th>@lang("content.staff_min")</th>
                                        <th>@lang("content.start_time")<br/>(mins, before departure)</th>
                                        <th>@lang("content.release_time")<br/>(mins, after departure)</th>
                                        <th>@lang("content.duration")</th>

                                        <th>@lang("content.from")</th>
                                        <th>@lang("content.to")</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($slaItem as $k => $each)

                                        @php $obj = $each->service_timings ? $each->service : $each @endphp

                                        @if (!$obj)
                                            <tr>
                                                <td colspan="15">N/A</td>
                                            </tr>
                                        @else
                                            <tr>
                                                <td data-center>{{ $k + 1 }}</td>
                                                <td><strong>{{ $each->service ? $each->service->abbr : "-" }}</strong></td>
                                                <td>{!! $each->service_timings ? "<span class='label label-primary margin_left_10'>Defaults</span>" : "<span class='label label-warning margin_left_10'>Edited</span>" !!}</td>
                                                <td data-center>{!! $obj->include_all_stations ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>" !!}</td>

                                                <td>{{ $each->start_date }}</td>
                                                <td>{{ $each->end_date }}</td>

                                                @include("service.layouts.turnaround-service")

                                                @include("service.layouts.arrival-service")

                                                @include("service.layouts.departure-service")


                                                <td>{{ $obj->effective_from }}</td>
                                                <td>{{ $obj->effective_to }}</td>

                                                <td>
                                                    <div class="btn-group">
                                                        <a target="_blank" href="{{ route("homepage")."#". url("/airline-service/{$each->id}/edit") }}"
                                                           class="btn btn-warning">@lang("content.edit")</a>
                                                        <a href="{{ route("homepage")."#". url("/airline-service/{$each->id}/delete") }}"
                                                           class="btn btn-danger">Delete</a>
                                                    </div>
                                                </td>
                                            </tr>

                                        @endif

                                    @endforeach

                                    </tbody>

                                </table>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        @endforeach

        @if ($isAdmin && isset($auditData))
            <div class="tab-pane" id="log_tab" style="min-height: 300px">
                @include("airline.layouts.show-sla-audit-table")
            </div>
        @endif

    </div>

@endif