<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">


        <article class="col-xs-12 col-sm-12 col-md-22 col-lg-12" style="background-color: #ffffff">

            <img src="{{ asset("storage/airlines/img/{$airline->picture}") }}" style="max-height: 80px; padding: 10px;" />

            <div class="jarviswidget" id="wid-id-1" data-widget-colorbutton="false" data-widget-editbutton="false" data-widget-custombutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>
                    <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                    <h2><strong>{{ $airport ? $airport->iata : "Add Services To All Airports" }}</strong></h2>

                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body padding-10">

                        {!! Form::open([ 'method' => 'POST', 'class' => 'form-horizontal', 'url' => url("airline-service") ]) !!}

                            <div class="form-group">
                                @if (isset($airport) && $airport)
                                    <input type="hidden" name="airport_id" value="{{ $airport->id }}">
                                @else
                                    <label class="col-md-2">Airport</label>
                                    <div class="col-md-9">
                                        {!! Form::select('airport_id[]', $airports, null, [ 'multiple' => 'multiple', 'class'=>'form-control multiselect_search']) !!}
                                    </div>
                                @endif
                            </div>

                            <div class="form-group">
                                <label class="col-md-2">@lang("content.service")</label>
                                <div class="col-md-9">
                                    {!! Form::select('service_id[]', $services, null, [ 'multiple' => 'multiple', 'class'=>'form-control multiselect_search']) !!}
                                    <input type="hidden" name="airline_id" value="{{ $airline->id }}">
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-md-2">Effective date</label>
                                <div class="col-md-9">
                                    {!! Form::text('start_date', null, ['class' => 'dateFrom']) !!}
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-md-2">Discontinue date</label>
                                <div class="col-md-9">
                                    {!! Form::text('end_date', null, ['class' => 'dateTo']) !!}
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-md-offset-1 col-md-2">
                                     {!! Form::submit("Add Services", ['class' => 'btn btn-success btn-sm']) !!}
                                </div>
                            </div>

                        {!! Form::close() !!}

                    </div>

                </div>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();
    }

    pagefunction();

</script>
