<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 21.08.14

 */

if ($aircraft->maintenance_id) {
    $maintenance = $aircraft->maintenance()->where("id", $aircraft->maintenance_id)->first();
}
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    @include('general.tab-header', ['departmentName' => 'Admin', 'moduleName' => trans("content.edit_aircraft").': '.$aircraft->name])

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <ul id="tabAC" class="nav nav-tabs bordered">
                <li class="{{ !\request("tab") || \request("tab") == 'aircraft_data' ? "active" : "" }}">
                    <a href="#aircraft_data" role="tab" data-toggle="tab">@lang("content.aircraft_data")</a>
                </li>

                <li class="{{ \request("tab") == 'flight_data' ? "active" : "" }}">
                    <a href="#flight_data" role="tab" data-toggle="tab">@lang("content.flight_data")</a>
                </li>

                <li>
                    <a href="{{ route("homepage")."#aircraft-utilization?aircraft={$aircraft->id}" }}" target="_blank">@lang("modules.aircraft_utilization")</a>
                </li>
            </ul>

            <div id="tabContentParent" class="tab-content padding-10 background-white">

                <div class="tab-pane {{ !\request("tab") || \request("tab") == 'aircraft_data' ? "active" : "" }}" id="aircraft_data">
                    @include("aircraft.layouts.show-aircraft-data-tab")
                </div>

                <div class="tab-pane {{ \request("tab") == 'flight_data' ? "active" : "" }}" id="flight_data">
                    @include("aircraft.layouts.show-flight-data-tab")
                </div>
           </div>

        </article>

    </div>

</section>


<link rel="stylesheet" type="text/css" href="{{ asset("/assets/css/jquery.seat-charts.css?4") }}">

<script type="text/javascript">

    var acConfig = {!! json_encode($seatConfig) !!};

    {{--$('.seatCharts-container').css('height', "{{ $wide_board ? "240px" : "170px" }}");--}}

    @if (!$aircraft->aisles)
        var mColumn = $(document).find(".seat-columns-m");
        mColumn.val("");
        mColumn.attr("disabled", "disabled");
    @endif

    $(".aisles").on("click", function(){

        var _this = $(this), mColumn = $(document).find(".seat-columns-m");

        if (_this.val() == 1) {
            mColumn.val("");
            mColumn.attr("disabled", "disabled");
        }
        else {
//            mColumn.val("");
            mColumn.removeAttr("disabled");
        }

    });

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        MapPassengersBySeat();

        ApplyTableFilter("#table-flights");
    };

    loadScript("{{ asset("/assets/js/vendor/jquery.seat-charts.js") }}", function () {
        loadScript("{{ asset("/assets/js/views/flight-info/index.js?7") }}", function(){
            loadScript("{{ asset("/assets/js/views/aircraft/edit.js?5") }}", pagefunction);
        });
    });

</script>

