<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Admin', 'moduleName' => "Edit ".$aircraftType->name." Aircraft Type"])

            <div class="col-sm-12">
                    @if ($errors->all())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{!! $error !!}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    {!! Form::open(['method' => 'POST', 'class' => 'form-horizontal']) !!}

                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-2">@lang("content.name")</label>

                            <div class="col-sm-6">
                                <h4 class="bg-color-white padding-5">{{ $aircraftType->name ? $aircraftType->name : "-" }}</h4>
                            </div>
                        </div>

                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-2">IATA</label>

                            <div class="col-sm-6">
                                <h4 class="bg-color-white padding-5">{{  $aircraftType->iata_name ? $aircraftType->iata_name : "-" }}</h4>
                            </div>
                        </div>

                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-2">ICAO</label>

                            <div class="col-sm-6">
                                <h4 class="bg-color-white padding-5">{{  $aircraftType->icao ? $aircraftType->icao : "-" }}</h4>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-2">@lang("content.config")</label>

                            <label class="control-label col-sm-1">F</label>
                            <div class="col-sm-1">
                                <h4 class="bg-color-white padding-5">{{  $aircraftType->config_a ? $aircraftType->config_a : "-" }}</h4>
                            </div>

                            <label class="control-label col-sm-1">C</label>
                            <div class="col-sm-1">
                                <h4 class="bg-color-white padding-5">{{  $aircraftType->config_c ? $aircraftType->config_c : "-" }}</h4>
                            </div>

                            <label class="control-label col-sm-1">W</label>
                            <div class="col-sm-1">
                                <h4 class="bg-color-white padding-5">{{  $aircraftType->config_w ? $aircraftType->config_w : "-" }}</h4>
                            </div>

                            <label class="control-label col-sm-1">Y</label>
                            <div class="col-sm-1">
                                <h4 class="bg-color-white padding-5">{{  $aircraftType->config_y ? $aircraftType->config_y : "-" }}</h4>
                            </div>

                        </div>

                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-2">@lang("content.wake_category")</label>

                            <div class="col-sm-6">
                                <h4 class="bg-color-white padding-5">{{  $aircraftType->wake_category ? $aircraftType->wake_category : "-" }}</h4>
                            </div>
                        </div>

                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-2">@lang("content.details")</label>

                            <div class="col-sm-6">
                                <h4 class="bg-color-white padding-5">{{  $aircraftType->details ? $aircraftType->details : "-" }}</h4>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-2">@lang("content.fcm_requirements")</label>

                            <label class="control-label col-sm-2">@lang("content.minimum")</label>
                            <div class="col-sm-1">
                                <h4 class="bg-color-white padding-5">{{  $aircraftType->min_fcm ? $aircraftType->min_fcm : "-" }}</h4>
                            </div>

                            <label class="control-label col-sm-2">@lang("content.policy")</label>
                            <div class="col-sm-1">
                                <h4 class="bg-color-white padding-5">{{  $aircraftType->policy_fcm ? $aircraftType->policy_fcm : "-" }}</h4>
                            </div>

                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-2">@lang("content.ccm_requirements")</label>

                            <label class="control-label col-sm-2">@lang("content.minimum")</label>
                            <div class="col-sm-1">
                                <h4 class="bg-color-white padding-5">{{  $aircraftType->min_ccm ? $aircraftType->min_ccm : "-" }}</h4>
                            </div>

                            <label class="control-label col-sm-2">@lang("content.policy")</label>
                            <div class="col-sm-1">
                                <h4 class="bg-color-white padding-5">{{  $aircraftType->policy_ccm ? $aircraftType->policy_ccm : "-" }}</h4>
                            </div>
                        </div>
                        <hr/>
                        <div class="form-group">
                            <div class="col-sm-offset-3 col-sm-9">
                                <a target="_blank" href="{{ route("homepage")."#". url("aircraft/edit-type?id={$aircraftType->id}") }}" class="btn btn-danger">@lang("content.edit")</a>
                            </div>
                        </div>
                    {!! Form::close() !!}
                </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#aircraft-table");
    };

    pagefunction();

</script>
