<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 21.08.14

 */

if ($aircraft->maintenance_id) {
    $maintenance = $aircraft->maintenance()->where("id", $aircraft->maintenance_id)->first();
}
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    @include('general.tab-header', ['departmentName' => trans("modules.admin"), 'moduleName' => $aircraft->name])

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <ul id="tabAC" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#aircraft" role="tab" data-toggle="tab">@lang("content.aircraft")</a>
                </li>
{{--                <li class="">--}}
{{--                    <a href="#aircraft_weights" role="tab" data-toggle="tab">@lang("content.weights_index")</a>--}}
{{--                </li>--}}
{{--                <li class="">--}}
{{--                    <a href="#aircraft_parts" role="tab" data-toggle="tab">@lang("content.parts")</a>--}}
{{--                </li>--}}
            </ul>

            @php $active = 0 @endphp
            <div id="tabContent" class="tab-content padding-10 background-white">

                <div class="tab-pane active" id="aircraft">

                    <div class="btn-group">
{{--                        <a href="{{ route("homepage")."#".url("fleet-management/aircraft-details?id={$aircraft->id}") }}" class="btn btn-sm btn-success">Details</a>--}}
                        <a href="{{ route("homepage")."#".url("aircraft/maintenance/{$aircraft->id}") }}" class="btn btn-sm btn-warning">@lang("content.maintenance")</a>
                    </div>

                    <div class="col-sm-12">

                        <div class="col-sm-6">

                            <div class="form-group has-feedback">
                                <label class="control-label col-sm-3">@lang("content.name")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->name ? $aircraft->name : "-" }}</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-3">MVT @lang("content.name")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->mvt_name ? $aircraft->mvt_name : "-" }}</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-3">@lang("content.type")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->type ? $aircraft->type->icao : "-" }}</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-3">@lang("content.airline")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->airline ? $aircraft->airline->iata : "-" }}</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-3">@lang("content.description")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->description ? $aircraft->description : "-" }}</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-3">@lang("content.construction_number") (MSN)</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->msn ? $aircraft->msn : "-" }}</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-3">@lang("content.line_number")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->line_number ? $aircraft->line_number : "-" }}</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-3">@lang("content.first_flight")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->first_flight ? $aircraft->first_flight : "-" }}</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-3">@lang("content.airframe_status")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->airframe_status ? $aircraft->airframe_status : "-" }}</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-3">@lang("content.noise_category")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->noise_category ? $aircraft->noise_category : "-" }}</p>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="control-label col-sm-3">@lang("content.cargo_compartments")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->cargo_compartments ? $aircraft->cargo_compartments : "-" }}</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-3">@lang("content.total") @lang("content.cargo_volume")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->cargo_volume ? $aircraft->cargo_volume : "-" }}</p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-3">@lang("content.hourly_fuel_consumption")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->hourly_fuel_consumption ? $aircraft->hourly_fuel_consumption : "-" }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-6">

                             <ul id="tabConfig" class="nav nav-tabs bordered">
                                <li class="">
                                    <a href="#config_a" role="tab" data-toggle="tab">@lang("content.first_class")</a>
                                </li>
                                <li class="">
                                    <a href="#config_c" role="tab" data-toggle="tab">@lang("content.business_class")</a>
                                </li>
                                <li class="active">
                                    <a href="#config_y" role="tab" data-toggle="tab">@lang("content.economy_class")</a>
                                </li>
                            </ul>

                            <div id="tabConfigContent" class="tab-content padding-10 background-white">

                                <div class="tab-pane" id="config_a">
                                    @include("aircraft.layouts.config-properties", ["class" => "a", "configData" => $seatConfig["a"]])
                                </div>

                                <div class="tab-pane" id="config_c">
                                    @include("aircraft.layouts.config-properties", ["class" => "c", "configData" => $seatConfig["b"]])
                                </div>

                                <div class="tab-pane active" id="config_y">
                                    @include("aircraft.layouts.config-properties", ["class" => "y", "configData" => $seatConfig["e"]])
                                </div>

                            </div>

                            <div class="clearfix"></div>

                            <div class="form-group margin-top-10">
                                <label class="control-label col-sm-3">@lang("content.number_of_decks")</label>
                                <div class="col-sm-9">
                                    <p>{{  $aircraft->name ? $aircraft->name : "-" }}</p>
                                    {!! Form::text('decks', $aircraft->decks, ['class'=>'form-control input-sm']) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-3 color-red">@lang("content.number_of_aisles")</label>
                                <div class="col-sm-3">
                                    <label class="control-label col-sm-3">1</label>
                                    {!! Form::radio( 'aisles', 1, !$aircraft->aisles || $aircraft->aisles == 1, ['disabled', 'class' => 'form-control input-sm aisles']) !!}
                                </div>
                                <div class="col-sm-3">
                                    <label class="control-label col-sm-3">2</label>
                                    {!! Form::radio( 'aisles', 2, $aircraft->aisles == 2, ['disabled','class' => 'form-control input-sm aisles']) !!}
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="control-label col-sm-6 color-red">@lang("content.set_as_aircraft_type_default_configuration")(4)</label>
                                <div class="col-sm-3">
                                    {!! Form::checkbox( 'aircraft_type_defaults', null, null, ['disabled', 'class' => 'form-control input-sm']) !!}
                                </div>
                            </div>

                            <div class="form-group margin-top-10 padding-10" style="border-top: 1px solid #9b9b9b;">
                                <div class="col-sm-12">* @lang("content.input") '_' @lang("content.for_walkway")</div>
                                <div class="col-sm-12">** @lang("content.separate_rows_and_seats_with") ';'</div>
                                <div class="col-sm-12">*** @lang("content.extra_space_after_specified_rows")</div>
                                <div class="col-sm-12">(4) @lang("content.sets_current_aircraft_seat_configurations_to_aircraft_type")</div>
                            </div>

                        </div>

                    </div>

                    <div class="clearfix"></div>

                    @if (isset($seatConfig["e"]) && count($seatConfig["e"]))
                        <div id="seat-map" class="col-lg-12 seatCharts-container"></div>
                        <div id="legend"></div>
                        @include('template.seat-info')
                    @endif

                </div>

                <div class="tab-pane" id="aircraft_weights">

                    <div id="message-parameters"></div>
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>@lang("content.name")</th>
                                <th>@lang("content.value")</th>
                            </tr>
                        </thead>

                        <tbody>
                        @foreach ($aircraftParameters as $key => $parameter)
                            @if ($parameter == "Max Take-Off")
                                <tr>
                                    <td colspan="3" class="bg-color-gray"><strong>@lang("content.weights")(@lang("content.tons"))</strong></td>
                                </tr>
                            @elseif($parameter == "Usable Fuel")
                                <tr>
                                    <td colspan="3" class="bg-color-gray"><strong>@lang("content.fuel_capacity")(@lang("content.tons"))</strong></td>
                                </tr>
                            @endif
                            <tr>
                                <td>{!! $parameter !!}</td>
                                <td>
                                    @php $currentValue = (isset($aircraftCurrentParameters[$key]) && $aircraftCurrentParameters[$key]) ? $aircraftCurrentParameters[$key] : null @endphp
                                    {!! ($currentValue) ? $currentValue : "&mdash;" !!}
                                </td>
                            </tr>
                        @endforeach
                        </tbody>

                    </table>
                </div>

                <div class="tab-pane" id="aircraft_parts">

                    <div class="col-sm-12" style="min-height: 450px;">

                        <table class="table table-bordered table-hover margin-top-10">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>@lang("content.part_type")</th>
                                <th>@lang("content.part_number")</th>
                                <th>@lang("content.serial_mumber")</th>
                            </tr>
                            </thead>

                            <tbody>
                            @foreach ($aircraftParts as $aircraftPart)
                                <tr>
                                    <td>{!! $aircraftPart->id !!}</td>
                                    <td>{!! $aircraftPart->part_type !!}</td>
                                    <td>{!! $aircraftPart->part_number !!}</td>
                                    <td>{!! $aircraftPart->serial_number !!}</td>
                                </tr>
                            @endforeach

                            </tbody>
                        </table>


                    </div>

                    <div class="clearfix"></div>
                </div>
           </div>

        </article>

    </div>

</section>


<link rel="stylesheet" type="text/css" href="{{ asset("/assets/css/jquery.seat-charts.css?4") }}">

<script type="text/javascript">

    var acConfig = {!! json_encode($seatConfig) !!};

    $('.seatCharts-container').css('height', "{{ $wide_board ? "240px" : "170px" }}");

    @if (!$aircraft->aisles)
        var mColumn = $(document).find(".seat-columns-m");
        mColumn.val("");
        mColumn.attr("disabled", "disabled");
    @endif

    $(".aisles").on("click", function(){

        var _this = $(this), mColumn = $(document).find(".seat-columns-m");

        if (_this.val() == 1) {
            mColumn.val("");
            mColumn.attr("disabled", "disabled");
        }
        else {
//            mColumn.val("");
            mColumn.removeAttr("disabled");
        }

    });

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        MapPassengersBySeat();

        ApplyTableFilter("#table");
    };

    loadScript("{{ asset("/assets/js/vendor/jquery.seat-charts.js") }}", function () {
        loadScript("{{ asset("/assets/js/views/flight-info/index.js?6") }}", function(){
            loadScript("{{ asset("/assets/js/views/aircraft/edit.js?2") }}", pagefunction);
        });
    });

</script>

