<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="content-section">

    @include('general.tab-header', ['departmentName' => 'Admin', 'moduleName' => $aircraft ? $aircraft->name : "-"." > Maintenances"])

            <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-md-12 no-padding margin-bottom-10">
                <a href="{{ route("homepage")."#".url("fleet-management") }}" class="btn btn-warning">Fleet Management</a>
            </div>

            <div class="clearfix"></div>

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#list" role="tab" data-toggle="tab">@lang("content.list")</a>
                </li>
                <li>
                    <a href="#add" role="tab" data-toggle="tab">@lang("content.add")</a>
                </li>
            </ul>

            <div id="tabContent" class="tab-content padding-10 background-white">

                <div class="tab-pane active" id="list">

                    @if (count($maintenance))
                            <table class="table table-bordered table-striped table-hover data" data-aircraftId={{ $aircraft->id }}>
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>@lang("content.notes")</th>
                                    <th>@lang("content.location")</th>
                                    <th>@lang("content.start_date")</th>
                                    <th>@lang("content.end_date")</th>

                                    @if (checkAuthorization(ADMIN))
                                        <th>@lang("content.updated_by")</th>
                                        <th>@lang("content.last_updated")</th>
                                    @endif

                                    <th>@lang("content.actions")</th>
                                </tr>
                                </thead>

                                <tbody>
                                @foreach ($maintenance as $i=>$item)
                                    @php $user = App\Models\User::find($item->user_id) @endphp
                                    <tr class="records">
                                        <td>{{ $i + 1 }}</td>
                                        <td class="editable" data-id={{ $item->id }} data-item="note" data-model = 'Maintenance' data-var_type = 'varchar'>{{ $item->note }}</td>
                                        <td class="editable" data-id={{ $item->id }} data-item="location_code" data-model = 'Maintenance' data-var_type = 'varchar'>{{ $item->location_code }}</td>
                                        <td class="editable" data-id={{ $item->id }} data-item="arrival_time" data-model = 'Maintenance' data-date_format = 'd M Y H:i'>{{ date('d M Y H:i', strtotime($item->arrival_time)) }}</td>
                                        <td class="editable" data-id={{ $item->id }} data-item="departure_time" data-model = 'Maintenance' data-date_format = 'd M Y H:i'>{{ date('d M Y H:i', strtotime($item->departure_time)) }}</td>

                                        @if (checkAuthorization(ADMIN))
                                            <td>{{ $user ? $user->first_name.' '.$user->last_name : '' }}</td>
                                            <td>{{ date('M d, Y H:i', strtotime($item->updated_at)) }}</td>
                                        @endif

                                        <td>
                                            <div class="btn-group">
                                                <a target="_blank" class="btn btn-primary btn-sm edit">@lang("content.edit")</a>
                                                <a href="{{ route("homepage")."#".url("aircraft/maintenance/delete/{$item->id}") }}"
                                                   data-confirm-text="Are you sure?"
                                                   class="btn btn-danger confirm btn-sm">@lang("content.remove")</a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                    @else
                        <p class="alert alert-info">@lang("content.found") 0 @lang("content.records")</p>
                    @endif
                </div>

                <div class="tab-pane" id="add">
                    @include("maintenance/form")
                </div>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var $errorInput = "{{ isset($message) ? $message["type"] : '' }}";

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    loadScript("{{ asset("/assets/js/views/aircraft/maintenance-list.js") }}", pagefunction);


</script>



