@php $airlineID = isset($airlineID) && $airlineID ? $airlineID : null @endphp
@php $currentAirlineId = isset($currentAirlineId) ? $currentAirlineId : '' @endphp
@php $urlAirlineID = $currentAirlineId ? $currentAirlineId : ($airlineID ? $airlineID : \request("airline_id")) @endphp
@php $addURL = "aircraft/add?s=".rand(100, 999) . ($airlineID ? "&airline_id={$airlineID}" : "") @endphp
@php $sprAdm = isSprAdm() @endphp

<div class="col-md-12 no-padding margin-bottom-10">
    <a target="_blank" href="{{ route("homepage")."#".url("{$addURL}") }}" class="btn btn-primary">@lang("content.add_new_aircraft")</a>
</div>

<div class="clearfix"></div>

@if (count($aircraft))
    <!-- Widget ID (each widget will need unique ID)-->
    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-aircraft" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
        <!-- widget options:
        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        data-widget-colorbutton="false"
        data-widget-editbutton="false"
        data-widget-togglebutton="false"
        data-widget-deletebutton="false"
        data-widget-fullscreenbutton="false"
        data-widget-custombutton="false"
        data-widget-collapsed="true"
        data-widget-sortable="false"

        -->
        <header>

            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

            <h2>@lang("content.list")</h2>


        </header>

        <!-- widget div-->
        <div class="editable_div">

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding">

                <div class="table-responsive">

                    @php $ghaModule = ghaModule() @endphp

                    <table class="table table-bordered table-hover" id="aircraft-table" style="min-width: 100% !important;">
                        <thead>
                        <tr>
                            <th rowspan="2">No</th>
                            <th rowspan="2">@lang("content.ac_reg")</th>
                            <th rowspan="2">MVT</th>
                            <th rowspan="2">HEX @lang("content.code")</th>
                            <th colspan="2">@lang("content.type")</th>
                            @if ($isAdmin)
                                <th rowspan="2">Type ID</th>
                                <th rowspan="2">STS</th>
                            @endif

                            @if ($ghaModule)
                                <th colspan="3">@lang("content.airline")</th>
                            @endif

                            <th rowspan="2">@lang("content.fleet_type")</th>
                            <th colspan="4">@lang("content.configuration")</th>
                            <th rowspan="2">@lang("content.flexi_config")</th>
                            <th rowspan="2">@lang("content.engine")</th>
                            <th rowspan="2">@lang("content.delivered")</th>

                            <th rowspan="2">MSN</th>
                            <th rowspan="2">@lang("content.line_number")</th>
                            <th rowspan="2">@lang("content.first_flight")</th>
                            <th rowspan="2">@lang("content.status")</th>
                            <th rowspan="2">@lang("content.email_forwarding")</th>
                            <th rowspan="2" style="min-width: 220px;">@lang("content.actions")</th>
                        </tr>
                        <tr>
                            <td>IATA</td>
                            <td>ICAO</td>

                            @if ($ghaModule)
                                <td>@lang("content.name")</td>
                                <td>IATA</td>
                                <td>ICAO</td>
                            @endif

                            <th>F</th>
                            <th>C</th>
                            <th>W</th>
                            <th>Y</th>
                        </tr>
                        </thead>

                        <tbody>
                        @foreach ($aircraft as $i => $each)

                            @if ($each->deleted_at)
                                @continue
                            @endif

                            <tr>
                                <td>{{ $i + 1 }}</td>
                                <td>{{ $each->name }}</td>
                                <td>{{ $each->mvt_name }}</td>
                                <td>@if ($sprAdm)
                                        <a href="#" data-field='hex_code' data-model="Aircraft" data-type="text" data-id='{{ $each->id }}'
                                           data-placeholder="Required"
                                           class="editable {{  $each->hex_code ? 'editable-click' : 'editable-empty'  }}">{{ $each->hex_code ? $each->hex_code : 'Empty' }}</a>
                                    @else
                                        {{ $each->hex_code }}
                                    @endif
                                </td>

                                @if ($each->type)
                                    <td>{{ $each->type->iata_name }}</td>
                                    <td>{{ $each->type->icao }}</td>
                                @else
                                    <td></td>
                                    <td></td>
                                @endif

                                @if ($isAdmin)
                                    <td>{{ $each->aircraft_type_id }}</td>
                                    <td>{{ $each->type && $each->type->deleted_at ? "DELETED" : "" }}</td>
                                @endif

                                @if ($ghaModule)
                                    @if ($each->airline)
                                        <td>{{ $each->airline->airline }}</td>
                                        <td>{{ $each->airline->iata }}</td>
                                        <td>{{ $each->airline->icao }}</td>
                                    @else
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    @endif
                                @endif

                                <td>{{ $each->type && $each->type->wide_board ? "W B" : "N B" }}</td>
                                <td>
                                    @if ($sprAdm)
                                        <a href="#" data-field='config_a' data-model="Aircraft" data-type="text" data-id='{{ $each->id }}'
                                           data-placeholder="Required"
                                           class="editable {{  $each->config_a || $each->config_a === 0 ? 'editable-click' : 'editable-empty'  }}">{{ $each->config_a || $each->config_a === 0 ? $each->config_a : 'Empty' }}</a>
                                    @else
                                        {{ $each->config_a }}
                                    @endif
                                </td>
                                <td>
                                    @if ($sprAdm)
                                        <a href="#" data-field='config_c' data-model="Aircraft" data-type="text" data-id='{{ $each->id }}'
                                           data-placeholder="Required"
                                           class="editable {{  $each->config_c || $each->config_c === 0 ? 'editable-click' : 'editable-empty'  }}">{{ $each->config_c || $each->config_c === 0 ? $each->config_c : 'Empty' }}</a>
                                    @else
                                        {{ $each->config_c }}
                                    @endif
                                </td>
                                <td>
                                    @if ($sprAdm)
                                        <a href="#" data-field='config_w' data-model="Aircraft" data-type="text" data-id='{{ $each->id }}'
                                           data-placeholder="Required"
                                           class="editable {{  $each->config_w || $each->config_w === 0 ? 'editable-click' : 'editable-empty'  }}">{{ $each->config_w || $each->config_w === 0 ? $each->config_w : 'Empty' }}</a>
                                    @else
                                        {{ $each->config_w }}
                                    @endif
                                </td>
                                <td>
                                    @if ($sprAdm)
                                        <a href="#" data-field='config_y' data-model="Aircraft" data-type="text" data-id='{{ $each->id }}'
                                           data-placeholder="Required"
                                           class="editable {{  $each->config_y || $each->config_y === 0 ? 'editable-click' : 'editable-empty'  }}">{{ $each->config_y || $each->config_y === 0 ? $each->config_y : 'Empty' }}</a>
                                    @else
                                        {{ $each->config_y }}
                                    @endif
                                </td>
                                <td>{!! $each->type && $each->type->flexi_config ? '<i class="fa fa-check"></i>' : '' !!}</td>
                                <td>{{ $each->engine ? $each->engine->name : "" }}</td>
                                <td>@if ($sprAdm)
                                        <a href="#" data-field='delivery_date' data-model="Aircraft" data-type="date" data-id='{{ $each->id }}'
                                           data-placeholder="Required" data-date_format="d-m-y"
                                           class="editable {{  $each->delivery_date ? 'editable-click' : 'editable-empty'  }}">{{ $each->delivery_date ? $each->delivery_date : 'Empty' }}</a>
                                    @else
                                        {{ $each->delivery_date }}
                                    @endif
                                </td>

                                <td>{{ $each->msn }}</td>
                                <td>{{ $each->line_number }}</td>
                                <td>{{ $each->first_flight && $each->first_flight != EMPTY_DATE ? $each->first_flight : ""}}</td>

                                <td>{!! ($each->maintenance_id) ? "<span class='glyphicon glyphicon-remove'></span>" : "<span class='glyphicon glyphicon-ok'></span>" !!}
                                </td>
                                <td data-center>{!! $each->email_recipients && trim($each->email_recipients) && !$each->stop_emails ? "<i class='glyphicon glyphicon-ok color-green'></i>" : "<i class='glyphicon glyphicon-remove color-red'></i>" !!}</td>
                                <td>
                                    <div class="btn-group">
                                        <a target="_blank" href="{{ route("homepage")."#". url("aircraft/show-flights/{$each->id}") }}"
                                           class="btn btn-primary btn-sm">@lang("content.show_flights")</a>
                                        <a target="_blank" href="{{ route("homepage")."#". url("aircraft/{$each->id}?current_airline_id={$currentAirlineId}") }}"
                                           class="btn btn-success btn-sm">@lang("content.view")</a>
                                        <a target="_blank" href="{{ route("homepage")."#". url("aircraft/{$each->id}/edit?s=".rand(100, 999)."&current_airline_id={$currentAirlineId}") }}"
                                           class="btn btn-warning btn-sm">@lang("content.edit")</a>
                                        <a href="{{ route("homepage")."#". url("aircraft/delete/{$each->id}?current_airline_id={$currentAirlineId}") }}"
                                           data-confirm-text="Are you sure?" class="btn btn-danger confirm btn-sm">@lang("content.remove")</a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>

                    </table>

                </div>

            </div>

{{--            {!! $aircraft->withPath(route("homepage")."#aircraft?airline_id={$urlAirlineID}")->links() !!}--}}

        </div>

    </div>
@endif
