@php $currentAirlineId = isset($currentAirlineId) ? $currentAirlineId : '' @endphp
@php $sprAdm = isSprAdm() @endphp

<div class="col-md-12 no-padding margin-bottom-10">
    <a target="_blank" href="{{ route("homepage")."#".url("aircraft/add-type?current_airline_id={$currentAirlineId}") }}" class="btn btn-primary">@lang("content.add_new_aircraft_type")</a>
</div>

<div class="clearfix"></div>

@if (count($types))
    <!-- Widget ID (each widget will need unique ID)-->
    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-aircraft-type" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
        <!-- widget options:
        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        data-widget-colorbutton="false"
        data-widget-editbutton="false"
        data-widget-togglebutton="false"
        data-widget-deletebutton="false"
        data-widget-fullscreenbutton="false"
        data-widget-custombutton="false"
        data-widget-collapsed="true"
        data-widget-sortable="false"

        -->
        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.list")</h2>

        </header>

        <!-- widget div-->
        <div class="editable_div">

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="min-height: 50px !important;">

                <div class="table-responsive">

                    <table class="table table-bordered table-hover" style="min-width: 100% !important;">
                    <thead>
                    <tr>
                        <th rowspan="2">No</th>
                        <th rowspan="2">@lang("content.name")</th>
                        <th rowspan="2">IATA</th>
                        <th rowspan="2">ICAO</th>
                        <th rowspan="2">@lang("content.number_of_aircraft")</th>

                        <th colspan="3">@lang("content.airline")</th>
                        <th rowspan="2">@lang("content.fleet_type")</th>
                        <th colspan="4" data-center>@lang("content.configuration")</th>
                        <th rowspan="2">@lang("content.flexi_config")</th>

                        <th colspan="2" data-center>FCM @lang("content.requirement")</th>
                        <th colspan="2" data-center>CCM @lang("content.requirement")</th>
{{--                        <th rowspan="2">@lang("content.wake_category")</th>--}}
                        <th rowspan="2" style="min-width: 120px;">@lang("content.actions")</th>
                    </tr>
                    <tr>
                        <td>@lang("content.name")</td>
                        <td>IATA</td>
                        <td>ICAO</td>

                        <th>F</th>
                        <th>C</th>
                        <th>W</th>
                        <th>Y</th>

                        <th>@lang("content.min")</th>
                        <th>@lang("content.pol")</th>

                        <th>@lang("content.min")</th>
                        <th>@lang("content.pol")</th>
                    </tr>
                    </thead>
                    <tbody>

                    @php $onlyAirline = isset($onlyAirline) && $onlyAirline @endphp
                    @php $onlyIATA = isset($onlyIATA) && $onlyIATA @endphp

                    @php $j = 0 @endphp
                    @foreach ($types as $i => $each)

                        @if ($each->deleted_at)
                            @continue
                        @endif

                        @if ($onlyAirline && !$each->airline)
                            @continue
                        @elseif($onlyIATA && $each->airline)
                            @continue
                        @endif

                        <tr>
                            <td>{{ ++$j }}</td>
                            <td><a target="_blank" href="{{ route("homepage")."#aircraft?type_id={$each->id}&airline_id={$each->airline_id}" }}">{{ $each->name }}</a></td>
                            <td>{{ $each->iata_name }}</td>
                            <td>{{ $each->icao }}</td>
                            <td data-center>{{ $each->aircraft ? $each->aircraft->count() : "-" }}</td>

                            <td>{{ $each->airline ? $each->airline->airline : "-" }}</td>
                            <td>{{ $each->airline ? $each->airline->iata : "-" }}</td>
                            <td>{{ $each->airline ? $each->airline->icao : "-" }}</td>

                            <td>{{ $each->wide_board ? "W B" : "N B" }}</td>
                            <td>
                                @if ($sprAdm)
                                    <a href="#" data-field='config_a' data-model="AircraftType" data-type="text" data-id='{{ $each->id }}'
                                       data-placeholder="Required"
                                       class="editable {{ $each->config_a || $each->config_a === 0 ? 'editable-click' : 'editable-empty'  }}">{{ $each->config_a || $each->config_a === 0 ? $each->config_a : 'Empty' }}</a>
                                @else
                                    {{ $each->config_a }}
                                @endif
                            </td>
                            <td>
                                @if ($sprAdm)
                                    <a href="#" data-field='config_c' data-model="AircraftType" data-type="text" data-id='{{ $each->id }}'
                                       data-placeholder="Required"
                                       class="editable {{  $each->config_c || $each->config_c === 0 ? 'editable-click' : 'editable-empty'  }}">{{ $each->config_c || $each->config_c === 0 ? $each->config_c : 'Empty' }}</a>
                                @else
                                    {{ $each->config_c }}
                                @endif
                            </td>
                            <td>
                                @if ($sprAdm)
                                    <a href="#" data-field='config_w' data-model="AircraftType" data-type="text" data-id='{{ $each->id }}'
                                       data-placeholder="Required"
                                       class="editable {{  $each->config_w || $each->config_w === 0 ? 'editable-click' : 'editable-empty'  }}">{{ $each->config_w || $each->config_w === 0 ? $each->config_w : 'Empty' }}</a>
                                @else
                                    {{ $each->config_w }}
                                @endif
                            </td>
                            <td>
                                @if ($sprAdm)
                                    <a href="#" data-field='config_y' data-model="AircraftType" data-type="text" data-id='{{ $each->id }}'
                                       data-placeholder="Required"
                                       class="editable {{  $each->config_y || $each->config_y === 0 ? 'editable-click' : 'editable-empty'  }}">{{ $each->config_y || $each->config_y === 0 ? $each->config_y : 'Empty' }}</a>
                                @else
                                    {{ $each->config_y }}
                                @endif
                            </td>

                            <td>{!! $each->flexi_config ? '<i class="fa fa-check"></i>' : '' !!}</td>
                            <td>{{ $each->min_fcm }}</td>
                            <td>{{ $each->policy_fcm }}</td>
                            <td>{{ $each->min_ccm }}</td>
                            <td>{{ $each->policy_ccm }}</td>

{{--                            <td>{{ $each->wake_category }}</td>--}}
                            <td>
                                <div class="btn-group">
                                    <a target="_blank" href="{{ route("homepage")."#".url("aircraft/edit-type?id={$each->id}&current_airline_id={$currentAirlineId}") }}" class="btn btn-primary btn-sm">@lang("content.edit")</a>
                                    <a href="{{ route("homepage")."#".url("aircraft/delete-type?id={$each->id}&current_airline_id={$currentAirlineId}") }}" data-confirm-text="Are you sure?" class="btn confirm btn-danger btn-sm">@lang("content.remove")</a>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                    </table>

                </div>

            </div>

{{--            {!! $types->withPath(route("homepage")."#aircraft")->links() !!}--}}

        </div>

    </div>
@endif